/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.exception;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Optional;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandler;
import org.mule.runtime.module.extension.internal.loader.java.property.ExceptionHandlerModelProperty;
import org.mule.runtime.module.extension.internal.runtime.exception.NullExceptionHandler;

public final class ExceptionHandlerManager {
    private static final ExceptionHandler DEFAULT_EXCEPTION_ENRICHER = new NullExceptionHandler();
    private final ExceptionHandler exceptionHandler;
    private final ErrorType connectionErrorType;

    public ExceptionHandlerManager(ExtensionModel extensionModel, ComponentModel componentModel) {
        this(extensionModel, componentModel, null);
    }

    public ExceptionHandlerManager(ExtensionModel extensionModel, ComponentModel componentModel, ErrorTypeRepository errorTypeRepository) {
        this.exceptionHandler = this.findExceptionHandler(extensionModel, (EnrichableModel)componentModel);
        this.connectionErrorType = errorTypeRepository == null ? null : this.resolveConnectionErrorType(extensionModel, errorTypeRepository);
    }

    private ErrorType resolveConnectionErrorType(ExtensionModel extensionModel, ErrorTypeRepository errorTypeRepository) {
        return extensionModel.getErrorModels().stream().filter(errorModel -> errorModel.getType().equals("CONNECTIVITY")).findFirst().map(errorModel -> errorTypeRepository.getErrorType(ComponentIdentifier.builder().namespace(errorModel.getNamespace()).name(errorModel.getType()).build()).orElse(null)).orElse(null);
    }

    public Throwable process(Throwable t) {
        Throwable handled = this.handleThrowable(t);
        Throwable result = this.enrich(handled);
        return result != null ? result : handled;
    }

    public Throwable handleThrowable(Throwable e) {
        Optional connectionException = ExceptionUtils.extractConnectionException((Throwable)e);
        if (connectionException.isPresent()) {
            return this.resolveConnectionException((ConnectionException)((Object)connectionException.get()));
        }
        return ExceptionUtils.extractCauseOfType((Throwable)e, UndeclaredThrowableException.class).orElse(e);
    }

    private Throwable resolveConnectionException(ConnectionException connectionException) {
        if (!connectionException.getErrorType().isPresent() && this.connectionErrorType != null) {
            ConnectionException newException = new ConnectionException(connectionException.getMessage(), connectionException.getCause(), this.connectionErrorType, connectionException.getConnection().orElse(null));
            newException.getInfo().putAll(connectionException.getInfo());
            return newException;
        }
        return connectionException;
    }

    private Throwable enrich(Throwable t) {
        return t instanceof Exception ? this.exceptionHandler.enrichException((Exception)t) : t;
    }

    private ExceptionHandler findExceptionHandler(ExtensionModel extension, EnrichableModel child) {
        return this.findExceptionHandler(child).orElseGet(() -> this.findExceptionHandler((EnrichableModel)extension).orElse(DEFAULT_EXCEPTION_ENRICHER));
    }

    private Optional<ExceptionHandler> findExceptionHandler(EnrichableModel model) {
        return model.getModelProperty(ExceptionHandlerModelProperty.class).map(p -> p.getExceptionHandlerFactory().createHandler());
    }

    ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }
}

