/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.api.time.TimeSupplier;
import org.mule.runtime.module.extension.internal.runtime.config.MutableConfigurationStats;

final class DefaultMutableConfigurationStats
implements MutableConfigurationStats {
    private final AtomicInteger inflightOperations = new AtomicInteger(0);
    private final AtomicInteger runningSources = new AtomicInteger(0);
    private final AtomicInteger activeComponents = new AtomicInteger(0);
    private final TimeSupplier timeSupplier;
    private long lastUsedMillis;

    public DefaultMutableConfigurationStats(TimeSupplier timeSupplier) {
        this.timeSupplier = timeSupplier;
        this.updateLastUsed();
    }

    @Override
    public long updateLastUsed() {
        this.lastUsedMillis = this.timeSupplier.get();
        return this.lastUsedMillis;
    }

    public long getLastUsedMillis() {
        return this.lastUsedMillis;
    }

    public int getInflightOperations() {
        return this.inflightOperations.get();
    }

    public int getRunningSources() {
        return this.runningSources.get();
    }

    public int getActiveComponents() {
        return this.activeComponents.get();
    }

    @Override
    public int addInflightOperation() {
        this.updateLastUsed();
        return this.inflightOperations.incrementAndGet();
    }

    @Override
    public int discountInflightOperation() {
        this.updateLastUsed();
        return this.inflightOperations.decrementAndGet();
    }

    @Override
    public int addRunningSource() {
        this.addActiveComponent();
        return this.runningSources.incrementAndGet();
    }

    @Override
    public int discountRunningSource() {
        this.discountActiveComponent();
        return this.runningSources.decrementAndGet();
    }

    @Override
    public int addActiveComponent() {
        this.updateLastUsed();
        return this.activeComponents.incrementAndGet();
    }

    @Override
    public int discountActiveComponent() {
        this.updateLastUsed();
        return this.activeComponents.decrementAndGet();
    }
}

