/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.core.api.source.scheduler.Scheduler;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.module.extension.internal.runtime.source.poll.PollingSourceWrapper;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class PollingSourceWrapperTestCase {
    public static final String TEST_FLOW_NAME = "myFlow";
    public static final String EXPECTED_WATERMARK_OS = "_pollingSource_myFlow/watermark";
    public static final String EXPECTED_RECENT_IDS_OS = "_pollingSource_myFlow/recently-processed-ids";
    public static final String EXPECTED_IDS_UPDATED_WATERMARK_OS = "_pollingSource_myFlow/ids-on-updated-watermark";
    public static final String EXPECTED_INFLIGHT_IDS_OS = "_pollingSource_myFlow/inflight-ids";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private LockFactory lockFactoryMock;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ObjectStoreManager objectStoreManagerMock;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private SchedulerService schedulerServiceMock;
    @Mock
    private ComponentLocation componentLocationMock;
    @Mock
    private SourceCallback callbackMock;
    @InjectMocks
    private PollingSourceWrapper<Object, Object> pollingSourceWrapper = new PollingSourceWrapper((PollingSource)Mockito.mock(PollingSource.class), (Scheduler)Mockito.mock(Scheduler.class));

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.componentLocationMock.getRootContainerName()).thenReturn((Object)TEST_FLOW_NAME);
        this.setComponentLocationMock();
    }

    @Test
    public void waterMarkingStoresGetCreatedOnStart() throws MuleException {
        this.pollingSourceWrapper.onStart(this.callbackMock);
        this.assertPersistentStoreIsCreated(EXPECTED_WATERMARK_OS, ObjectStoreSettings.DEFAULT_EXPIRATION_INTERVAL);
        this.assertPersistentStoreIsCreated(EXPECTED_RECENT_IDS_OS, ObjectStoreSettings.DEFAULT_EXPIRATION_INTERVAL);
        this.assertPersistentStoreIsCreated(EXPECTED_IDS_UPDATED_WATERMARK_OS, ObjectStoreSettings.DEFAULT_EXPIRATION_INTERVAL);
    }

    @Test
    public void idempotencyStoreGetsCreatedOnStart() throws MuleException {
        this.pollingSourceWrapper.onStart(this.callbackMock);
        this.assertTransientStoreIsCreated(EXPECTED_INFLIGHT_IDS_OS, ObjectStoreSettings.DEFAULT_EXPIRATION_INTERVAL);
    }

    private void assertPersistentStoreIsCreated(String expectedName, Long expirationInterval) {
        this.assertStoreIsCreated(expectedName, true, expirationInterval);
    }

    private void assertTransientStoreIsCreated(String expectedName, Long expirationInterval) {
        this.assertStoreIsCreated(expectedName, false, expirationInterval);
    }

    private void assertStoreIsCreated(String expectedName, boolean isPersistent, Long expirationInterval) {
        ArgumentCaptor settingsCaptor = ArgumentCaptor.forClass(ObjectStoreSettings.class);
        ((ObjectStoreManager)Mockito.verify((Object)this.objectStoreManagerMock)).getOrCreateObjectStore((String)ArgumentMatchers.eq((Object)expectedName), (ObjectStoreSettings)settingsCaptor.capture());
        ObjectStoreSettings watermarkSettings = (ObjectStoreSettings)settingsCaptor.getValue();
        MatcherAssert.assertThat((Object)watermarkSettings.isPersistent(), (Matcher)CoreMatchers.is((Object)isPersistent));
        MatcherAssert.assertThat((Object)watermarkSettings.getExpirationInterval(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)expirationInterval)));
    }

    private void setComponentLocationMock() throws Exception {
        ClassUtils.setFieldValue(this.pollingSourceWrapper, (String)"componentLocation", (Object)this.componentLocationMock, (boolean)false);
    }
}

