/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.lang.reflect.InvocationTargetException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.module.extension.internal.runtime.source.DefaultSourceFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.HeisenbergSource;

@SmallTest
public class DefaultSourceFactoryTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void create() {
        Assert.assertThat((Object)new DefaultSourceFactory(HeisenbergSource.class).createSource(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HeisenbergSource.class)));
    }

    @Test
    public void nullType() {
        this.expectedException.expect(IllegalArgumentException.class);
        new DefaultSourceFactory(null);
    }

    @Test
    public void notInstantiable() {
        this.expectedException.expect(IllegalArgumentException.class);
        new DefaultSourceFactory(Source.class);
    }

    @Test
    public void exceptionOnInstantiation() {
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectCause(Matchers.instanceOf(InvocationTargetException.class));
        new DefaultSourceFactory(UncreatableSource.class).createSource();
    }

    public static class UncreatableSource
    extends Source {
        public UncreatableSource() {
            throw new IllegalArgumentException();
        }

        public void onStart(SourceCallback sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }
}

