/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.DefaultExpressionLanguageFactoryService;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.metadata.CollectionDataType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MapDataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.retry.policy.NoRetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.el.DefaultExpressionManager;
import org.mule.runtime.core.internal.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.core.internal.event.EventQuickCopy;
import org.mule.runtime.core.internal.policy.OperationExecutionFunction;
import org.mule.runtime.core.internal.policy.OperationParametersProcessor;
import org.mule.runtime.core.internal.policy.OperationPolicy;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.core.internal.streaming.CursorUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.ValueResolvingException;
import org.mule.runtime.module.extension.internal.runtime.operation.AbstractOperationMessageProcessorTestCase;
import org.mule.runtime.module.extension.internal.runtime.operation.IllegalOperationException;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.PrecalculatedExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.weave.v2.el.WeaveDefaultExpressionLanguageFactoryService;
import reactor.core.publisher.Mono;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class OperationMessageProcessorTestCase
extends AbstractOperationMessageProcessorTestCase {
    private static final String SOME_PARAM_NAME = "someParam";
    private static final String FLOW_NAME = "flowName";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final ReflectionCache reflectionCache = new ReflectionCache();
    @Mock
    private ExpressionManager expressionManager;

    @Override
    protected OperationMessageProcessor createOperationMessageProcessor() {
        OperationMessageProcessor operationMessageProcessor = new OperationMessageProcessor(this.extensionModel, this.operationModel, this.configurationProvider, this.target, this.targetValue, this.resolverSet, (CursorProviderFactory)this.cursorStreamProviderFactory, (RetryPolicyTemplate)new NoRetryPolicyTemplate(), this.extensionManager, this.mockPolicyManager, this.reflectionCache, null);
        operationMessageProcessor.setAnnotations(OperationMessageProcessorTestCase.getFlowComponentLocationAnnotations((String)FLOW_NAME));
        return operationMessageProcessor;
    }

    @Test
    public void operationContextIsWellFormed() throws Exception {
        ArgumentCaptor operationContextCaptor = ArgumentCaptor.forClass(ExecutionContext.class);
        this.messageProcessor.process(this.event);
        ((ComponentExecutor)Mockito.verify((Object)this.operationExecutor)).execute((ExecutionContext)operationContextCaptor.capture());
        ExecutionContext executionContext = (ExecutionContext)operationContextCaptor.getValue();
        Assert.assertThat((Object)executionContext, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ExecutionContextAdapter.class)));
        ExecutionContextAdapter executionContextAdapter = (ExecutionContextAdapter)executionContext;
        Assert.assertThat((Object)executionContextAdapter.getEvent(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.event)));
        Assert.assertThat((Object)((ConfigurationInstance)executionContextAdapter.getConfiguration().get()).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.configuration)));
    }

    @Test
    public void operationExecutorIsInvoked() throws Exception {
        this.messageProcessor.process(this.event);
        ((ComponentExecutor)Mockito.verify((Object)this.operationExecutor)).execute((ExecutionContext)ArgumentMatchers.any(ExecutionContext.class));
    }

    @Test
    public void operationReturnsOperationResultWhichKeepsNoValues() throws Exception {
        Object payload = new Object();
        MediaType mediaType = MediaType.ANY.withCharset(SystemUtils.getDefaultEncoding((MuleContext)this.context));
        Object attributes = Mockito.mock(Object.class);
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)ArgumentMatchers.any(ExecutionContext.class))).thenReturn((Object)Mono.just((Object)Result.builder().output(payload).mediaType(mediaType).attributes(attributes).build()));
        Message message = this.messageProcessor.process(this.event).getMessage();
        Assert.assertThat((Object)message, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)payload)));
        Assert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)attributes)));
        Assert.assertThat((Object)message.getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)mediaType));
    }

    @Test
    public void operationReturnsOperationResultOnTarget() throws Exception {
        this.target = "myFlowVar";
        this.messageProcessor = this.setUpOperationMessageProcessor();
        Object payload = new Object();
        MediaType mediaType = MediaType.ANY.withCharset(SystemUtils.getDefaultEncoding((MuleContext)this.context));
        Object attributes = Mockito.mock(Object.class);
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)ArgumentMatchers.any(ExecutionContext.class))).thenReturn((Object)Mono.just((Object)Result.builder().output(payload).mediaType(mediaType).attributes(attributes).build()));
        Message message = (Message)((TypedValue)this.messageProcessor.process(this.event).getVariables().get("myFlowVar")).getValue();
        Assert.assertThat((Object)message, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)payload)));
        Assert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)attributes)));
        Assert.assertThat((Object)message.getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.equalTo((Object)mediaType));
    }

    @Test
    public void operationReturnsOperationResultButKeepsAttributes() throws Exception {
        Object payload = new Object();
        MediaType mediaType = MediaType.ANY.withCharset(SystemUtils.getDefaultEncoding((MuleContext)this.context));
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)ArgumentMatchers.any(ExecutionContext.class))).thenReturn((Object)Mono.just((Object)Result.builder().output(payload).mediaType(mediaType).build()));
        this.event = CoreEvent.builder((CoreEvent)this.event).message(Message.builder().value((Object)"").attributesValue(Mockito.mock(Object.class)).build()).build();
        Message message = this.messageProcessor.process(this.event).getMessage();
        Assert.assertThat((Object)message, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)payload)));
        Assert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)message.getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.equalTo((Object)mediaType));
    }

    @Test
    public void operationReturnsOperationResultThatOnlySpecifiesPayload() throws Exception {
        String payload = "hello world!";
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)ArgumentMatchers.any(ExecutionContext.class))).thenReturn((Object)Mono.just((Object)Result.builder().output((Object)payload).build()));
        this.event = CoreEvent.builder((CoreEvent)this.event).message(Message.builder().value((Object)"").attributesValue(Mockito.mock(Object.class)).build()).build();
        Message message = this.messageProcessor.process(this.event).getMessage();
        Assert.assertThat((Object)message, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)payload)));
        Assert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)message.getPayload().getDataType().getType().equals(String.class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void operationReturnsOperationResultWithPayloadAndAttributes() throws Exception {
        String payload = "hello world!";
        Object attributes = Mockito.mock(Object.class);
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)ArgumentMatchers.any(ExecutionContext.class))).thenReturn((Object)Mono.just((Object)Result.builder().output((Object)payload).attributes(attributes).build()));
        Message message = this.messageProcessor.process(this.event).getMessage();
        Assert.assertThat((Object)message, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)payload)));
        Assert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)attributes)));
        Assert.assertThat((Object)message.getPayload().getDataType().getType().equals(String.class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void operationReturnsPayloadValue() throws Exception {
        Object value = new Object();
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)ArgumentMatchers.any(ExecutionContext.class))).thenReturn((Object)Mono.just((Object)value));
        Message message = this.messageProcessor.process(this.event).getMessage();
        Assert.assertThat((Object)message, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)value)));
    }

    @Test
    public void operationReturnsMapWithCorrectDataType() throws Exception {
        HashMap payload = new HashMap();
        this.setUpOperationReturning(payload, new TypeToken<Map<String, String>>(){}.getType());
        Message message = this.messageProcessor.process(this.event).getMessage();
        Assert.assertThat((Object)message, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance(payload)));
        DataType dataType = message.getPayload().getDataType();
        Assert.assertThat((Object)dataType, (Matcher)CoreMatchers.instanceOf(MapDataType.class));
        Assert.assertThat((Object)((MapDataType)dataType).getKeyDataType(), (Matcher)DataTypeMatcher.like(String.class, (MediaType)MediaType.ANY.withCharset(null)));
        Assert.assertThat((Object)((MapDataType)dataType).getValueDataType(), (Matcher)DataTypeMatcher.like(String.class, (MediaType)MediaType.ANY));
    }

    @Test
    public void operationReturnsResultMapWithCorrectDataType() throws Exception {
        HashMap payload = new HashMap();
        this.setUpOperationReturning(Result.builder().output(payload).build(), new TypeToken<Map<String, String>>(){}.getType());
        Message message = this.messageProcessor.process(this.event).getMessage();
        Assert.assertThat((Object)message, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance(payload)));
        DataType dataType = message.getPayload().getDataType();
        Assert.assertThat((Object)dataType, (Matcher)CoreMatchers.instanceOf(MapDataType.class));
        Assert.assertThat((Object)((MapDataType)dataType).getKeyDataType(), (Matcher)DataTypeMatcher.like(String.class, (MediaType)MediaType.ANY.withCharset(null)));
        Assert.assertThat((Object)((MapDataType)dataType).getValueDataType(), (Matcher)DataTypeMatcher.like(String.class, (MediaType)MediaType.ANY));
    }

    @Test
    public void operationReturnsCollectionWithCorrectDataType() throws Exception {
        ArrayList payload = new ArrayList();
        this.setUpOperationReturning(payload, new TypeToken<List<Integer>>(){}.getType());
        Message message = this.messageProcessor.process(this.event).getMessage();
        Assert.assertThat((Object)message, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance(payload)));
        DataType dataType = message.getPayload().getDataType();
        Assert.assertThat((Object)dataType, (Matcher)CoreMatchers.instanceOf(CollectionDataType.class));
        Assert.assertThat((Object)((CollectionDataType)dataType).getItemDataType(), (Matcher)DataTypeMatcher.like(Integer.class, (MediaType)MediaType.ANY.withCharset(null)));
    }

    @Test
    public void operationReturnsResultCollectionWithCorrectDataType() throws Exception {
        ArrayList payload = new ArrayList();
        this.setUpOperationReturning(Result.builder().output(payload).build(), new TypeToken<List<Integer>>(){}.getType());
        Message message = this.messageProcessor.process(this.event).getMessage();
        Assert.assertThat((Object)message, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance(payload)));
        DataType dataType = message.getPayload().getDataType();
        Assert.assertThat((Object)dataType, (Matcher)CoreMatchers.instanceOf(CollectionDataType.class));
        Assert.assertThat((Object)((CollectionDataType)dataType).getItemDataType(), (Matcher)DataTypeMatcher.like(Integer.class, (MediaType)MediaType.ANY.withCharset(null)));
    }

    @Test
    public void operationReturnsPayloadValueWithTarget() throws Exception {
        this.target = "myFlowVar";
        this.messageProcessor = this.setUpOperationMessageProcessor();
        Object value = new Object();
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)ArgumentMatchers.any(ExecutionContext.class))).thenReturn((Object)Mono.just((Object)value));
        Message message = (Message)((TypedValue)this.messageProcessor.process(this.event).getVariables().get("myFlowVar")).getValue();
        Assert.assertThat((Object)message, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)value)));
    }

    @Test
    public void operationWithExpressionInTargetParameter() throws Exception {
        String flowName = FLOW_NAME;
        this.target = "#[mel:someExpression]";
        this.messageProcessor = this.createOperationMessageProcessor();
        MuleContextUtils.registerIntoMockContext((MuleContextWithRegistry)this.context, (String)"_muleExpressionLanguage", (Object)new MVELExpressionLanguage((MuleContext)this.context));
        MuleContextUtils.registerIntoMockContext((MuleContextWithRegistry)this.context, DefaultExpressionLanguageFactoryService.class, (Object)new WeaveDefaultExpressionLanguageFactoryService(null));
        ((MuleContextWithRegistry)Mockito.doReturn((Object)new DefaultExpressionManager()).when((Object)this.context)).getExpressionManager();
        FlowConstruct flowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)flowConstruct.getName()).thenReturn((Object)flowName);
        this.messageProcessor.setMuleContext((MuleContext)this.context);
        this.expectedException.expect(IllegalOperationException.class);
        this.expectedException.expectMessage(String.format("Root component '%s' defines an invalid usage of operation '%s' which uses %s as %s", flowName, this.operationModel.getName(), "an expression", "target"));
        this.messageProcessor.initialise();
    }

    @Test
    public void operationWithoutExpressionInTargetValueParameter() throws Exception {
        String flowName = FLOW_NAME;
        this.target = "myFlowVar";
        this.targetValue = "myFlowVar";
        this.messageProcessor = this.createOperationMessageProcessor();
        MuleContextUtils.registerIntoMockContext((MuleContextWithRegistry)this.context, (String)"_muleExpressionLanguage", (Object)new MVELExpressionLanguage((MuleContext)this.context));
        MuleContextUtils.registerIntoMockContext((MuleContextWithRegistry)this.context, DefaultExpressionLanguageFactoryService.class, (Object)new WeaveDefaultExpressionLanguageFactoryService(null));
        ((MuleContextWithRegistry)Mockito.doReturn((Object)new DefaultExpressionManager()).when((Object)this.context)).getExpressionManager();
        FlowConstruct flowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)flowConstruct.getName()).thenReturn((Object)flowName);
        this.messageProcessor.setMuleContext((MuleContext)this.context);
        this.expectedException.expect(IllegalOperationException.class);
        this.expectedException.expectMessage(String.format("Root component '%s' defines an invalid usage of operation '%s' which uses %s as %s", flowName, this.operationModel.getName(), "something that is not an expression", "targetValue"));
        this.messageProcessor.initialise();
    }

    @Test
    public void operationIsVoid() throws Exception {
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)new ImmutableOutputModel("Message.Payload", ExtensionsTestUtils.toMetadataType(Void.TYPE), false, Collections.emptySet()));
        this.messageProcessor = this.setUpOperationMessageProcessor();
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)ArgumentMatchers.any(ExecutionContext.class))).thenReturn((Object)Mono.empty());
        Assert.assertThat((Object)this.messageProcessor.process(this.event), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.event)));
    }

    @Test
    public void executesWithDefaultConfig() throws Exception {
        this.configurationName = null;
        this.messageProcessor = this.setUpOperationMessageProcessor();
        Object defaultConfigInstance = new Object();
        Mockito.when((Object)this.configurationInstance.getValue()).thenReturn(defaultConfigInstance);
        Mockito.when((Object)this.extensionManager.getConfiguration(this.extensionModel, (ComponentModel)this.operationModel, this.event)).thenReturn(Optional.of(this.configurationInstance));
        ArgumentCaptor operationContextCaptor = ArgumentCaptor.forClass(ExecutionContext.class);
        this.messageProcessor.process(this.event);
        ((ComponentExecutor)Mockito.verify((Object)this.operationExecutor)).execute((ExecutionContext)operationContextCaptor.capture());
        ExecutionContext executionContext = (ExecutionContext)operationContextCaptor.getValue();
        Assert.assertThat((Object)executionContext, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ExecutionContextAdapter.class)));
        Assert.assertThat((Object)((ConfigurationInstance)executionContext.getConfiguration().get()).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)defaultConfigInstance)));
    }

    @Test
    public void executeWithPolicy() throws Exception {
        this.messageProcessor.setAnnotations(Collections.singletonMap(AbstractComponent.LOCATION_KEY, TEST_CONNECTOR_LOCATION));
        this.messageProcessor.process(this.event);
        ((PolicyManager)Mockito.verify((Object)this.mockPolicyManager)).createOperationPolicy((Component)ArgumentMatchers.eq((Object)this.messageProcessor), (CoreEvent)ArgumentMatchers.same((Object)this.event), (OperationParametersProcessor)ArgumentMatchers.any(OperationParametersProcessor.class));
        ((OperationPolicy)Mockito.verify((Object)this.mockOperationPolicy)).process((CoreEvent)ArgumentMatchers.same((Object)this.event), (OperationExecutionFunction)ArgumentMatchers.any(OperationExecutionFunction.class), (OperationParametersProcessor)ArgumentMatchers.any(), (ComponentLocation)ArgumentMatchers.any());
    }

    @Test
    public void skipPolicyWithNoComponentLocation() throws Exception {
        this.messageProcessor.setAnnotations(new HashMap());
        this.messageProcessor.process(this.event);
        Assert.assertThat((Object)this.mockOperationPolicy, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        ((PolicyManager)Mockito.verify((Object)this.mockPolicyManager, (VerificationMode)Mockito.never())).createOperationPolicy((Component)ArgumentMatchers.eq((Object)this.messageProcessor), (CoreEvent)ArgumentMatchers.same((Object)this.event), (OperationParametersProcessor)ArgumentMatchers.any(OperationParametersProcessor.class));
    }

    @Test
    public void getMetadataKeyIdObjectValue() throws MuleException, ValueResolvingException {
        this.setUpValueResolvers();
        Object metadataKeyValue = this.messageProcessor.getParameterValueResolver().getParameterValue(SOME_PARAM_NAME);
        Assert.assertThat((Object)metadataKeyValue, (Matcher)CoreMatchers.is((Object)"person"));
    }

    @Test
    public void getProcessingType() {
        this.assertProcessingType(ExecutionType.CPU_INTENSIVE, ReactiveProcessor.ProcessingType.CPU_INTENSIVE);
        this.assertProcessingType(ExecutionType.CPU_LITE, ReactiveProcessor.ProcessingType.CPU_LITE);
        this.assertProcessingType(ExecutionType.BLOCKING, ReactiveProcessor.ProcessingType.BLOCKING);
    }

    @Test
    public void precalculateExecutionContextForInterceptedProcessor() throws MuleException {
        AtomicReference context = new AtomicReference();
        this.messageProcessor.resolveParameters(CoreEvent.builder((CoreEvent)this.event), (params, ctx) -> {
            Assert.assertThat((Object)ctx, (Matcher)CoreMatchers.instanceOf(PrecalculatedExecutionContextAdapter.class));
            context.set(Mockito.spy((Object)((PrecalculatedExecutionContextAdapter)ctx)));
        });
        this.messageProcessor.process((CoreEvent)EventQuickCopy.quickCopy((CoreEvent)this.event, (Map)ImmutableMap.of((Object)"core:interceptionResolvedContext", context.get(), (Object)"core:interceptionComponent", (Object)this.messageProcessor)));
        ((ComponentExecutor)Mockito.verify((Object)this.operationExecutor)).execute((ExecutionContext)context.get());
        ((PrecalculatedExecutionContextAdapter)Mockito.verify(context.get(), (VerificationMode)Mockito.atLeastOnce())).getConfiguration();
        this.messageProcessor.disposeResolvedParameters((ExecutionContext)context.get());
    }

    @Test
    public void newExecutionContextForNonInterceptedProcessor() throws MuleException {
        AtomicReference context = new AtomicReference();
        ImmutableMap newContextParameters = ImmutableMap.of((Object)"outputMimeType", (Object)MediaType.ANY.toRfcString(), (Object)"outputEncoding", (Object)Charset.defaultCharset().name());
        ((ResolverSetResult)Mockito.doReturn((Object)newContextParameters).when((Object)this.parameters)).asMap();
        ((ResolverSet)Mockito.doReturn((Object)this.parameters).when((Object)this.resolverSet)).resolve((ValueResolvingContext)ArgumentMatchers.any(ValueResolvingContext.class));
        this.messageProcessor.resolveParameters(CoreEvent.builder((CoreEvent)this.event), (params, ctx) -> {
            Assert.assertThat((Object)ctx, (Matcher)CoreMatchers.instanceOf(PrecalculatedExecutionContextAdapter.class));
            context.set(Mockito.spy((Object)((PrecalculatedExecutionContextAdapter)ctx)));
        });
        this.messageProcessor.process((CoreEvent)EventQuickCopy.quickCopy((CoreEvent)this.event, Collections.singletonMap("core:interceptionResolvedContext", context.get())));
        ((ComponentExecutor)Mockito.verify((Object)this.operationExecutor, (VerificationMode)Mockito.never())).execute((ExecutionContext)context.get());
        ((ComponentExecutor)Mockito.verify((Object)this.operationExecutor)).execute((ExecutionContext)ArgumentMatchers.any(ExecutionContext.class));
        ((PrecalculatedExecutionContextAdapter)Mockito.verify(context.get(), (VerificationMode)Mockito.never())).getConfiguration();
        this.messageProcessor.disposeResolvedParameters((ExecutionContext)context.get());
    }

    @Test
    public void cursorStreamProvidersAreManaged() throws Exception {
        CursorStreamProvider provider = (CursorStreamProvider)Mockito.mock(CursorStreamProvider.class);
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        ((CursorStreamProviderFactory)Mockito.doReturn((Object)provider).when((Object)this.cursorStreamProviderFactory)).of((EventContext)((BaseEventContext)this.event.getContext()).getRootContext(), (Object)inputStream, (ComponentLocation)DefaultComponentLocation.fromSingleComponent((String)FLOW_NAME));
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)ArgumentMatchers.any())).thenReturn((Object)Mono.just((Object)inputStream));
        this.messageProcessor.process(this.event);
        ArgumentCaptor providerCaptor = ArgumentCaptor.forClass(CursorProvider.class);
        ((StreamingManager)Mockito.verify((Object)this.streamingManager)).manage((CursorProvider)providerCaptor.capture(), (EventContext)ArgumentMatchers.any(EventContext.class));
        Assert.assertThat((Object)CursorUtils.unwrap((CursorProvider)((CursorProvider)providerCaptor.getValue())), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)provider)));
    }

    private void assertProcessingType(ExecutionType executionType, ReactiveProcessor.ProcessingType expectedProcessingType) {
        Mockito.when((Object)this.operationModel.getExecutionType()).thenReturn((Object)executionType);
        Assert.assertThat((Object)this.messageProcessor.getProcessingType(), (Matcher)CoreMatchers.is((Object)expectedProcessingType));
    }

    private Set<MetadataKey> getKeysFromContainer(MetadataKeysContainer metadataKeysContainer) {
        return (Set)metadataKeysContainer.getKeys((String)metadataKeysContainer.getCategories().iterator().next()).get();
    }

    private void setUpValueResolvers() throws MuleException {
        HashMap<String, ValueResolver> valueResolvers = new HashMap<String, ValueResolver>();
        Mockito.when((Object)this.resolverSet.getResolvers()).thenReturn(valueResolvers);
        ValueResolver valueResolver = (ValueResolver)Mockito.mock(ValueResolver.class);
        valueResolvers.put(SOME_PARAM_NAME, valueResolver);
        Mockito.when((Object)valueResolver.resolve((ValueResolvingContext)ArgumentMatchers.any(ValueResolvingContext.class))).thenReturn((Object)"person");
    }

    private void setUpOperationReturning(Object payload, Type type) throws InitialisationException {
        this.messageProcessor = this.createOperationMessageProcessor();
        MetadataType mapType = new DefaultExtensionsTypeLoaderFactory().createTypeLoader().load(type);
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)new ImmutableOutputModel("desc", mapType, false, Collections.emptySet()));
        LifecycleUtils.initialiseIfNeeded((Object)this.messageProcessor, (MuleContext)muleContext);
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)ArgumentMatchers.any(ExecutionContext.class))).thenReturn((Object)Mono.just((Object)payload));
    }
}

