/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;
import org.mule.functional.junit4.matchers.ThrowableRootCauseMatcher;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.error.ImmutableErrorModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.retry.policy.NoRetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.SimpleRetryPolicyTemplate;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.connection.DefaultConnectionManager;
import org.mule.runtime.core.internal.connection.ReconnectableConnectionProviderWrapper;
import org.mule.runtime.core.internal.message.ErrorTypeBuilder;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;
import org.mule.runtime.core.internal.util.rx.ImmediateScheduler;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.mule.runtime.extension.api.runtime.Interceptable;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandler;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.config.MutableConfigurationStats;
import org.mule.runtime.module.extension.internal.runtime.operation.DefaultExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.ExecutionMediator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.heisenberg.extension.HeisenbergErrors;
import org.mule.test.heisenberg.extension.exception.HeisenbergException;
import org.mule.test.heisenberg.extension.exception.NullExceptionEnricher;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

@SmallTest
@RunWith(value=Parameterized.class)
public class DefaultExecutionMediatorTestCase
extends AbstractMuleContextTestCase {
    public static final int RETRY_COUNT = 10;
    private static final String DUMMY_NAME = "dummyName";
    private static final String ERROR = "Error";
    private final Object result = new Object();
    @Rule
    public MockitoRule mockito = MockitoJUnit.rule();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExecutionContextAdapter operationContext;
    @Mock(extraInterfaces={Interceptable.class}, lenient=true)
    private ConfigurationInstance configurationInstance;
    @Mock
    private MutableConfigurationStats configurationStats;
    @Mock(extraInterfaces={Interceptable.class}, lenient=true)
    private ComponentExecutor operationExecutor;
    @Mock
    private ComponentExecutor operationExceptionExecutor;
    @Mock
    private Interceptor configurationInterceptor1;
    @Mock
    private Interceptor configurationInterceptor2;
    @Mock
    private Interceptor operationInterceptor1;
    @Mock
    private Interceptor operationInterceptor2;
    @Mock
    private ExceptionHandler exceptionEnricher;
    @Mock
    private ConfigurationModel configurationModel;
    @Mock(lenient=true)
    private ExtensionModel extensionModel;
    @Mock
    private OperationModel operationModel;
    @Mock
    private ConnectionManagerAdapter connectionManagerAdapter;
    private String name;
    private final RetryPolicyTemplate retryPolicy;
    private final ConnectionException connectionException = new ConnectionException("Connection failure");
    private final Exception exception = new Exception();
    private InOrder inOrder;
    private List<Interceptor> orderedInterceptors;
    private ExecutionMediator mediator;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"With simple retry", new SimpleRetryPolicyTemplate(10L, 10)}, {"With no retry", new NoRetryPolicyTemplate()});
    }

    public DefaultExecutionMediatorTestCase(String name, RetryPolicyTemplate retryPolicy) {
        this.name = name;
        this.retryPolicy = retryPolicy;
    }

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.configurationInstance.getStatistics()).thenReturn((Object)this.configurationStats);
        Mockito.when((Object)this.configurationInstance.getName()).thenReturn((Object)DUMMY_NAME);
        Mockito.when((Object)this.configurationInstance.getModel()).thenReturn((Object)this.configurationModel);
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)DUMMY_NAME);
        Mockito.when((Object)this.extensionModel.getModelProperty(ClassLoaderModelProperty.class)).thenReturn(Optional.empty());
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.extensionModel, null);
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, null);
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)this.operationContext)).thenReturn((Object)Mono.just((Object)this.result));
        Mockito.when((Object)this.operationExceptionExecutor.execute((ExecutionContext)this.operationContext)).thenReturn((Object)Mono.error((Throwable)this.exception));
        Mockito.when((Object)this.operationContext.getConfiguration()).thenReturn(Optional.of(this.configurationInstance));
        Mockito.when((Object)this.operationContext.getExtensionModel()).thenReturn((Object)this.extensionModel);
        Mockito.when((Object)this.operationContext.getTransactionConfig()).thenReturn(Optional.empty());
        Mockito.when((Object)this.operationContext.getRetryPolicyTemplate()).thenReturn(Optional.ofNullable(this.retryPolicy));
        Mockito.when((Object)this.operationContext.getCurrentScheduler()).thenReturn((Object)ImmediateScheduler.IMMEDIATE_SCHEDULER);
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setPrefix("test-extension").build());
        this.mediator = new DefaultExecutionMediator(this.extensionModel, (ComponentModel)this.operationModel, (ConnectionManagerAdapter)new DefaultConnectionManager(muleContext), muleContext.getErrorTypeRepository(), new DefaultExecutionMediator.ValueTransformer[0]);
        ReconnectableConnectionProviderWrapper connectionProviderWrapper = new ReconnectableConnectionProviderWrapper(null, new ReconnectionConfig(true, (RetryPolicyTemplate)new SimpleRetryPolicyTemplate(10L, 10)));
        LifecycleUtils.initialiseIfNeeded((Object)connectionProviderWrapper, (boolean)true, (MuleContext)muleContext);
        Optional<ReconnectableConnectionProviderWrapper> connectionProvider = Optional.of(connectionProviderWrapper);
        Mockito.when((Object)this.configurationInstance.getConnectionProvider()).thenReturn(connectionProvider);
        Mockito.when((Object)this.exceptionEnricher.enrichException((Exception)ArgumentMatchers.any())).thenAnswer(inv -> {
            Throwable toEnrich = (Throwable)inv.getArgument(0);
            if (toEnrich == this.exception || toEnrich.getCause() == this.exception) {
                return new HeisenbergException(ERROR, toEnrich);
            }
            return toEnrich;
        });
        this.setInterceptors((Interceptable)this.configurationInstance, this.configurationInterceptor1, this.configurationInterceptor2);
        this.setInterceptors((Interceptable)this.operationExecutor, this.operationInterceptor1, this.operationInterceptor2);
        this.defineOrder(this.configurationInterceptor1, this.configurationInterceptor2, this.operationInterceptor1, this.operationInterceptor2);
    }

    @Test
    public void interceptorsInvokedOnSuccess() throws Throwable {
        Object result = this.execute().block();
        this.assertBefore();
        this.assertOnSuccess(Mockito.times((int)1));
        this.assertOnError(Mockito.never());
        this.assertAfter(result);
        this.assertResult(result);
    }

    @Test
    public void interceptorsInvokedOnError() throws Throwable {
        this.stubException();
        this.assertException(e -> {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ConnectionException.class)));
            try {
                this.assertBefore();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
            this.assertOnSuccess(Mockito.never());
            this.assertOnError(Mockito.times((int)1));
            this.assertAfter(null);
        });
    }

    @Test
    public void decoratedException() throws Throwable {
        this.stubException();
        Exception decoratedException = (Exception)Mockito.mock(Exception.class);
        Mockito.when((Object)this.configurationInterceptor2.onError((ExecutionContext)ArgumentMatchers.same((Object)this.operationContext), (Throwable)ArgumentMatchers.same((Object)this.connectionException))).thenReturn((Object)decoratedException);
        this.assertException(e -> {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)decoratedException)));
            this.assertAfter(null);
        });
    }

    @Test
    public void exceptionOnBefore() throws Throwable {
        this.stubExceptionOnBeforeInterceptor();
        this.assertException(e -> {
            try {
                Assert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.exception)));
                this.assertBefore();
                this.assertOnError(Mockito.never());
                ((ComponentExecutor)Mockito.verify((Object)this.operationExecutor, (VerificationMode)Mockito.never())).execute((ExecutionContext)this.operationContext);
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        });
    }

    @Test
    public void configurationStatsOnSuccessfulOperation() throws Throwable {
        this.execute().block();
        this.assertStatistics();
    }

    @Test
    public void configurationStatsOnFailedOperation() throws Throwable {
        this.stubException();
        this.assertException(e -> this.assertStatistics());
    }

    @Test
    public void configurationStatsOnFailedBeforeInterceptor() throws Throwable {
        this.stubExceptionOnBeforeInterceptor();
        this.assertException(e -> this.assertStatistics());
    }

    @Test
    public void enrichThrownException() throws Throwable {
        this.expectedException.expect(ThrowableRootCauseMatcher.hasRootCause((Matcher)CoreMatchers.sameInstance((Object)this.exception)));
        this.expectedException.expectCause(CoreMatchers.instanceOf(HeisenbergException.class));
        this.expectedException.expectMessage(ERROR);
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, () -> this.exceptionEnricher);
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)ArgumentMatchers.any())).thenReturn((Object)Mono.error((Throwable)this.exception));
        Mono.from((Publisher)new DefaultExecutionMediator(this.extensionModel, (ComponentModel)this.operationModel, (ConnectionManagerAdapter)new DefaultConnectionManager(muleContext), muleContext.getErrorTypeRepository(), new DefaultExecutionMediator.ValueTransformer[0]).execute(this.operationExceptionExecutor, this.operationContext)).block();
    }

    @Test
    public void notEnrichThrownException() throws Throwable {
        this.expectedException.expectCause(CoreMatchers.sameInstance((Object)this.exception));
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, () -> new NullExceptionEnricher());
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)ArgumentMatchers.any())).thenReturn((Object)Mono.error((Throwable)this.exception));
        Mono.from((Publisher)new DefaultExecutionMediator(this.extensionModel, (ComponentModel)this.operationModel, (ConnectionManagerAdapter)new DefaultConnectionManager(muleContext), muleContext.getErrorTypeRepository(), new DefaultExecutionMediator.ValueTransformer[0]).execute(this.operationExceptionExecutor, this.operationContext)).block();
    }

    @Test
    public void enrichThrownExceptionInValueTransformer() throws Throwable {
        RuntimeException exceptionToThrow = new RuntimeException(ERROR, this.exception);
        this.expectedException.expect(ThrowableRootCauseMatcher.hasRootCause((Matcher)CoreMatchers.sameInstance((Object)this.exception)));
        this.expectedException.expectCause(CoreMatchers.instanceOf(HeisenbergException.class));
        this.expectedException.expectMessage(ERROR);
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, () -> this.exceptionEnricher);
        DefaultExecutionMediator.ValueTransformer failingTransformer = (DefaultExecutionMediator.ValueTransformer)Mockito.mock(DefaultExecutionMediator.ValueTransformer.class);
        Mockito.when((Object)failingTransformer.apply(ArgumentMatchers.any(), ArgumentMatchers.any())).thenThrow(new Throwable[]{exceptionToThrow});
        Mono.from((Publisher)new DefaultExecutionMediator(this.extensionModel, (ComponentModel)this.operationModel, (ConnectionManagerAdapter)new DefaultConnectionManager(muleContext), muleContext.getErrorTypeRepository(), new DefaultExecutionMediator.ValueTransformer[]{failingTransformer}).execute(this.operationExecutor, this.operationContext)).block();
    }

    @Test
    public void enrichThrownModuleExceptionInValueTransformer() throws Throwable {
        ModuleException moduleExceptionToThrow = new ModuleException(ERROR, (ErrorTypeDefinition)HeisenbergErrors.HEALTH, (Throwable)this.exception);
        this.expectedException.expectCause(CoreMatchers.instanceOf(HeisenbergException.class));
        this.expectedException.expectMessage(ERROR);
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, () -> this.exceptionEnricher);
        DefaultExecutionMediator.ValueTransformer failingTransformer = (DefaultExecutionMediator.ValueTransformer)Mockito.mock(DefaultExecutionMediator.ValueTransformer.class);
        Mockito.when((Object)failingTransformer.apply(ArgumentMatchers.any(), ArgumentMatchers.any())).thenThrow(new Throwable[]{moduleExceptionToThrow});
        ErrorTypeRepository errorTypeRepository = this.mockErrorModel();
        Mono.from((Publisher)new DefaultExecutionMediator(this.extensionModel, (ComponentModel)this.operationModel, (ConnectionManagerAdapter)new DefaultConnectionManager(muleContext), errorTypeRepository, new DefaultExecutionMediator.ValueTransformer[]{failingTransformer}).execute(this.operationExecutor, this.operationContext)).block();
    }

    @Test
    public void notEnrichThrownExceptionInValueTransformer() throws Throwable {
        RuntimeException exceptionToThrow = new RuntimeException(ERROR, this.exception);
        this.expectedException.expectCause(CoreMatchers.sameInstance((Object)this.exception));
        this.expectedException.expectMessage(ERROR);
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, () -> new NullExceptionEnricher());
        DefaultExecutionMediator.ValueTransformer failingTransformer = (DefaultExecutionMediator.ValueTransformer)Mockito.mock(DefaultExecutionMediator.ValueTransformer.class);
        Mockito.when((Object)failingTransformer.apply(ArgumentMatchers.any(), ArgumentMatchers.any())).thenThrow(new Throwable[]{exceptionToThrow});
        Mono.from((Publisher)new DefaultExecutionMediator(this.extensionModel, (ComponentModel)this.operationModel, (ConnectionManagerAdapter)new DefaultConnectionManager(muleContext), muleContext.getErrorTypeRepository(), new DefaultExecutionMediator.ValueTransformer[]{failingTransformer}).execute(this.operationExecutor, this.operationContext)).block();
    }

    @Test
    public void notReconnectInValueTransformerWhenVariableIsSet() throws Throwable {
        int expectedRetries = this.retryPolicy instanceof SimpleRetryPolicyTemplate ? 1 : 0;
        ModuleException moduleExceptionToThrow = new ModuleException(ERROR, (ErrorTypeDefinition)HeisenbergErrors.CONNECTIVITY, (Throwable)this.connectionException);
        Mockito.when((Object)this.operationContext.getVariable("MULE_DO_NOT_RETRY")).thenReturn((Object)"true");
        Mockito.clearInvocations((Object[])new ExecutionContextAdapter[]{this.operationContext});
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, () -> new NullExceptionEnricher());
        DefaultExecutionMediator.ValueTransformer failingTransformer = (DefaultExecutionMediator.ValueTransformer)Mockito.mock(DefaultExecutionMediator.ValueTransformer.class);
        Mockito.when((Object)failingTransformer.apply(ArgumentMatchers.eq((Object)this.operationContext), ArgumentMatchers.any())).thenThrow(new Throwable[]{moduleExceptionToThrow});
        try {
            Mono.from((Publisher)new DefaultExecutionMediator(this.extensionModel, (ComponentModel)this.operationModel, (ConnectionManagerAdapter)new DefaultConnectionManager(muleContext), muleContext.getErrorTypeRepository(), new DefaultExecutionMediator.ValueTransformer[]{failingTransformer}).execute(this.operationExecutor, this.operationContext)).block();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.sameInstance((Object)this.connectionException));
            Assert.assertThat((Object)e.getCause().getMessage(), (Matcher)CoreMatchers.is((Object)"Connection failure"));
            ((DefaultExecutionMediator.ValueTransformer)Mockito.verify((Object)failingTransformer, (VerificationMode)Mockito.times((int)1))).apply(ArgumentMatchers.any(), ArgumentMatchers.any());
            ((ExecutionContextAdapter)Mockito.verify((Object)this.operationContext, (VerificationMode)Mockito.times((int)expectedRetries))).getVariable("MULE_DO_NOT_RETRY");
        }
    }

    @Test
    public void notEnrichThrownModuleExceptionInValueTransformer() throws Throwable {
        ModuleException moduleExceptionToThrow = new ModuleException(ERROR, (ErrorTypeDefinition)HeisenbergErrors.HEALTH, (Throwable)this.exception);
        this.expectedException.expect(CoreMatchers.instanceOf(TypedException.class));
        this.expectedException.expectCause(CoreMatchers.sameInstance((Object)this.exception));
        ExtensionsTestUtils.mockExceptionEnricher((EnrichableModel)this.operationModel, () -> new NullExceptionEnricher());
        DefaultExecutionMediator.ValueTransformer failingTransformer = (DefaultExecutionMediator.ValueTransformer)Mockito.mock(DefaultExecutionMediator.ValueTransformer.class);
        Mockito.when((Object)failingTransformer.apply(ArgumentMatchers.any(), ArgumentMatchers.any())).thenThrow(new Throwable[]{moduleExceptionToThrow});
        ErrorTypeRepository errorTypeRepository = this.mockErrorModel();
        Mono.from((Publisher)new DefaultExecutionMediator(this.extensionModel, (ComponentModel)this.operationModel, (ConnectionManagerAdapter)new DefaultConnectionManager(muleContext), errorTypeRepository, new DefaultExecutionMediator.ValueTransformer[]{failingTransformer}).execute(this.operationExecutor, this.operationContext)).block();
    }

    private ErrorTypeRepository mockErrorModel() {
        ErrorType parentErrorType = (ErrorType)Mockito.mock(ErrorType.class);
        ErrorTypeRepository errorTypeRepository = (ErrorTypeRepository)Mockito.mock(ErrorTypeRepository.class);
        Mockito.when((Object)errorTypeRepository.lookupErrorType((ComponentIdentifier)ArgumentMatchers.any())).thenReturn(Optional.of(ErrorTypeBuilder.builder().namespace("testNs").identifier("test").parentErrorType(parentErrorType).build()));
        Mockito.when((Object)this.operationModel.getErrorModels()).thenReturn(Collections.singleton(new ImmutableErrorModel("test", "testNs", true, null)));
        return errorTypeRepository;
    }

    @Test
    public void retry() throws Throwable {
        this.stubException();
        Interceptor interceptor = (Interceptor)Mockito.mock(Interceptor.class);
        this.setInterceptors((Interceptable)this.configurationInstance, interceptor);
        this.setInterceptors((Interceptable)this.operationExecutor, new Interceptor[0]);
        this.defineOrder(interceptor);
        int expectedRetries = this.retryPolicy instanceof SimpleRetryPolicyTemplate ? 11 : 1;
        this.assertException(exception -> {
            Assert.assertThat((Object)exception, (Matcher)CoreMatchers.instanceOf(ConnectionException.class));
            try {
                ((Interceptor)Mockito.verify((Object)interceptor, (VerificationMode)Mockito.times((int)expectedRetries))).before((ExecutionContext)this.operationContext);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ((Interceptor)Mockito.verify((Object)interceptor, (VerificationMode)Mockito.times((int)expectedRetries))).onError((ExecutionContext)ArgumentMatchers.same((Object)this.operationContext), (Throwable)ArgumentMatchers.anyVararg());
            ((Interceptor)Mockito.verify((Object)interceptor, (VerificationMode)Mockito.times((int)expectedRetries))).after((ExecutionContext)this.operationContext, null);
        });
    }

    private void assertException(Consumer<Throwable> assertion) throws Throwable {
        try {
            this.execute().block();
            Assert.fail((String)"was expecting a exception");
        }
        catch (Exception e) {
            assertion.accept(Exceptions.unwrap((Throwable)e));
        }
    }

    private void stubExceptionOnBeforeInterceptor() throws Exception {
        ((Interceptor)Mockito.doThrow((Throwable[])new Throwable[]{this.exception}).when((Object)this.operationInterceptor2)).before((ExecutionContext)this.operationContext);
    }

    private void assertStatistics() {
        ((MutableConfigurationStats)Mockito.verify((Object)this.configurationStats)).addInflightOperation();
        ((MutableConfigurationStats)Mockito.verify((Object)this.configurationStats)).discountInflightOperation();
    }

    private void assertBefore() throws Exception {
        this.verifyInOrder(interceptor -> {
            try {
                interceptor.before((ExecutionContext)this.operationContext);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void assertOnSuccess(VerificationMode verificationMode) {
        this.verifyInOrder(interceptor -> interceptor.onSuccess((ExecutionContext)this.operationContext, this.result), verificationMode);
    }

    private void assertOnError(VerificationMode verificationMode) {
        this.verifyInOrder(interceptor -> interceptor.onError((ExecutionContext)ArgumentMatchers.same((Object)this.operationContext), (Throwable)ArgumentMatchers.same((Object)this.connectionException)), verificationMode);
    }

    private void assertAfter(Object expected) {
        this.verifyInOrder(interceptor -> interceptor.after((ExecutionContext)this.operationContext, expected));
    }

    private void assertResult(Object result) {
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.result)));
    }

    private void stubException() throws Exception {
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)this.operationContext)).thenReturn((Object)Mono.error((Throwable)this.connectionException));
    }

    private void setInterceptors(Interceptable interceptable, Interceptor ... interceptors) {
        Mockito.when((Object)interceptable.getInterceptors()).thenReturn(Arrays.asList(interceptors));
    }

    private void defineOrder(Interceptor ... interceptors) {
        this.inOrder = Mockito.inOrder((Object[])interceptors);
        this.orderedInterceptors = ImmutableList.copyOf((Object[])interceptors);
    }

    private void verifyInOrder(Consumer<Interceptor> consumer) {
        this.verifyInOrder(consumer, Mockito.times((int)1));
    }

    private void verifyInOrder(Consumer<Interceptor> consumer, VerificationMode verificationMode) {
        for (Interceptor interceptor : this.orderedInterceptors) {
            consumer.accept((Interceptor)this.inOrder.verify((Object)interceptor, verificationMode));
        }
    }

    private Mono<Object> execute() throws MuleException {
        return Mono.from((Publisher)this.mediator.execute(this.operationExecutor, this.operationContext));
    }
}

