/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.declaration.fluent.HasMinMuleVersionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.WithMinMuleVersionDeclaration;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.parser.MinMuleVersionParser;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.parser.java.test.MinMuleVersionTestUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.MinMuleVersionUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.ResolvedMinMuleVersion;

class MinMuleVersionUtilsTestCase {
    private static final MuleVersion TEST_VERSION_4_6 = new MuleVersion("4.6");
    private static final MuleVersion TEST_VERSION_4_4 = new MuleVersion("4.4");
    private static final MuleVersion TEST_VERSION_4_8 = new MuleVersion("4.8");
    private ExtensionLoadingContext contextResolvingMinMuleVersion;
    private ExtensionLoadingContext contextNotResolvingMinMuleVersion;
    private HasMinMuleVersionDeclarer<?> mockDeclarer;
    private WithMinMuleVersionDeclaration mockDeclaration;
    private MinMuleVersionParser resolvedMMV;

    MinMuleVersionUtilsTestCase() {
    }

    @BeforeEach
    void setUp() {
        this.contextResolvingMinMuleVersion = MinMuleVersionTestUtils.ctxResolvingMinMuleVersion();
        this.contextNotResolvingMinMuleVersion = (ExtensionLoadingContext)Mockito.mock(ExtensionLoadingContext.class);
        Mockito.when((Object)this.contextNotResolvingMinMuleVersion.isResolveMinMuleVersion()).thenReturn((Object)false);
        this.mockDeclarer = (HasMinMuleVersionDeclarer)Mockito.mock(OperationDeclarer.class);
        this.mockDeclaration = (WithMinMuleVersionDeclaration)Mockito.mock(WithMinMuleVersionDeclaration.class);
        this.resolvedMMV = new ResolvedMinMuleVersion("testComponent", TEST_VERSION_4_6, "Test component has min mule version 4.6 for testing purposes.");
    }

    @Test
    void testDeclarerWithMmv() {
        MinMuleVersionUtils.declarerWithMmv(this.mockDeclarer, (MinMuleVersionParser)this.resolvedMMV);
        ((HasMinMuleVersionDeclarer)Mockito.verify(this.mockDeclarer)).withMinMuleVersion(TEST_VERSION_4_6);
    }

    @Test
    void testDeclarationWithMmv() {
        MinMuleVersionUtils.declarationWithMmv((WithMinMuleVersionDeclaration)this.mockDeclaration, (MinMuleVersionParser)this.resolvedMMV);
        ((WithMinMuleVersionDeclaration)Mockito.verify((Object)this.mockDeclaration)).withMinMuleVersion(TEST_VERSION_4_6);
    }

    @Test
    void testDeclareWithBaselineMmvDeclarerWhenContextNotResolving() {
        MinMuleVersionUtils.declareWithBaselineMmv(() -> Optional.of(this.resolvedMMV), this.mockDeclarer, Optional.empty(), (ExtensionLoadingContext)this.contextNotResolvingMinMuleVersion);
        ((HasMinMuleVersionDeclarer)Mockito.verify(this.mockDeclarer, (VerificationMode)Mockito.never())).withMinMuleVersion(TEST_VERSION_4_6);
    }

    @Test
    void testDeclareWithBaselineMmvDeclarerWhenContextResolving() {
        MinMuleVersionUtils.declareWithBaselineMmv(() -> Optional.of(this.resolvedMMV), this.mockDeclarer, Optional.empty(), (ExtensionLoadingContext)this.contextResolvingMinMuleVersion);
        ((HasMinMuleVersionDeclarer)Mockito.verify(this.mockDeclarer)).withMinMuleVersion(TEST_VERSION_4_6);
    }

    @Test
    void testDeclareWithBaselineMmvDeclarerWhenNoResolvedMMV() {
        MinMuleVersionUtils.declareWithBaselineMmv(() -> Optional.empty(), this.mockDeclarer, Optional.empty(), (ExtensionLoadingContext)this.contextResolvingMinMuleVersion);
        ((HasMinMuleVersionDeclarer)Mockito.verify(this.mockDeclarer, (VerificationMode)Mockito.never())).withMinMuleVersion(TEST_VERSION_4_6);
    }

    @Test
    void testDeclareWithBaselineMmvDeclarerWhenBaselineLower() {
        MinMuleVersionUtils.declareWithBaselineMmv(() -> Optional.of(this.resolvedMMV), this.mockDeclarer, Optional.of(TEST_VERSION_4_4), (ExtensionLoadingContext)this.contextResolvingMinMuleVersion);
        ((HasMinMuleVersionDeclarer)Mockito.verify(this.mockDeclarer)).withMinMuleVersion(TEST_VERSION_4_6);
    }

    @Test
    void testDeclareWithBaselineMmvDeclarerWhenBaselineHigher() {
        MinMuleVersionUtils.declareWithBaselineMmv(() -> Optional.of(this.resolvedMMV), this.mockDeclarer, Optional.of(TEST_VERSION_4_8), (ExtensionLoadingContext)this.contextResolvingMinMuleVersion);
        ((HasMinMuleVersionDeclarer)Mockito.verify(this.mockDeclarer, (VerificationMode)Mockito.never())).withMinMuleVersion(TEST_VERSION_4_6);
    }

    @Test
    void testDeclareWithBaselineMmvDeclarerWhenBaselineEqual() {
        MinMuleVersionUtils.declareWithBaselineMmv(() -> Optional.of(this.resolvedMMV), this.mockDeclarer, Optional.of(TEST_VERSION_4_6), (ExtensionLoadingContext)this.contextResolvingMinMuleVersion);
        ((HasMinMuleVersionDeclarer)Mockito.verify(this.mockDeclarer)).withMinMuleVersion(TEST_VERSION_4_6);
    }

    @Test
    void testDeclareWithBaselineMmvDeclarationWhenContextNotResolving() {
        MinMuleVersionUtils.declareWithBaselineMmv(() -> Optional.of(this.resolvedMMV), (WithMinMuleVersionDeclaration)this.mockDeclaration, Optional.empty(), (ExtensionLoadingContext)this.contextNotResolvingMinMuleVersion);
        ((WithMinMuleVersionDeclaration)Mockito.verify((Object)this.mockDeclaration, (VerificationMode)Mockito.never())).withMinMuleVersion(TEST_VERSION_4_6);
    }

    @Test
    void testDeclareWithBaselineMmvDeclarationWhenContextResolving() {
        MinMuleVersionUtils.declareWithBaselineMmv(() -> Optional.of(this.resolvedMMV), (WithMinMuleVersionDeclaration)this.mockDeclaration, Optional.empty(), (ExtensionLoadingContext)this.contextResolvingMinMuleVersion);
        ((WithMinMuleVersionDeclaration)Mockito.verify((Object)this.mockDeclaration)).withMinMuleVersion(TEST_VERSION_4_6);
    }

    @Test
    void testDeclareWithBaselineMmvDeclarationWhenNoResolvedMMV() {
        MinMuleVersionUtils.declareWithBaselineMmv(() -> Optional.empty(), (WithMinMuleVersionDeclaration)this.mockDeclaration, Optional.empty(), (ExtensionLoadingContext)this.contextResolvingMinMuleVersion);
        ((WithMinMuleVersionDeclaration)Mockito.verify((Object)this.mockDeclaration, (VerificationMode)Mockito.never())).withMinMuleVersion(TEST_VERSION_4_6);
    }

    @Test
    void testDeclareWithBaselineMmvDeclarationWhenBaselineLower() {
        MinMuleVersionUtils.declareWithBaselineMmv(() -> Optional.of(this.resolvedMMV), (WithMinMuleVersionDeclaration)this.mockDeclaration, Optional.of(TEST_VERSION_4_4), (ExtensionLoadingContext)this.contextResolvingMinMuleVersion);
        ((WithMinMuleVersionDeclaration)Mockito.verify((Object)this.mockDeclaration)).withMinMuleVersion(TEST_VERSION_4_6);
    }

    @Test
    void testDeclareWithBaselineMmvDeclarationWhenBaselineHigher() {
        MinMuleVersionUtils.declareWithBaselineMmv(() -> Optional.of(this.resolvedMMV), (WithMinMuleVersionDeclaration)this.mockDeclaration, Optional.of(TEST_VERSION_4_8), (ExtensionLoadingContext)this.contextResolvingMinMuleVersion);
        ((WithMinMuleVersionDeclaration)Mockito.verify((Object)this.mockDeclaration, (VerificationMode)Mockito.never())).withMinMuleVersion(TEST_VERSION_4_6);
    }

    @Test
    void testDeclareWithBaselineMmvDeclarationWhenBaselineEqual() {
        MinMuleVersionUtils.declareWithBaselineMmv(() -> Optional.of(this.resolvedMMV), (WithMinMuleVersionDeclaration)this.mockDeclaration, Optional.of(TEST_VERSION_4_6), (ExtensionLoadingContext)this.contextResolvingMinMuleVersion);
        ((WithMinMuleVersionDeclaration)Mockito.verify((Object)this.mockDeclaration)).withMinMuleVersion(TEST_VERSION_4_6);
    }

    @Test
    void testDeclareWithBaselineMmvDeclarationWithDefaultVersion() {
        ResolvedMinMuleVersion defaultMMV = new ResolvedMinMuleVersion("testComponent", ResolvedMinMuleVersion.FIRST_MULE_VERSION, "Test component has default min mule version.");
        MinMuleVersionUtils.declareWithBaselineMmv(() -> Optional.of(defaultMMV), (WithMinMuleVersionDeclaration)this.mockDeclaration, Optional.empty(), (ExtensionLoadingContext)this.contextResolvingMinMuleVersion);
        ((WithMinMuleVersionDeclaration)Mockito.verify((Object)this.mockDeclaration)).withMinMuleVersion(ResolvedMinMuleVersion.FIRST_MULE_VERSION);
    }

    @Test
    void resolveRouterMinMuleVersionWithStaticRoutes() {
        MethodElement<?> router = this.createMockRouter("testRouter");
        ExtensionParameter route1 = this.createMockRoute(String.class);
        ExtensionParameter route2 = this.createMockRoute(Integer.class);
        ResolvedMinMuleVersion inputMMV = this.createRouterMMV("testRouter", TEST_VERSION_4_4);
        ResolvedMinMuleVersion result = MinMuleVersionUtils.resolveRouterMinMuleVersion(router, (ResolvedMinMuleVersion)inputMMV, Arrays.asList(route1, route2));
        MatcherAssert.assertThat((Object)result.getMinMuleVersion(), (Matcher)CoreMatchers.is((Object)TEST_VERSION_4_4));
    }

    @Test
    void resolveRouterMinMuleVersionWithDynamicRoutes() {
        MethodElement<?> router = this.createMockRouter("testRouter");
        ExtensionParameter route1 = this.createMockRoute(List.class);
        ResolvedMinMuleVersion inputMMV = this.createRouterMMV("testRouter", TEST_VERSION_4_4);
        ResolvedMinMuleVersion result = MinMuleVersionUtils.resolveRouterMinMuleVersion(router, (ResolvedMinMuleVersion)inputMMV, Arrays.asList(route1));
        MatcherAssert.assertThat((Object)result.getMinMuleVersion(), (Matcher)CoreMatchers.is((Object)new MuleVersion("4.10.0")));
    }

    @Test
    void resolveRouterMinMuleVersionWithEmptyRoutes() {
        MethodElement<?> router = this.createMockRouter("testRouter");
        ResolvedMinMuleVersion inputMMV = this.createRouterMMV("testRouter", TEST_VERSION_4_4);
        ResolvedMinMuleVersion result = MinMuleVersionUtils.resolveRouterMinMuleVersion(router, (ResolvedMinMuleVersion)inputMMV, Collections.emptyList());
        MatcherAssert.assertThat((Object)result.getMinMuleVersion(), (Matcher)CoreMatchers.is((Object)TEST_VERSION_4_4));
    }

    @Test
    void resolveRouterMinMuleVersionWithMixedRoutes() {
        MethodElement<?> router = this.createMockRouter("testRouter");
        ExtensionParameter route1 = this.createMockRoute(String.class);
        ExtensionParameter route2 = this.createMockRoute(List.class);
        ResolvedMinMuleVersion inputMMV = this.createRouterMMV("testRouter", TEST_VERSION_4_4);
        ResolvedMinMuleVersion result = MinMuleVersionUtils.resolveRouterMinMuleVersion(router, (ResolvedMinMuleVersion)inputMMV, Arrays.asList(route1, route2));
        MatcherAssert.assertThat((Object)result.getMinMuleVersion(), (Matcher)CoreMatchers.is((Object)new MuleVersion("4.10.0")));
    }

    @Test
    void resolveRouterMinMuleVersionWithHigherInputMMV() {
        MethodElement<?> router = this.createMockRouter("testRouter");
        ExtensionParameter route1 = this.createMockRoute(List.class);
        ResolvedMinMuleVersion inputMMV = this.createRouterMMV("testRouter", new MuleVersion("4.12.0"));
        ResolvedMinMuleVersion result = MinMuleVersionUtils.resolveRouterMinMuleVersion(router, (ResolvedMinMuleVersion)inputMMV, Arrays.asList(route1));
        MatcherAssert.assertThat((Object)result.getMinMuleVersion(), (Matcher)CoreMatchers.is((Object)new MuleVersion("4.12.0")));
    }

    private MethodElement<?> createMockRouter(String name) {
        MethodElement router = (MethodElement)Mockito.mock(MethodElement.class);
        Mockito.when((Object)router.getName()).thenReturn((Object)name);
        return router;
    }

    private ExtensionParameter createMockRoute(Class<?> declaringClass) {
        ExtensionParameter route = (ExtensionParameter)Mockito.mock(ExtensionParameter.class);
        Type routeType = (Type)Mockito.mock(Type.class);
        Mockito.when((Object)route.getType()).thenReturn((Object)routeType);
        Mockito.when((Object)routeType.getDeclaringClass()).thenReturn(Optional.of(declaringClass));
        return route;
    }

    private ResolvedMinMuleVersion createRouterMMV(String name, MuleVersion version) {
        return new ResolvedMinMuleVersion(name, version, "Test router has min mule version " + String.valueOf(version) + ".");
    }
}

