/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ObjectBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

import org.junit.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@SmallTest
@ExtendWith(MockitoExtension.class)
class RouteBuilderValueResolverTestCase extends AbstractMuleTestCase {

  @Mock
  private ObjectBuilder objectBuilder;

  @Mock
  private Injector injector;

  @Mock
  private MessageProcessorChain chain;

  @Test
  void routeInitialiseIsPropagatedToItsChain() throws MuleException {
    RouteBuilderValueResolver routeBuilder = new RouteBuilderValueResolver(objectBuilder, injector, chain);
    routeBuilder.initialise();
    verify(chain, times(1)).initialise();
  }

  @Test
  void routeStartIsPropagatedToItsChain() throws MuleException {
    RouteBuilderValueResolver routeBuilder = new RouteBuilderValueResolver(objectBuilder, injector, chain);
    routeBuilder.start();
    verify(chain, times(1)).start();
  }

  @Test
  void routeStopIsPropagatedToItsChain() throws MuleException {
    RouteBuilderValueResolver routeBuilder = new RouteBuilderValueResolver(objectBuilder, injector, chain);
    routeBuilder.stop();
    verify(chain, times(1)).stop();
  }

  @Test
  void routeDisposeIsPropagatedToItsChain() {
    RouteBuilderValueResolver routeBuilder = new RouteBuilderValueResolver(objectBuilder, injector, chain);
    routeBuilder.dispose();
    verify(chain, times(1)).dispose();
  }
}
