/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import static java.util.Optional.ofNullable;

import org.mule.runtime.extension.api.loader.parser.ActingParameterModelParser;

import java.util.Optional;

/**
 * {@link ActingParameterModelParser} for Java based syntax
 *
 * @since 4.10.0
 */
public class JavaActingParameterModelParser implements ActingParameterModelParser {

  private final String parameterName;
  private final boolean isRequired;
  private final String extractionExpression;

  public JavaActingParameterModelParser(String parameterName, boolean isRequired, String extractionExpression) {
    this.parameterName = parameterName;
    this.isRequired = isRequired;
    this.extractionExpression = extractionExpression;
  }

  @Override
  public String getParameterName() {
    return parameterName;
  }

  @Override
  public boolean isRequired() {
    return isRequired;
  }

  @Override
  public Optional<String> getExtractionExpression() {
    return ofNullable(extractionExpression);
  }
}
