/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.extension.privileged.component;

import static java.lang.Integer.toHexString;

import org.mule.runtime.api.component.Component;
import org.mule.runtime.module.extension.internal.component.AnnotatedObjectInvocationHandlerInterceptors;

public class ComponentAdditionalInterceptor {

  /**
   * @param obj the annotated object.
   * @return a new {@link ComponentAdditionalInterceptor} bound to the given {@link Component}.
   * @since 4.10.0
   */
  public static ComponentAdditionalInterceptor create(Component obj) {
    return new ComponentAdditionalInterceptor(obj);
  }

  private Component obj;

  private ComponentAdditionalInterceptor(Component obj) {
    this.obj = obj;
  }

  /**
   * @deprecated use {@link ComponentAdditionalInterceptor#create(Component)}.
   */
  @Deprecated
  public ComponentAdditionalInterceptor() {
    obj = null;
  }

  public Object writeReplace()
      throws Throwable {
    return AnnotatedObjectInvocationHandlerInterceptors.removeDynamicAnnotations(obj);
  }

  @Override
  public String toString() {
    String base = obj.getClass().getName() + "@" + toHexString(obj.hashCode()) + "; location: ";
    if (obj.getLocation() != null) {
      return base + obj.getLocation().getLocation();
    } else {
      return base + "(null)";
    }
  }

  /**
   * @deprecated create a new instance instead.
   */
  @Deprecated
  public void setObj(Component obj) {
    this.obj = obj;
  }
}
