/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source.legacy;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Consumer;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.LegacyResultAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.legacy.SdkSourceCallBackContextAdapter;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.source.PollContext;
import org.mule.sdk.api.runtime.source.SourceCallbackContext;

public class SdkPollContextAdapter<T, A>
implements PollContext<T, A> {
    private final org.mule.runtime.extension.api.runtime.source.PollContext<T, A> delegate;

    public SdkPollContextAdapter(org.mule.runtime.extension.api.runtime.source.PollContext<T, A> delegate) {
        this.delegate = delegate;
    }

    public PollContext.PollItemStatus accept(Consumer<PollContext.PollItem<T, A>> consumer) {
        return SdkPollContextAdapter.from(this.delegate.accept(new PollItemConsumerAdapter<T, A>(consumer)));
    }

    public Optional<Serializable> getWatermark() {
        return this.delegate.getWatermark();
    }

    public boolean isSourceStopping() {
        return this.delegate.isSourceStopping();
    }

    public void setWatermarkComparator(Comparator<? extends Serializable> comparator) {
        this.delegate.setWatermarkComparator(comparator);
    }

    public void onConnectionException(ConnectionException e) {
        this.delegate.onConnectionException(e);
    }

    public static PollContext.PollItemStatus from(PollContext.PollItemStatus pollItemStatus) {
        return switch (pollItemStatus) {
            default -> throw new IncompatibleClassChangeError();
            case PollContext.PollItemStatus.SOURCE_STOPPING -> PollContext.PollItemStatus.SOURCE_STOPPING;
            case PollContext.PollItemStatus.ALREADY_IN_PROCESS -> PollContext.PollItemStatus.ALREADY_IN_PROCESS;
            case PollContext.PollItemStatus.FILTERED_BY_WATERMARK -> PollContext.PollItemStatus.FILTERED_BY_WATERMARK;
            case PollContext.PollItemStatus.ACCEPTED -> PollContext.PollItemStatus.ACCEPTED;
        };
    }

    private static class PollItemConsumerAdapter<T, A>
    implements Consumer<PollContext.PollItem<T, A>> {
        Consumer<PollContext.PollItem<T, A>> delegate;

        PollItemConsumerAdapter(Consumer<PollContext.PollItem<T, A>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void accept(PollContext.PollItem<T, A> pollItem) {
            this.delegate.accept(new LegacyToSdkPollItemAdapter<T, A>(pollItem));
        }

        private static class LegacyToSdkPollItemAdapter<T, A>
        implements PollContext.PollItem<T, A> {
            PollContext.PollItem<T, A> delegate;

            public LegacyToSdkPollItemAdapter(PollContext.PollItem<T, A> delegate) {
                this.delegate = delegate;
            }

            public SourceCallbackContext getSourceCallbackContext() {
                return new SdkSourceCallBackContextAdapter(this.delegate.getSourceCallbackContext());
            }

            public PollContext.PollItem<T, A> setResult(Result result) {
                this.delegate.setResult(LegacyResultAdapter.from(result));
                return this;
            }

            public PollContext.PollItem<T, A> setWatermark(Serializable watermark) {
                this.delegate.setWatermark(watermark);
                return this;
            }

            public PollContext.PollItem<T, A> setId(String id) {
                this.delegate.setId(id);
                return this;
            }
        }
    }
}

