/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.runtime.module.extension.internal.loader.java.property;

import static java.util.Objects.requireNonNull;

import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.extension.api.loader.parser.ValueProviderFactory;
import org.mule.runtime.extension.api.values.ValueProvider;

import java.util.List;
import java.util.Set;

/**
 * Private {@link ModelProperty} which communicates the {@link ValueProvider} of a parameter or parameter model which contains a
 * {@link ValueProviderModel} indicating that provides a {@link Set} of {@link Value values}
 *
 * @since 4.0
 */
public final class ValueProviderFactoryModelProperty implements ModelProperty {

  private final ValueProviderFactory valueProviderFactory;
  private final List<ActingParameterModel> actingParameterModels;

  /**
   * @param valueProviderFactory  a {@link ValueProviderFactory} which allows to create and parameterize instances of
   *                              {@link org.mule.sdk.api.values.ValueProvider}.
   * @param actingParameterModels the {@link List} of {@link ActingParameterModel} representing the parameters that need to be
   *                              injected.
   */
  public ValueProviderFactoryModelProperty(ValueProviderFactory valueProviderFactory,
                                           List<ActingParameterModel> actingParameterModels) {
    requireNonNull(valueProviderFactory, "Values Provider Factory parameter can't be null");
    this.valueProviderFactory = valueProviderFactory;
    this.actingParameterModels = actingParameterModels;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return "ValueProviderFactory";
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isPublic() {
    return false;
  }

  public ValueProviderFactory getFactory() {
    return valueProviderFactory;
  }

  public List<ActingParameterModel> getActingParameterModels() {
    return actingParameterModels;
  }
}
