/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.lifecycle;

import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.notification.IntegerAction;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.core.api.context.notification.MuleContextNotification;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.extension.internal.lifecycle.DefaultArtifactDisposalContext;
import org.mule.runtime.module.extension.internal.loader.java.property.ArtifactLifecycleListenerModelProperty;
import org.mule.sdk.api.artifact.lifecycle.ArtifactDisposalContext;
import org.mule.sdk.api.artifact.lifecycle.ArtifactLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionOnMuleContextDisposedNotificationListener
implements MuleContextNotificationListener<MuleContextNotification> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionOnMuleContextDisposedNotificationListener.class);
    private static final Predicate<MuleContextNotification> ON_CONTEXT_DISPOSED_SELECTOR = notification -> new IntegerAction(108).equals((Object)notification.getAction());
    private final String artifactId;
    private final String extensionId;
    private final ArtifactLifecycleListener artifactLifecycleListener;
    private final ArtifactDisposalContext artifactDisposalContext;

    public static void registerLifecycleListenerForOnContextDisposed(ServerNotificationManager serverNotificationManager, ClassLoader executionClassLoader, ExtensionModel extensionModel) {
        Optional<ArtifactLifecycleListener> artifactLifecycleListener = ExtensionOnMuleContextDisposedNotificationListener.getArtifactLifecycleListener(extensionModel);
        Optional<ClassLoader> extensionClassLoader = ExtensionOnMuleContextDisposedNotificationListener.getExtensionClassLoader(extensionModel).filter(ArtifactClassLoader.class::isInstance);
        if (artifactLifecycleListener.isPresent() && extensionClassLoader.isPresent() && executionClassLoader instanceof ArtifactClassLoader) {
            DefaultArtifactDisposalContext context = new DefaultArtifactDisposalContext((ArtifactClassLoader)executionClassLoader, (ArtifactClassLoader)extensionClassLoader.get());
            String artifactId = ((ArtifactClassLoader)executionClassLoader).getArtifactId();
            String extensionId = ((ArtifactClassLoader)extensionClassLoader.get()).getArtifactId();
            serverNotificationManager.addListenerSubscription((NotificationListener)new ExtensionOnMuleContextDisposedNotificationListener(artifactId, extensionId, artifactLifecycleListener.get(), context), ON_CONTEXT_DISPOSED_SELECTOR);
        }
    }

    private static Optional<ArtifactLifecycleListener> getArtifactLifecycleListener(ExtensionModel extensionModel) {
        return extensionModel.getModelProperty(ArtifactLifecycleListenerModelProperty.class).map(mp -> mp.getArtifactLifecycleListenerFactory().createArtifactLifecycleListener());
    }

    private static Optional<ClassLoader> getExtensionClassLoader(ExtensionModel extensionModel) {
        return extensionModel.getModelProperty(ClassLoaderModelProperty.class).map(ClassLoaderModelProperty::getClassLoader);
    }

    private ExtensionOnMuleContextDisposedNotificationListener(String artifactId, String extensionId, ArtifactLifecycleListener artifactLifecycleListener, ArtifactDisposalContext artifactDisposalContext) {
        this.artifactId = artifactId;
        this.extensionId = extensionId;
        this.artifactLifecycleListener = artifactLifecycleListener;
        this.artifactDisposalContext = artifactDisposalContext;
    }

    public void onNotification(MuleContextNotification notification) {
        try {
            this.artifactLifecycleListener.onArtifactDisposal(this.artifactDisposalContext);
        }
        catch (Throwable t) {
            String message = String.format("Error executing (%s)'s #onArtifactDisposal from extension '%s' on artifact '%s'. This can cause a resource leak", this.artifactLifecycleListener, this.extensionId, this.artifactId);
            LOGGER.error(message, t);
        }
    }
}

