/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.store;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.module.extension.internal.store.SdkObjectStoreAdapter;
import org.mule.runtime.module.extension.internal.store.SdkObjectStoreUtils;
import org.mule.sdk.api.store.ObjectStore;
import org.mule.sdk.api.store.ObjectStoreSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkObjectStoreManagerAdapter
implements org.mule.sdk.api.store.ObjectStoreManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SdkObjectStoreManagerAdapter.class);
    private ObjectStoreManager delegate;
    private Set<String> localStoreNames = Collections.synchronizedSet(new HashSet());
    private ObjectStoreManager localDelegate;

    @Inject
    public void setDelegate(ObjectStoreManager delegate) {
        this.delegate = delegate;
    }

    @Inject
    @Named(value="_muleLocalObjectStoreManager")
    public void setLocalDelegate(ObjectStoreManager localDelegate) {
        this.localDelegate = localDelegate;
    }

    public <T extends ObjectStore<? extends Serializable>> T getObjectStore(String name) {
        org.mule.runtime.api.store.ObjectStore objectStore = this.localStoreNames.contains(name) ? this.localDelegate.getObjectStore(name) : this.delegate.getObjectStore(name);
        return (T)SdkObjectStoreAdapter.from(objectStore);
    }

    public <T extends ObjectStore<? extends Serializable>> T createObjectStore(String name, ObjectStoreSettings objectStoreSettings) {
        return this.doCreateObjectStore(name, objectStoreSettings, (d, convertedSettings) -> d.createObjectStore(name, convertedSettings));
    }

    public <T extends ObjectStore<? extends Serializable>> T getOrCreateObjectStore(String name, ObjectStoreSettings objectStoreSettings) {
        return this.doCreateObjectStore(name, objectStoreSettings, (d, convertedSettings) -> d.getOrCreateObjectStore(name, convertedSettings));
    }

    private <T extends ObjectStore<? extends Serializable>> T doCreateObjectStore(String name, ObjectStoreSettings objectStoreSettings, BiFunction<ObjectStoreManager, org.mule.runtime.api.store.ObjectStoreSettings, org.mule.runtime.api.store.ObjectStore> objectStoreFactory) {
        org.mule.runtime.api.store.ObjectStore objectStore;
        org.mule.runtime.api.store.ObjectStoreSettings convertedSettings = SdkObjectStoreUtils.convertToMuleObjectStoreSettings(objectStoreSettings);
        if (objectStoreSettings.isDistributed()) {
            objectStore = objectStoreFactory.apply(this.delegate, convertedSettings);
        } else {
            objectStore = objectStoreFactory.apply(this.localDelegate, convertedSettings);
            this.localStoreNames.add(name);
        }
        if (objectStoreSettings.isDistributed() != objectStore.isDistributed()) {
            LOGGER.warn("Requested a {} object store, but '{}' is {}", new Object[]{objectStoreSettings.isDistributed() ? "distributed" : "local", objectStore, objectStore.isDistributed() ? "distributed" : "local"});
        }
        if (objectStoreSettings.isPersistent() != objectStore.isPersistent()) {
            LOGGER.warn("Requested a {} object store, but '{}' is {}", new Object[]{objectStoreSettings.isPersistent() ? "persistent" : "transient", objectStore, objectStore.isPersistent() ? "persistent" : "transient"});
        }
        return (T)SdkObjectStoreAdapter.from(objectStore);
    }

    public void disposeStore(String name) throws ObjectStoreException {
        if (this.localStoreNames.remove(name)) {
            this.localDelegate.disposeStore(name);
        } else {
            this.delegate.disposeStore(name);
        }
    }
}

