/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.api.tooling;

import jakarta.inject.Inject;
import org.mule.api.annotation.NoExtend;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connectivity.ConnectivityTestingStrategy;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.event.NullEventFactory;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderResolver;

@NoExtend
@NoInstantiate
public class ExtensionConnectivityTestingStrategy
implements ConnectivityTestingStrategy {
    @Inject
    private ConnectionManager connectionManager;
    @Inject
    private ExpressionManager expressionManager;

    public ExtensionConnectivityTestingStrategy() {
    }

    ExtensionConnectivityTestingStrategy(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConnectionValidationResult testConnectivity(Object connectivityTestingObject) {
        CoreEvent initialiserEvent;
        block15: {
            initialiserEvent = null;
            try {
                initialiserEvent = NullEventFactory.getNullEvent();
                if (connectivityTestingObject instanceof ConnectionProviderResolver) {
                    ConnectionProviderResolver resolver = (ConnectionProviderResolver)connectivityTestingObject;
                    try (ValueResolvingContext ctx = ValueResolvingContext.builder(initialiserEvent, this.expressionManager).build();){
                        ConnectionProvider connectionProvider = (ConnectionProvider)resolver.resolve(ctx).getFirst();
                        ConnectionValidationResult connectionValidationResult = this.connectionManager.testConnectivity(connectionProvider);
                        return connectionValidationResult;
                    }
                }
                if (connectivityTestingObject instanceof ConfigurationProvider) break block15;
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("testConnectivity was invoked with an object type %s not supported.", connectivityTestingObject.getClass().getName())));
            }
            catch (Exception e) {
                ConnectionValidationResult connectionValidationResult = ConnectionValidationResult.failure((String)"Failed to obtain connectivity testing object", (Exception)e);
                return connectionValidationResult;
            }
        }
        ConfigurationProvider configurationProvider = (ConfigurationProvider)connectivityTestingObject;
        ConfigurationInstance configurationInstance = configurationProvider.get((Event)initialiserEvent);
        return this.connectionManager.testConnectivity(configurationInstance);
        finally {
            if (initialiserEvent != null) {
                ((BaseEventContext)initialiserEvent.getContext()).success();
            }
        }
    }

    public boolean accepts(Object connectivityTestingObject) {
        return connectivityTestingObject instanceof ConnectionProviderResolver || connectivityTestingObject instanceof ConfigurationProvider;
    }
}

