/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.value;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.core.internal.util.ClassUtils;
import org.mule.runtime.extension.api.values.ValueBuilder;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.sdk.api.values.ValueProvider;

public class ValueProviderUtils {
    private ValueProviderUtils() {
    }

    static ValueBuilder cloneAndEnrichValue(Value value, Map<Integer, String> partOrderMapping) {
        return ValueProviderUtils.cloneAndEnrichMuleValue(value, partOrderMapping, 1);
    }

    public static ValueBuilder cloneAndEnrichValue(Value value, List<ParameterModel> parameters) {
        return ValueProviderUtils.cloneAndEnrichMuleValue(value, ValueProviderUtils.orderParts(parameters, null), 1);
    }

    public static ValueBuilder cloneAndEnrichValue(Value value, List<ParameterModel> parameters, String providerId, String targetSelector) {
        return ValueProviderUtils.cloneAndEnrichMuleValue(value, ValueProviderUtils.orderParts(parameters, providerId, targetSelector), 1);
    }

    static org.mule.sdk.api.values.ValueBuilder cloneAndEnrichValue(org.mule.sdk.api.values.Value value, Map<Integer, String> partOrderMapping) {
        return ValueProviderUtils.cloneAndEnrichValue(value, partOrderMapping, 1);
    }

    public static org.mule.sdk.api.values.ValueBuilder cloneAndEnrichValue(org.mule.sdk.api.values.Value value, List<ParameterModel> parameters) {
        return ValueProviderUtils.cloneAndEnrichValue(value, ValueProviderUtils.orderParts(parameters, null), 1);
    }

    public static org.mule.sdk.api.values.ValueBuilder cloneAndEnrichValue(org.mule.sdk.api.values.Value value, List<ParameterModel> parameters, String providerId) {
        return ValueProviderUtils.cloneAndEnrichValue(value, ValueProviderUtils.orderParts(parameters, providerId), 1);
    }

    public static org.mule.sdk.api.values.ValueBuilder cloneAndEnrichValue(org.mule.sdk.api.values.Value value, List<ParameterModel> parameters, String providerId, String targetSelector) {
        return ValueProviderUtils.cloneAndEnrichValue(value, ValueProviderUtils.orderParts(parameters, providerId, targetSelector), 1);
    }

    static org.mule.sdk.api.values.ValueBuilder cloneAndEnrichValue(org.mule.sdk.api.values.Value value, Map<Integer, String> partOrderMapping, int level) {
        org.mule.sdk.api.values.ValueBuilder keyBuilder = org.mule.sdk.api.values.ValueBuilder.newValue((String)value.getId(), (String)partOrderMapping.get(level)).withDisplayName(value.getDisplayName());
        value.getChilds().forEach(childKey -> keyBuilder.withChild(ValueProviderUtils.cloneAndEnrichValue(childKey, partOrderMapping, level + 1)));
        return keyBuilder;
    }

    static ValueBuilder cloneAndEnrichMuleValue(Value value, Map<Integer, String> partOrderMapping, int level) {
        ValueBuilder keyBuilder = ValueBuilder.newValue((String)value.getId(), (String)partOrderMapping.get(level)).withDisplayName(value.getDisplayName());
        value.getChilds().forEach(childKey -> keyBuilder.withChild(ValueProviderUtils.cloneAndEnrichMuleValue(childKey, partOrderMapping, level + 1)));
        return keyBuilder;
    }

    private static Map<Integer, String> orderParts(List<ParameterModel> parameters, String providerId) {
        return ValueProviderUtils.orderParts(parameters, providerId, null);
    }

    private static Map<Integer, String> orderParts(List<ParameterModel> parameters, String providerId, String targetSelector) {
        if (parameters.size() == 1 && !parameters.get(0).getFieldValueProviderModels().isEmpty()) {
            String providerName = parameters.get(0).getFieldValueProviderModels().stream().filter(fieldValueProviderModel -> fieldValueProviderModel.getTargetSelector().equals(targetSelector)).map(fieldValueProviderModel -> fieldValueProviderModel.getProviderName()).findAny().get();
            return parameters.get(0).getFieldValueProviderModels().stream().filter(fieldValueProviderModel -> fieldValueProviderModel.getProviderName().equals(providerName)).collect(Collectors.toMap(ValueProviderModel::getPartOrder, fieldModel -> ((ParameterModel)parameters.get(0)).getName() + "." + fieldModel.getTargetSelector(), (partName, anotherPartName) -> partName.substring(partName.indexOf(".") + 1).equals(targetSelector) ? partName : anotherPartName));
        }
        return parameters.stream().collect(Collectors.toMap(param -> ((ValueProviderModel)param.getValueProviderModel().get()).getPartOrder(), NamedObject::getName));
    }

    public static List<ValueProviderModel> getValueProviderModels(List<ParameterModel> parameterModels) {
        return parameterModels.stream().map(parameterModel -> parameterModel.getValueProviderModel().orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Set<Value> valuesWithClassLoader(Callable<Set<Value>> valueResolver, ExtensionModel extensionModel) throws ValueResolvingException {
        Reference exceptionReference = new Reference();
        Set values = (Set)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader(extensionModel), valueResolver, ValueResolvingException.class, e -> {
            exceptionReference.set((Object)((ValueResolvingException)e));
            return null;
        });
        if (exceptionReference.get() != null) {
            throw (ValueResolvingException)exceptionReference.get();
        }
        return values;
    }

    public static String getValueProviderId(Class valueProviderClazz) {
        Object valueProviderObject;
        if (!org.mule.runtime.extension.api.values.ValueProvider.class.isAssignableFrom(valueProviderClazz) && !ValueProvider.class.isAssignableFrom(valueProviderClazz)) {
            throw new IllegalStateException(String.format("Value Provider %s does not implement %s or %s", valueProviderClazz.getName(), org.mule.runtime.extension.api.values.ValueProvider.class.getName(), ValueProvider.class.getName()));
        }
        try {
            valueProviderObject = valueProviderClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("There was an error creating an instance of %s to retrieve the Id of the provider", valueProviderClazz.getName()), e);
        }
        return valueProviderObject instanceof org.mule.runtime.extension.api.values.ValueProvider ? ((org.mule.runtime.extension.api.values.ValueProvider)valueProviderObject).getId() : ((ValueProvider)valueProviderObject).getId();
    }

    public static String getParameterNameFromExtractionExpression(String extractionExpression) {
        int parameterNameDelimiter = extractionExpression.indexOf(".");
        return parameterNameDelimiter < 0 ? extractionExpression : extractionExpression.substring(0, parameterNameDelimiter);
    }
}

