/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.List;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.config.ArtifactEncoding;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.internal.exception.EnrichedErrorMapping;
import org.mule.runtime.core.internal.profiling.DummyComponentTracerFactory;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.privileged.util.ComponentDeclarationUtils;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.operation.ComponentMessageProcessorBuilder;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.ResultTransformer;
import org.mule.runtime.module.extension.internal.runtime.streaming.PagingResultTransformer;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.tracer.api.component.ComponentTracer;
import org.mule.runtime.tracer.api.component.ComponentTracerFactory;

public final class OperationMessageProcessorBuilder
extends ComponentMessageProcessorBuilder<OperationModel, OperationMessageProcessor> {
    private final List<EnrichedErrorMapping> errorMappings;
    private final ComponentTracerFactory<CoreEvent> componentTracerFactory;

    public OperationMessageProcessorBuilder(ExtensionModel extension, OperationModel operation, List<EnrichedErrorMapping> errorMappings, ReflectionCache reflectionCache, ExtendedExpressionManager expressionManager, ExtensionConnectionSupplier extensionConnectionSupplier, ComponentTracerFactory<CoreEvent> componentTracerFactory, ArtifactEncoding artifactEncoding, MuleContext muleContext) {
        super(extension, operation, reflectionCache, expressionManager, extensionConnectionSupplier, artifactEncoding, muleContext);
        this.errorMappings = errorMappings;
        this.componentTracerFactory = componentTracerFactory;
    }

    @Override
    protected OperationMessageProcessor createMessageProcessor(ExtensionManager extensionManager, ResolverSet arguments) {
        ValueResolver<ConfigurationProvider> configurationProviderResolver = this.getConfigurationProviderResolver();
        ResultTransformer resultTransformer = null;
        boolean isPagedOperation = ComponentDeclarationUtils.isPagedOperation((ComponentModel)this.operationModel);
        if (isPagedOperation) {
            resultTransformer = MuleExtensionUtils.getPagingResultTransformer((OperationModel)this.operationModel, this.extensionConnectionSupplier, MuleExtensionUtils.supportsOAuth(this.extensionModel), (ComponentTracer<CoreEvent>)DummyComponentTracerFactory.DUMMY_COMPONENT_TRACER_INSTANCE).orElse(null);
        }
        OperationMessageProcessor operationMessageProcessor = new OperationMessageProcessor(this.extensionModel, (OperationModel)this.operationModel, configurationProviderResolver, this.target, this.targetValue, this.errorMappings, arguments, this.cursorProviderFactory, this.retryPolicyTemplate, this.nestedChain, this.classLoader, extensionManager, this.reflectionCache, resultTransformer, this.terminationTimeout);
        if (isPagedOperation && resultTransformer != null) {
            ((PagingResultTransformer)resultTransformer).setOperationConnectionTracer((ComponentTracer<CoreEvent>)this.componentTracerFactory.fromComponent((Component)operationMessageProcessor, "mule:get-connection", ""));
        }
        return operationMessageProcessor;
    }
}

