/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver.resolver;

import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import java.util.function.Function;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.MediaTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.config.resolver.BasicTypeValueResolverFactoryTypeVisitor;
import org.mule.runtime.module.extension.internal.runtime.resolver.RegistryLookupValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class ValueResolverFactoryTypeVisitor
extends BasicTypeValueResolverFactoryTypeVisitor {
    private final Object defaultValue;
    private final boolean acceptsReferences;

    public ValueResolverFactoryTypeVisitor(String parameterName, Object value, Object defaultValue, boolean acceptsReferences, Class<?> expectedClass) {
        super(parameterName, value, expectedClass);
        this.defaultValue = defaultValue;
        this.acceptsReferences = acceptsReferences;
    }

    public void visitDateTime(DateTimeType dateTimeType) {
        this.setResolver(this.parseDate(this.getValue(), (MetadataType)dateTimeType, this.defaultValue));
    }

    public void visitDate(DateType dateType) {
        this.setResolver(this.parseDate(this.getValue(), (MetadataType)dateType, this.defaultValue));
    }

    public void visitObject(ObjectType objectType) {
        if (ExtensionMetadataTypeUtils.isMap((MetadataType)objectType)) {
            this.defaultVisit((MetadataType)objectType);
            return;
        }
        ValueResolver valueResolver = this.getCustomValueResolver((MetadataType)objectType).map(func -> (ValueResolver)func.apply(this.getValue().toString())).orElseGet(() -> this.getDefaultResolver(this.getValue()));
        this.setResolver(valueResolver);
    }

    @Override
    protected void defaultVisit(MetadataType metadataType) {
        ValueResolver delegateResolver = this.getCustomValueResolver(metadataType).map(delegate -> (ValueResolver)delegate.apply(this.getValue().toString())).orElseGet(() -> this.getDefaultResolver(this.getValue()));
        this.setResolver(delegateResolver);
    }

    private ValueResolver getDefaultResolver(Object value) {
        if (this.acceptsReferences && value instanceof String) {
            String stringValue = (String)value;
            return new RegistryLookupValueResolver(stringValue);
        }
        return new TypeSafeValueResolverWrapper(new StaticValueResolver<Object>(value), this.getExpectedClass());
    }

    private ValueResolver parseDate(Object value, MetadataType dateType, Object defaultValue) {
        Class type = JavaTypeUtils.getType((MetadataType)dateType);
        if (MuleExtensionUtils.isExpression(value)) {
            return new TypeSafeExpressionValueResolver((String)value, type, IntrospectionUtils.toDataType(dateType));
        }
        if (value == null) {
            if (defaultValue == null) {
                return new StaticValueResolver<Object>(null);
            }
            value = defaultValue;
        }
        return this.doParseDate(value, type);
    }

    private Optional<Function<String, ValueResolver>> getCustomValueResolver(MetadataType metadataType) {
        Optional clazz = ExtensionMetadataTypeUtils.getType((MetadataType)metadataType);
        if (clazz.map(MediaType.class::equals).orElse(false).booleanValue()) {
            return Optional.of(key -> new StaticValueResolver<MediaType>(DataType.builder().mediaType(key).build().getMediaType()));
        }
        if (clazz.map(Charset.class::equals).orElse(false).booleanValue()) {
            return Optional.of(key -> new StaticValueResolver<Charset>(MediaTypeUtils.parseCharset((String)key)));
        }
        return Optional.empty();
    }

    private ValueResolver doParseDate(Object value, Class<?> type) {
        if (value instanceof String) {
            Comparable<Date> constructedValue = null;
            DateTime dateTime = this.getParsedDateTime((String)value);
            if (type.equals(LocalDate.class)) {
                constructedValue = LocalDate.of(dateTime.getYear(), dateTime.getMonthOfYear(), dateTime.getDayOfMonth());
            } else if (type.equals(Date.class)) {
                constructedValue = dateTime.toDate();
            } else if (type.equals(LocalDateTime.class)) {
                Instant instant = Instant.ofEpochMilli(dateTime.getMillis());
                constructedValue = LocalDateTime.ofInstant(instant, ZoneId.of(dateTime.getZone().getID()));
            } else if (type.equals(Calendar.class)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(dateTime.toDate());
                constructedValue = calendar;
            } else if (type.equals(ZonedDateTime.class)) {
                Instant instant = Instant.ofEpochMilli(dateTime.getMillis());
                constructedValue = ZonedDateTime.ofInstant(instant, ZoneId.of(dateTime.getZone().getID()));
            }
            if (constructedValue == null) {
                throw new IllegalArgumentException(String.format("Could not construct value of type '%s' from String '%s'", type.getName(), value));
            }
            value = constructedValue;
        }
        if (this.hasValidType(value)) {
            return new StaticValueResolver<Object>(value);
        }
        throw new IllegalArgumentException(String.format("Could not transform value of type '%s' to a valid date type", value != null ? value.getClass().getName() : "null"));
    }

    private DateTime getParsedDateTime(String value) {
        try {
            return ISODateTimeFormat.dateTimeParser().withOffsetParsed().parseDateTime(value);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(String.format("Could not parse value '%s' according to ISO 8601", value));
        }
    }

    private boolean hasValidType(Object value) {
        return value instanceof Date || value instanceof LocalDate || value instanceof LocalDateTime || value instanceof Calendar || value instanceof ZonedDateTime;
    }
}

