/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import com.google.common.primitives.Primitives;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.annotation.ConfigOverrideTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ExclusiveOptionalsTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.NullSafeTypeAnnotation;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.property.NullSafeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.stackabletypes.StackedTypesModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionParameterDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ExclusiveParameterGroupObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.CollectionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConfigOverrideValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConfigurationValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.LifecycleInitialiserValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.MapValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.NullSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBuilderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectTypeParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValidatingParametersResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class ParametersResolver
implements ObjectTypeParametersResolver {
    private final MuleContext muleContext;
    private final Map<String, ?> parameters;
    private final ReflectionCache reflectionCache;
    private final ExtendedExpressionManager expressionManager;
    private final String parameterOwner;

    protected ParametersResolver(MuleContext muleContext, Map<String, ?> parameters, ReflectionCache reflectionCache, ExtendedExpressionManager expressionManager, String parameterOwner) {
        this.muleContext = muleContext;
        this.parameters = parameters;
        this.reflectionCache = reflectionCache;
        this.expressionManager = expressionManager;
        this.parameterOwner = parameterOwner;
    }

    public static ParametersResolver fromValues(Map<String, ?> parameters, MuleContext muleContext, ReflectionCache reflectionCache, ExtendedExpressionManager expressionManager, String parameterOwner) {
        return ParametersResolver.fromValues(parameters, muleContext, true, reflectionCache, expressionManager, parameterOwner);
    }

    public static ParametersResolver fromValues(Map<String, ?> parameters, MuleContext muleContext, boolean disableValidations, ReflectionCache reflectionCache, ExtendedExpressionManager expressionManager, String parameterOwner) {
        if (disableValidations) {
            return new ParametersResolver(muleContext, parameters, reflectionCache, expressionManager, parameterOwner);
        }
        return new ValidatingParametersResolver(muleContext, parameters, reflectionCache, expressionManager, parameterOwner);
    }

    public static ParametersResolver fromDefaultValues(ParameterizedModel parameterizedModel, MuleContext muleContext, ReflectionCache reflectionCache, ExtendedExpressionManager expressionManager) {
        List allParameterModels = parameterizedModel.getAllParameterModels();
        Map parameterValues = SmallMap.forSize((int)allParameterModels.size());
        for (ParameterModel model : allParameterModels) {
            parameterValues.put(model.getName(), model.getDefaultValue());
        }
        return new ParametersResolver(muleContext, parameterValues, reflectionCache, expressionManager, parameterizedModel.getName());
    }

    public ResolverSet getParametersAsResolverSet(ParameterizedModel model, MuleContext muleContext) throws ConfigurationException {
        List<ParameterGroupModel> inlineGroups = this.getInlineGroups(model.getParameterGroupModels());
        List<ParameterModel> flatParameters = this.getFlatParameters(inlineGroups, model.getAllParameterModels());
        ResolverSet resolverSet = this.getParametersAsResolverSet(model, flatParameters, muleContext);
        for (ParameterGroupModel group : inlineGroups) {
            this.getInlineGroupResolver(group, resolverSet, muleContext);
        }
        return resolverSet;
    }

    public ResolverSet getNestedComponentsAsResolverSet(ComponentModel model) {
        List nestedComponents = model.getNestedComponents();
        ResolverSet resolverSet = new ResolverSet(this.muleContext);
        nestedComponents.forEach(nc -> resolverSet.add(nc.getName(), this.toValueResolver(this.parameters.get(nc.getName()))));
        return resolverSet;
    }

    public ResolverSet getParametersAsResolverSet(MuleContext context, ParameterizedModel model, List<ParameterGroupModel> groups) throws ConfigurationException {
        List<ParameterGroupModel> inlineGroups = this.getInlineGroups(groups);
        List<ParameterModel> allParameters = groups.stream().flatMap(g -> g.getParameterModels().stream()).collect(Collectors.toList());
        ResolverSet resolverSet = this.getParametersAsResolverSet(model, this.getFlatParameters(inlineGroups, allParameters), context);
        for (ParameterGroupModel group : inlineGroups) {
            this.getInlineGroupResolver(group, resolverSet, context);
        }
        return resolverSet;
    }

    private void getInlineGroupResolver(ParameterGroupModel group, ResolverSet resolverSet, MuleContext muleContext) {
        Optional<ParameterGroupDescriptor> descriptor = group.getModelProperty(ParameterGroupModelProperty.class).map(ParameterGroupModelProperty::getDescriptor);
        String groupKey = descriptor.map(d -> IntrospectionUtils.getContainerName(d.getContainer())).orElseGet(() -> ((ParameterGroupModel)group).getName());
        if (this.parameters.containsKey(groupKey)) {
            resolverSet.add(groupKey, this.toValueResolver(this.parameters.get(groupKey), (EnrichableModel)group));
        } else if (descriptor.isPresent()) {
            resolverSet.add(groupKey, NullSafeValueResolverWrapper.of(new StaticValueResolver<Object>(null), descriptor.get().getMetadataType(), this.reflectionCache, this.expressionManager, muleContext, this));
        } else {
            LinkedList keyResolvers = new LinkedList();
            LinkedList valueResolvers = new LinkedList();
            group.getParameterModels().forEach(param -> {
                ValueResolver<Object> parameterValueResolver = this.getParameterValueResolver((ParameterModel)param);
                if (parameterValueResolver != null) {
                    keyResolvers.add(new StaticValueResolver<String>(param.getName()));
                    valueResolvers.add(parameterValueResolver);
                }
            });
            resolverSet.add(groupKey, MapValueResolver.of(HashMap.class, keyResolvers, valueResolvers, this.reflectionCache, muleContext));
        }
    }

    public ResolverSet getParametersAsResolverSet(ParameterizedModel model, List<ParameterModel> parameters, MuleContext context) throws ConfigurationException {
        ResolverSet resolverSet = new ResolverSet(context);
        return this.getResolverSet(Optional.of(model), model.getParameterGroupModels(), parameters, resolverSet);
    }

    public ResolverSet getParametersAsResolverSet(List<ParameterGroupModel> groups, List<ParameterModel> parameterModels, MuleContext muleContext) throws ConfigurationException {
        ResolverSet resolverSet = new ResolverSet(muleContext);
        return this.getResolverSet(Optional.empty(), groups, parameterModels, resolverSet);
    }

    protected ResolverSet getResolverSet(Optional<ParameterizedModel> model, List<ParameterGroupModel> groups, List<ParameterModel> parameterModels, ResolverSet resolverSet) throws ConfigurationException {
        parameterModels.stream().filter(p -> !p.isComponentId() || p.getModelProperty(ExtensionParameterDescriptorModelProperty.class).isPresent()).forEach(p -> this.addToResolverSet((ParameterModel)p, resolverSet, this.getParameterValueResolver((ParameterModel)p)));
        return resolverSet;
    }

    protected void addToResolverSet(ParameterModel paramModel, ResolverSet resolverSet, ValueResolver<?> resolver) {
        if (resolver != null) {
            resolverSet.add(IntrospectionUtils.getMemberName((EnrichableModel)paramModel, paramModel.getName()), resolver);
        }
    }

    private ValueResolver<Object> getParameterValueResolver(ParameterModel parameter) {
        String parameterName = parameter.getName();
        ValueResolver<Object> resolver = this.parameters.containsKey(parameterName) ? this.toValueResolver(this.parameters.get(parameterName), (EnrichableModel)parameter) : ResolverUtils.getDefaultValueResolver(parameter, this.muleContext, this.expressionManager);
        if (MuleExtensionUtils.isNullSafe(parameter)) {
            StaticValueResolver<Object> delegate = resolver != null ? resolver : new StaticValueResolver<Object>(null);
            Optional<MetadataType> type = parameter.getModelProperty(NullSafeModelProperty.class).map(NullSafeModelProperty::defaultType);
            if (type.isPresent()) {
                resolver = NullSafeValueResolverWrapper.of(delegate, type.get(), this.reflectionCache, this.expressionManager, this.muleContext, this);
            }
        }
        if (parameter.isOverrideFromConfig()) {
            final AtomicReference simpleTypeClass = new AtomicReference();
            parameter.getType().accept(new MetadataTypeVisitor(){

                public void visitString(StringType stringType) {
                    simpleTypeClass.set(ExtensionMetadataTypeUtils.getType((MetadataType)stringType).orElse(String.class));
                }

                public void visitBoolean(BooleanType booleanType) {
                    simpleTypeClass.set(Boolean.class);
                }

                public void visitNumber(NumberType numberType) {
                    simpleTypeClass.set(ExtensionMetadataTypeUtils.getType((MetadataType)numberType).orElse(Number.class));
                }
            });
            resolver = simpleTypeClass.get() != null ? ConfigOverrideValueResolverWrapper.of(resolver != null ? resolver : new StaticValueResolver<Object>(null), parameterName, Primitives.wrap((Class)((Class)simpleTypeClass.get())), this.reflectionCache, this.muleContext, this.parameterOwner) : ConfigOverrideValueResolverWrapper.of(resolver != null ? resolver : new StaticValueResolver<Object>(null), parameterName, parameter.getType(), this.reflectionCache, this.muleContext, this.parameterOwner);
        }
        return resolver;
    }

    private List<ParameterGroupModel> getInlineGroups(List<ParameterGroupModel> groups) {
        return groups.stream().filter(ParameterGroupModel::isShowInDsl).collect(Collectors.toList());
    }

    private List<ParameterModel> getFlatParameters(List<ParameterGroupModel> inlineGroups, List<ParameterModel> parameters) {
        return parameters.stream().filter(p -> inlineGroups.stream().noneMatch(g -> g.getParameterModels().contains(p))).collect(Collectors.toList());
    }

    private DefaultObjectBuilder getParameterGroupObjectBuilder(ObjectFieldType groupField) {
        Class type = JavaTypeUtils.getType((MetadataType)groupField.getValue());
        if (groupField.getAnnotation(ExclusiveOptionalsTypeAnnotation.class).isPresent()) {
            return new ExclusiveParameterGroupObjectBuilder(type, (ExclusiveOptionalsTypeAnnotation)groupField.getAnnotation(ExclusiveOptionalsTypeAnnotation.class).get(), this.reflectionCache);
        }
        return new DefaultObjectBuilder(type, this.reflectionCache);
    }

    @Override
    public void resolveParameterGroups(ObjectType objectType, DefaultObjectBuilder builder) {
        Class objectClass = JavaTypeUtils.getType((MetadataType)objectType);
        objectType.getFields().stream().filter(ExtensionMetadataTypeUtils::isFlattenedParameterGroup).forEach(groupField -> {
            if (!(groupField.getValue() instanceof ObjectType)) {
                return;
            }
            ObjectType groupType = (ObjectType)groupField.getValue();
            Field objectField = this.getField(objectClass, MetadataTypeUtils.getLocalPart((ObjectFieldType)groupField));
            DefaultObjectBuilder groupBuilder = this.getParameterGroupObjectBuilder((ObjectFieldType)groupField);
            builder.addPropertyResolver(objectField, new ObjectBuilderValueResolver(groupBuilder, this.muleContext));
            this.resolveParameters(groupType, groupBuilder);
            this.resolveParameterGroups(groupType, groupBuilder);
        });
    }

    @Override
    public void resolveParameters(ObjectType objectType, DefaultObjectBuilder builder) {
        Class objectClass = JavaTypeUtils.getType((MetadataType)objectType);
        boolean isParameterGroup = ExtensionMetadataTypeUtils.isFlattenedParameterGroup((MetadataType)objectType);
        objectType.getFields().forEach(field -> this.resolveParameterField((ObjectFieldType)field, builder, objectClass, isParameterGroup));
    }

    private void resolveParameterField(ObjectFieldType field, DefaultObjectBuilder builder, Class<?> objectClass, boolean isParameterGroup) {
        String key = MetadataTypeUtils.getLocalPart((ObjectFieldType)field);
        ValueResolver<Object> valueResolver = null;
        Field objectField = this.getField(objectClass, key);
        if (this.parameters.containsKey(key)) {
            valueResolver = this.toValueResolver(this.parameters.get(key));
        } else if (!isParameterGroup) {
            valueResolver = MetadataTypeUtils.getDefaultValue((MetadataType)field).isPresent() ? ResolverUtils.getFieldDefaultValueValueResolver(field, this.muleContext, this.expressionManager) : null;
        }
        Optional nullSafe = field.getAnnotation(NullSafeTypeAnnotation.class);
        if (nullSafe.isPresent()) {
            StaticValueResolver<Object> delegate = valueResolver != null ? valueResolver : new StaticValueResolver<Object>(null);
            MetadataType type = IntrospectionUtils.getMetadataType(((NullSafeTypeAnnotation)nullSafe.get()).getType(), ExtensionsTypeLoaderFactory.getDefault().createTypeLoader());
            valueResolver = NullSafeValueResolverWrapper.of(delegate, type, this.reflectionCache, this.expressionManager, this.muleContext, this);
        }
        if (field.getAnnotation(ConfigOverrideTypeAnnotation.class).isPresent()) {
            valueResolver = ConfigOverrideValueResolverWrapper.of(valueResolver != null ? valueResolver : new StaticValueResolver<Object>(null), key, objectField.getType(), this.reflectionCache, this.muleContext, objectClass.getName());
        }
        this.addPropertyResolver(builder, valueResolver, field, objectField);
    }

    protected void addPropertyResolver(DefaultObjectBuilder builder, ValueResolver<?> valueResolver, ObjectFieldType field, Field objectField) {
        if (valueResolver != null) {
            try {
                LifecycleUtils.initialiseIfNeeded(valueResolver, (boolean)true, (MuleContext)this.muleContext);
                builder.addPropertyResolver(objectField, valueResolver);
            }
            catch (InitialisationException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    private Field getField(Class<?> objectClass, String key) {
        return IntrospectionUtils.getFieldByNameOrAlias(objectClass, key, this.reflectionCache).orElseThrow(() -> new IllegalModelDefinitionException(String.format("Class '%s' does not contain field %s", objectClass.getName(), key)));
    }

    private ValueResolver<?> toValueResolver(Object value) {
        return this.toValueResolver(value, null);
    }

    private ValueResolver<?> toValueResolver(Object value, EnrichableModel withModelPropertiesModel) {
        ValueResolver<Object> resolver;
        if (value instanceof ValueResolver) {
            resolver = (StaticValueResolver<Object>)value;
        } else if (value instanceof Collection) {
            resolver = this.getCollectionResolver((Collection)value);
        } else if (value instanceof Map) {
            resolver = this.getMapResolver((Map)value);
        } else {
            Optional<Object> stackedTypesModelProperty;
            Optional<Object> optional = stackedTypesModelProperty = withModelPropertiesModel == null ? Optional.empty() : StackedTypesModelProperty.getStackedTypesModelProperty(withModelPropertiesModel);
            if (stackedTypesModelProperty.isPresent()) {
                resolver = ((StackedTypesModelProperty)stackedTypesModelProperty.get()).getValueResolverFactory().getStaticValueResolver(value);
            } else if (value instanceof ConfigurationProvider) {
                resolver = new ConfigurationValueResolver((ConfigurationProvider)value);
            } else {
                resolver = new StaticValueResolver<Object>(value);
                if (value instanceof ObjectStore) {
                    resolver = new LifecycleInitialiserValueResolverWrapper<Object>(resolver, this.muleContext);
                }
            }
        }
        return resolver;
    }

    private ValueResolver<?> getMapResolver(Map<Object, Object> value) {
        LinkedHashMap normalizedMap = new LinkedHashMap(value.size());
        value.forEach((key, entryValue) -> normalizedMap.put(this.toValueResolver(key), this.toValueResolver(entryValue)));
        return MapValueResolver.of(value.getClass(), new ArrayList(normalizedMap.keySet()), new ArrayList(normalizedMap.values()), this.reflectionCache, this.muleContext);
    }

    private ValueResolver<?> getCollectionResolver(Collection<?> collection) {
        return CollectionValueResolver.of(collection.getClass(), (List)collection.stream().map(p -> this.toValueResolver(p)).collect(org.mule.runtime.api.util.collection.Collectors.toImmutableList()));
    }

    protected Map<String, ?> getParameters() {
        return this.parameters;
    }
}

