/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;

public final class FieldSetter<Target, Value> {
    private final Field field;
    private final Method setterMethod;

    public FieldSetter(Field field) {
        Method setterMethod = null;
        this.field = field;
        try {
            field.setAccessible(true);
        }
        catch (Exception e) {
            try {
                setterMethod = field.getDeclaringClass().getDeclaredMethod("set" + StringUtils.capitalize((String)field.getName()), field.getType());
            }
            catch (NoSuchMethodException e1) {
                e.addSuppressed(e1);
                throw e;
            }
        }
        this.setterMethod = setterMethod;
    }

    public void set(Target target, Value value) {
        if (this.setterMethod != null) {
            try {
                this.setterMethod.invoke(target, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
            }
        }
        try {
            this.field.set(target, value);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public Field getField() {
        return this.field;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldSetter other = (FieldSetter)obj;
        return !(this.field == null ? other.field != null : !this.field.equals(other.field));
    }
}

