/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.delegate;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasConnectionProviderDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasParametersDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasSourceDeclarer;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.parser.ConfigurationModelParser;
import org.mule.runtime.extension.api.loader.parser.ExtensionModelParser;
import org.mule.runtime.extension.api.loader.parser.StereotypeModelParser;
import org.mule.runtime.extension.api.property.NoImplicitModelProperty;
import org.mule.runtime.module.extension.internal.loader.delegate.AbstractComponentModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.DefaultExtensionModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.ConfigurationFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.MinMuleVersionUtils;

final class ConfigModelLoaderDelegate
extends AbstractComponentModelLoaderDelegate {
    ConfigModelLoaderDelegate(DefaultExtensionModelLoaderDelegate delegate) {
        super(delegate);
    }

    void declareConfigurations(ExtensionDeclarer declarer, ExtensionModelParser extensionModelParser, ExtensionLoadingContext context) {
        for (ConfigurationModelParser configParser : extensionModelParser.getConfigurationParsers()) {
            String configName = this.resolveConfigName(configParser);
            ConfigurationDeclarer configurationDeclarer = declarer.withConfig(configName).describedAs(this.resolveConfigDescription(configParser, configName)).withModelProperty((ModelProperty)new ConfigurationFactoryModelProperty(configParser.getConfigurationFactory()));
            if (configParser.isForceNoImplicit()) {
                configurationDeclarer.withModelProperty((ModelProperty)new NoImplicitModelProperty());
            }
            configParser.getDeprecationModel().ifPresent(dm -> ((ConfigurationDeclaration)configurationDeclarer.getDeclaration()).withDeprecation(dm));
            configParser.getDisplayModel().ifPresent(d -> ((ConfigurationDeclaration)configurationDeclarer.getDeclaration()).setDisplayModel(d));
            configParser.getExternalLibraryModels().forEach(arg_0 -> ((ConfigurationDeclarer)configurationDeclarer).withExternalLibrary(arg_0));
            configParser.getAdditionalModelProperties().forEach(arg_0 -> ((ConfigurationDeclarer)configurationDeclarer).withModelProperty(arg_0));
            if (context.isResolveMinMuleVersion()) {
                configParser.getResolvedMinMuleVersion().ifPresent(resolvedMMV -> MinMuleVersionUtils.declarerWithMmv(configurationDeclarer, resolvedMMV));
            }
            this.loader.getParameterModelsLoaderDelegate().declare((HasParametersDeclarer)configurationDeclarer, configParser.getParameterGroupParsers(), context);
            this.getOperationLoaderDelegate().declareOperations(declarer, extensionModelParser.getDevelopmentFramework(), (HasOperationDeclarer)configurationDeclarer, configParser.getOperationParsers(), context);
            this.getSourceModelLoaderDelegate().declareMessageSources(declarer, (HasSourceDeclarer)configurationDeclarer, configParser.getSourceModelParsers(), context);
            this.getFunctionModelLoaderDelegate().declareFunctions(declarer, configParser.getFunctionModelParsers(), context);
            this.getConnectionProviderModelLoaderDelegate().declareConnectionProviders((HasConnectionProviderDeclarer)configurationDeclarer, configParser.getConnectionProviderModelParsers(), context);
            this.getStereotypeModelLoaderDelegate().addStereotypes((StereotypeModelParser)configParser, configurationDeclarer, Optional.of(() -> this.getStereotypeModelLoaderDelegate().getDefaultConfigStereotype(configParser.getName())));
        }
    }

    private String resolveConfigName(ConfigurationModelParser parser) {
        return StringUtils.isBlank((CharSequence)parser.getName()) ? "config" : parser.getName();
    }

    private String resolveConfigDescription(ConfigurationModelParser parser, String configName) {
        String description = parser.getDescription();
        if (StringUtils.isBlank((CharSequence)description) && "config".equals(configName)) {
            description = "Default configuration";
        }
        return description;
    }
}

