/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.delegate;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasConnectionProviderDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasOperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasSourceDeclarer;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.internal.util.version.JdkVersionUtils;
import org.mule.runtime.extension.api.ExtensionConstants;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.delegate.ModelLoaderDelegate;
import org.mule.runtime.extension.api.loader.parser.ExtensionModelParser;
import org.mule.runtime.extension.api.loader.parser.ExtensionModelParserFactory;
import org.mule.runtime.extension.api.loader.parser.LicenseModelParser;
import org.mule.runtime.extension.api.loader.parser.XmlDslConfiguration;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.error.ErrorsModelFactory;
import org.mule.runtime.module.extension.internal.loader.delegate.ConfigModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.ConnectionProviderModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.FunctionModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.OperationModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.ParameterModelsLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.SourceModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.delegate.StereotypeModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.enricher.PollingSourceDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.ArtifactLifecycleListenerModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.CompileTimeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.DevelopmentFrameworkModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ExceptionHandlerModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.LicenseModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.TypeLoaderModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.MinMuleVersionUtils;
import org.mule.runtime.module.extension.internal.loader.utils.ExtensionNamespaceUtils;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;
import org.mule.runtime.module.extension.internal.loader.validator.DeprecationModelValidator;
import org.mule.runtime.module.extension.internal.loader.validator.ParameterPluralNameModelValidator;
import org.mule.runtime.module.extension.internal.loader.validator.ValueProviderModelValidator;
import org.mule.runtime.module.extension.internal.runtime.operation.IllegalSourceException;

public class DefaultExtensionModelLoaderDelegate
implements ModelLoaderDelegate {
    private final List<ExtensionModelValidator> VALIDATORS = List.of(new DeprecationModelValidator(), new ParameterPluralNameModelValidator(), new ValueProviderModelValidator());
    private final List<DeclarationEnricher> ENRICHERS = List.of(new PollingSourceDeclarationEnricher());
    protected final String version;
    private final ConfigModelLoaderDelegate configLoaderDelegate = new ConfigModelLoaderDelegate(this);
    private final OperationModelLoaderDelegate operationLoaderDelegate = new OperationModelLoaderDelegate(this);
    private final FunctionModelLoaderDelegate functionModelLoaderDelegate = new FunctionModelLoaderDelegate(this);
    private final SourceModelLoaderDelegate sourceModelLoaderDelegate = new SourceModelLoaderDelegate(this);
    private final ConnectionProviderModelLoaderDelegate connectionProviderModelLoaderDelegate = new ConnectionProviderModelLoaderDelegate(this);
    private final ParameterModelsLoaderDelegate parameterModelsLoaderDelegate = new ParameterModelsLoaderDelegate(this::getStereotypeModelLoaderDelegate, this::registerType);
    private final Map<String, NotificationModel> notificationModels = new LinkedHashMap<String, NotificationModel>();
    private StereotypeModelLoaderDelegate stereotypeModelLoaderDelegate;
    private Supplier<ErrorsModelFactory> errorsModelFactorySupplier;
    private ExtensionDeclarer declarer;
    private String namespace;

    public DefaultExtensionModelLoaderDelegate(String version) {
        this.version = version;
    }

    public ExtensionDeclarer declare(ExtensionModelParserFactory parserFactory, ExtensionLoadingContext context) {
        try {
            return this.doDeclare(parserFactory, context);
        }
        catch (Exception e) {
            NoClassDefFoundError ncdfe = (NoClassDefFoundError)ExceptionUtils.throwableOfType((Throwable)e, NoClassDefFoundError.class);
            if (ncdfe == null || ncdfe.getMessage().startsWith("javax/")) {
                throw e;
            }
            JdkVersionUtils.JdkVersion runningJdkVersion = JdkVersionUtils.getJdkVersion();
            Set supportedJavaVersions = ((ExtensionDeclaration)context.getExtensionDeclarer().getDeclaration()).getSupportedJavaVersions();
            if (supportedJavaVersions.isEmpty()) {
                supportedJavaVersions = ExtensionConstants.DEFAULT_SUPPORTED_JAVA_VERSIONS;
            }
            throw new IllegalSourceException(String.format("Extension '%s' version %s does not support Mule 4.6+ on Java %s. Supported Java versions are: %s. (%s)", ((ExtensionDeclaration)context.getExtensionDeclarer().getDeclaration()).getName(), ((ExtensionDeclaration)context.getExtensionDeclarer().getDeclaration()).getVersion(), runningJdkVersion.getMajor(), supportedJavaVersions, ncdfe));
        }
    }

    private ExtensionDeclarer doDeclare(ExtensionModelParserFactory parserFactory, ExtensionLoadingContext context) {
        context.addCustomValidators(this.VALIDATORS);
        context.addCustomDeclarationEnrichers(this.ENRICHERS);
        ExtensionModelParser parser = parserFactory.createParser(context);
        ExtensionDeclarer declarer = context.getExtensionDeclarer().named(parser.getName()).onVersion(this.version).supportingJavaVersions(parser.getSupportedJavaVersions()).fromVendor(parser.getVendor()).withCategory(parser.getCategory()).withModelProperty((ModelProperty)this.createLicenseModelProperty(parser.getLicensingParser())).withXmlDsl(ModelLoaderUtils.getXmlDslModel(parser.getName(), this.version, (Optional<XmlDslConfiguration>)parser.getXmlDslConfiguration()));
        context.getParameter("COMPILATION_MODE").ifPresent(m -> declarer.withModelProperty((ModelProperty)new CompileTimeModelProperty()));
        declarer.withModelProperty((ModelProperty)new DevelopmentFrameworkModelProperty(parser.getDevelopmentFramework()));
        declarer.withModelProperty((ModelProperty)new TypeLoaderModelProperty(context.getTypeLoader()));
        parser.getArtifactLifecycleListenerClass().map(ArtifactLifecycleListenerModelProperty::new).ifPresent(arg_0 -> ((ExtensionDeclarer)declarer).withModelProperty(arg_0));
        this.declarer = declarer;
        this.namespace = ExtensionNamespaceUtils.getExtensionsNamespace((ExtensionDeclaration)declarer.getDeclaration());
        this.stereotypeModelLoaderDelegate = new StereotypeModelLoaderDelegate(context);
        this.stereotypeModelLoaderDelegate.setNamespace(this.namespace);
        parser.getDeprecationModel().ifPresent(arg_0 -> ((ExtensionDeclarer)declarer).withDeprecation(arg_0));
        parser.getExternalLibraryModels().forEach(arg_0 -> ((ExtensionDeclarer)declarer).withExternalLibrary(arg_0));
        parser.getExceptionHandlerFactory().map(ExceptionHandlerModelProperty::new).ifPresent(arg_0 -> ((ExtensionDeclarer)declarer).withModelProperty(arg_0));
        parser.getAdditionalModelProperties().forEach(arg_0 -> ((ExtensionDeclarer)declarer).withModelProperty(arg_0));
        if (context.isResolveMinMuleVersion()) {
            parser.getResolvedMinMuleVersion().ifPresent(resolvedMMV -> MinMuleVersionUtils.declarerWithMmv(declarer, resolvedMMV));
        }
        this.declareErrorModels(parser, declarer);
        this.declareExports(parser, declarer);
        this.declareImportedTypes(parser, declarer, context);
        this.declareSubTypes(parser, declarer, context);
        this.declareNotifications(parser, declarer);
        this.configLoaderDelegate.declareConfigurations(declarer, parser, context);
        this.connectionProviderModelLoaderDelegate.declareConnectionProviders((HasConnectionProviderDeclarer)declarer, parser.getConnectionProviderModelParsers(), context);
        this.operationLoaderDelegate.declareOperations(declarer, parser.getDevelopmentFramework(), (HasOperationDeclarer)declarer, parser.getOperationModelParsers(), context);
        this.functionModelLoaderDelegate.declareFunctions(declarer, parser.getFunctionModelParsers(), context);
        this.sourceModelLoaderDelegate.declareMessageSources(declarer, (HasSourceDeclarer)declarer, parser.getSourceModelParsers(), context);
        this.getStereotypeModelLoaderDelegate().resolveDeclaredTypesStereotypes((ExtensionDeclaration)declarer.getDeclaration());
        return declarer;
    }

    private void declareNotifications(ExtensionModelParser parser, ExtensionDeclarer declarer) {
        parser.getNotificationModels().forEach(notification -> {
            declarer.withNotificationModel(notification);
            this.registerType(notification.getType());
            this.notificationModels.put(notification.getIdentifier(), (NotificationModel)notification);
        });
    }

    private void declareErrorModels(ExtensionModelParser parser, ExtensionDeclarer declarer) {
        this.initErrorModelFactorySupplier(parser);
        ((ExtensionDeclaration)declarer.getDeclaration()).getErrorModels().addAll(this.createErrorModelFactory().getErrorModels());
    }

    private void declareExports(ExtensionModelParser parser, ExtensionDeclarer declarer) {
        parser.getExportedTypes().forEach(type -> this.registerExportedType(declarer, (MetadataType)type));
        parser.getExportedResources().forEach(arg_0 -> ((ExtensionDeclarer)declarer).withResource(arg_0));
        parser.getPrivilegedExportedArtifacts().forEach(arg_0 -> ((ExtensionDeclarer)declarer).withPrivilegedArtifact(arg_0));
        parser.getPrivilegedExportedPackages().forEach(arg_0 -> ((ExtensionDeclarer)declarer).withPrivilegedPackage(arg_0));
    }

    private void declareImportedTypes(ExtensionModelParser parser, ExtensionDeclarer declarer, ExtensionLoadingContext context) {
        parser.getImportedTypes().forEach(importedType -> {
            Optional typeId = MetadataTypeUtils.getTypeId((MetadataType)importedType);
            if (!(importedType instanceof ObjectType)) {
                Object[] objectArray = new Object[1];
                objectArray[0] = typeId.orElseGet(importedType::toString);
                throw new IllegalArgumentException(String.format("Type '%s' is not complex. Only complex types can be imported from other extensions.", objectArray));
            }
            declarer.withImportedType(new ImportedTypeModel(typeId.flatMap(importedTypeId -> context.getDslResolvingContext().getTypeCatalog().getType(importedTypeId)).orElse((ObjectType)importedType)));
        });
    }

    private void declareSubTypes(ExtensionModelParser parser, ExtensionDeclarer declarer, ExtensionLoadingContext context) {
        parser.getSubTypes().forEach((base, subTypes) -> {
            declarer.withSubTypes(base, (Collection)subTypes);
            this.autoImportReferencedTypes(declarer, (MetadataType)base, context);
            subTypes.forEach(subTypeEntry -> this.autoImportReferencedTypes(declarer, (MetadataType)subTypeEntry, context));
            this.registerType((MetadataType)base);
            subTypes.forEach(sub -> this.registerType((MetadataType)sub));
        });
    }

    private void autoImportReferencedTypes(ExtensionDeclarer declarer, MetadataType subType, ExtensionLoadingContext loadingContext) {
        MetadataTypeUtils.getTypeId((MetadataType)subType).filter(imported -> ExtensionMetadataTypeUtils.getType((MetadataType)subType, (ClassLoader)loadingContext.getExtensionClassLoader()).map(clazz -> !clazz.getClassLoader().equals(loadingContext.getExtensionClassLoader())).orElse(true)).ifPresent(subTypeId -> loadingContext.getDslResolvingContext().getTypeCatalog().getType(subTypeId).map(ImportedTypeModel::new).ifPresent(arg_0 -> ((ExtensionDeclarer)declarer).withImportedType(arg_0)));
    }

    public void registerOutputTypes(ExecutableComponentDeclaration<?> declaration) {
        if (declaration.getOutput() == null) {
            throw new IllegalModelDefinitionException(String.format("%s '%s' doesn't specify an output type", NameUtils.getComponentDeclarationTypeName(declaration), declaration.getName()));
        }
        if (declaration.getOutputAttributes() == null) {
            throw new IllegalModelDefinitionException(String.format("%s '%s' doesn't specify output attributes types", NameUtils.getComponentDeclarationTypeName(declaration), declaration.getName()));
        }
        this.registerType(declaration.getOutput().getType());
        this.registerType(declaration.getOutputAttributes().getType());
    }

    public void registerType(MetadataType type) {
        ExtensionMetadataTypeUtils.registerType((ExtensionDeclarer)this.declarer, (MetadataType)type);
    }

    public Optional<NotificationModel> getNotificationModel(String identifier) {
        return Optional.ofNullable(this.notificationModels.get(identifier));
    }

    private void registerExportedType(final ExtensionDeclarer declarer, MetadataType type) {
        type.accept(new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                if (objectType.isOpen()) {
                    ((MetadataType)objectType.getOpenRestriction().get()).accept((MetadataTypeVisitor)this);
                } else {
                    declarer.withType(objectType);
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                arrayType.getType().accept((MetadataTypeVisitor)this);
            }

            public void visitIntersection(IntersectionType intersectionType) {
                intersectionType.getTypes().forEach(type -> type.accept((MetadataTypeVisitor)this));
            }

            public void visitUnion(UnionType unionType) {
                unionType.getTypes().forEach(type -> type.accept((MetadataTypeVisitor)this));
            }

            public void visitObjectField(ObjectFieldType objectFieldType) {
                objectFieldType.getValue().accept((MetadataTypeVisitor)this);
            }
        });
    }

    private void initErrorModelFactorySupplier(ExtensionModelParser parser) {
        this.errorsModelFactorySupplier = () -> new ErrorsModelFactory(parser.getErrorModelParsers(), this.namespace);
    }

    OperationModelLoaderDelegate getOperationLoaderDelegate() {
        return this.operationLoaderDelegate;
    }

    FunctionModelLoaderDelegate getFunctionModelLoaderDelegate() {
        return this.functionModelLoaderDelegate;
    }

    SourceModelLoaderDelegate getSourceModelLoaderDelegate() {
        return this.sourceModelLoaderDelegate;
    }

    ConnectionProviderModelLoaderDelegate getConnectionProviderModelLoaderDelegate() {
        return this.connectionProviderModelLoaderDelegate;
    }

    StereotypeModelLoaderDelegate getStereotypeModelLoaderDelegate() {
        Preconditions.checkState((this.stereotypeModelLoaderDelegate != null ? 1 : 0) != 0, (String)"stereotypeDelegate not yet initialized");
        return this.stereotypeModelLoaderDelegate;
    }

    ErrorsModelFactory createErrorModelFactory() {
        Preconditions.checkState((this.errorsModelFactorySupplier != null ? 1 : 0) != 0, (String)"errorModelFactorySupplier not yet initialized");
        return this.errorsModelFactorySupplier.get();
    }

    public ParameterModelsLoaderDelegate getParameterModelsLoaderDelegate() {
        return this.parameterModelsLoaderDelegate;
    }

    private LicenseModelProperty createLicenseModelProperty(LicenseModelParser parser) {
        return new LicenseModelProperty(parser.requiresEeLicense(), parser.isAllowsEvaluationLicense(), parser.getRequiredEntitlement());
    }
}

