/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal;

import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.internal.util.func.CheckedSupplier;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.internal.util.ReconnectionUtils;

public class ExtensionResolvingContext {
    private final LazyValue<Optional<ConfigurationInstance>> configurationInstance;
    private final LazyValue<Optional<ConnectionHandler>> connectionHandler;
    private final LazyValue<Optional<ConnectionProvider>> connectionProvider;

    public ExtensionResolvingContext(Supplier<Optional<ConfigurationInstance>> configurationSupplier, ConnectionManager connectionManager) {
        this.configurationInstance = new LazyValue(configurationSupplier);
        this.connectionHandler = new LazyValue((Supplier)((CheckedSupplier)() -> {
            Optional configurationInstance = (Optional)this.configurationInstance.get();
            if (configurationInstance.isPresent() && ((ConfigurationInstance)configurationInstance.get()).getConnectionProvider().isPresent()) {
                return Optional.ofNullable(connectionManager.getConnection(((ConfigurationInstance)configurationInstance.get()).getValue()));
            }
            return Optional.empty();
        }));
        this.connectionProvider = new LazyValue(() -> {
            Optional configurationInstance = (Optional)this.configurationInstance.get();
            if (configurationInstance.isPresent() && ((ConfigurationInstance)configurationInstance.get()).getConnectionProvider().isPresent()) {
                return Optional.of((ConnectionProvider)((ConfigurationInstance)configurationInstance.get()).getConnectionProvider().get());
            }
            return Optional.empty();
        });
    }

    public <C> Optional<C> getConfig() {
        return ((Optional)this.configurationInstance.get()).map(ConfigurationInstance::getValue);
    }

    public Optional<ConnectionProvider> getConnectionProvider() {
        return (Optional)this.connectionProvider.get();
    }

    public <C> Optional<C> getConnection() throws ConnectionException {
        try {
            return ((Optional)this.connectionHandler.get()).map(ConnectionHandler::getConnection);
        }
        catch (Exception e) {
            Optional<ConnectionException> connectionException = ReconnectionUtils.extractConnectionException(e);
            throw connectionException.orElse(new ConnectionException((Throwable)e));
        }
    }

    public void dispose() {
        this.connectionHandler.ifComputed(optionalHandler -> optionalHandler.ifPresent(ConnectionHandler::release));
    }
}

