/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java.test;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Configurations;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.parser.MinMuleVersionParser;
import org.mule.runtime.module.extension.api.loader.java.type.ComponentElement;
import org.mule.runtime.module.extension.api.loader.java.type.ConfigurationElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ExtensionTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaConfigurationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.test.MinMuleVersionTestUtils;
import org.mule.sdk.api.annotation.Extension;
import org.mule.sdk.api.annotation.NoImplicit;
import org.mule.sdk.api.annotation.Operations;
import org.mule.sdk.api.annotation.Sources;
import org.mule.sdk.api.annotation.connectivity.ConnectionProviders;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.connectivity.ConnectionProvider;
import org.mule.sdk.api.connectivity.ConnectionValidationResult;
import org.mule.sdk.api.runtime.source.Source;
import org.mule.sdk.api.runtime.source.SourceCallback;

public class JavaConfigurationModelParserTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void getConfigurationNameFromConfigurationUsingSdkApi() {
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(SimpleSdkExtension.class, SimpleSdkConfiguration.class);
        MatcherAssert.assertThat((Object)javaConfigurationModelParser.getName(), (Matcher)CoreMatchers.is((Object)"newSdkConfiguration"));
    }

    @Test
    public void getConfigurationNameFromConfigurationUsingLegacyApi() {
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(SimpleLegacyExtension.class, SimpleLegacyConfiguration.class);
        MatcherAssert.assertThat((Object)javaConfigurationModelParser.getName(), (Matcher)CoreMatchers.is((Object)"oldLegacyConfiguration"));
    }

    @Test
    public void getConfigurationNameFromConfigurationUsingSdkAndLegacyApi() {
        this.expectedException.expect(CoreMatchers.instanceOf(IllegalModelDefinitionException.class));
        this.expectedException.expectMessage("Annotations org.mule.runtime.extension.api.annotation.Configuration and org.mule.sdk.api.annotation.Configuration are both present at the same time on Configuration SimpleWronglyAnnotatedConfiguration");
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(SimpleSdkExtensionWithWronglyAnnotatedConfiguration.class, SimpleWronglyAnnotatedConfiguration.class);
        javaConfigurationModelParser.getName();
    }

    @Test
    public void isForceNoImplicitOnConfigurationUsingTheSdkApi() {
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(SimpleSdkExtension.class, SimpleSdkConfiguration.class);
        MatcherAssert.assertThat((Object)javaConfigurationModelParser.isForceNoImplicit(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void isForceNoImplicitOnConfigurationUsingTheLegacyApi() {
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(SimpleLegacyExtension.class, SimpleLegacyConfiguration.class);
        MatcherAssert.assertThat((Object)javaConfigurationModelParser.isForceNoImplicit(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void getMMVForLegacyImplicitConfiguration() {
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(LegacyAnnotationsExtension.class, NoImplicitLegacyConfiguration.class);
        MatcherAssert.assertThat((Object)((MinMuleVersionParser)javaConfigurationModelParser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.3"));
        MatcherAssert.assertThat((Object)((MinMuleVersionParser)javaConfigurationModelParser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Configuration NoImplicitLegacyConfiguration has min mule version 4.3 because it is annotated with NoImplicit. NoImplicit was introduced in Mule 4.3."));
    }

    @Test
    public void getMMVForSdkImplicitConfiguration() {
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(LegacyAnnotationsExtension.class, NoImplicitSdkConfiguration.class);
        MatcherAssert.assertThat((Object)((MinMuleVersionParser)javaConfigurationModelParser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.5.0"));
        MatcherAssert.assertThat((Object)((MinMuleVersionParser)javaConfigurationModelParser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Configuration NoImplicitSdkConfiguration has min mule version 4.5.0 because it is annotated with NoImplicit. NoImplicit was introduced in Mule 4.5.0."));
    }

    @Test
    public void getMMVForLegacyAnnotationConfiguration() {
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(LegacyAnnotationsExtension.class, LegacyAnnotationConfiguration.class);
        MatcherAssert.assertThat((Object)((MinMuleVersionParser)javaConfigurationModelParser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.1.1"));
        MatcherAssert.assertThat((Object)((MinMuleVersionParser)javaConfigurationModelParser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Configuration LegacyAnnotationConfiguration has min mule version 4.1.1 because it is the default value."));
    }

    @Test
    public void getMMVForSdkAnnotationConfiguration() {
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(LegacyAnnotationsExtension.class, SdkAnnotationConfiguration.class);
        MatcherAssert.assertThat((Object)((MinMuleVersionParser)javaConfigurationModelParser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.5.0"));
        MatcherAssert.assertThat((Object)((MinMuleVersionParser)javaConfigurationModelParser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Configuration SdkAnnotationConfiguration has min mule version 4.5.0 because it is annotated with Configuration. Configuration was introduced in Mule 4.5.0."));
    }

    @Test
    public void getMMVForParameterizedConfiguration() {
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(LegacyAnnotationsExtension.class, ParameterizedConfiguration.class);
        MatcherAssert.assertThat((Object)((MinMuleVersionParser)javaConfigurationModelParser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.4"));
        MatcherAssert.assertThat((Object)((MinMuleVersionParser)javaConfigurationModelParser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Configuration ParameterizedConfiguration has min mule version 4.4 because of its field configField. Field configField has min mule version 4.4 because it is annotated with Parameter. Parameter was introduced in Mule 4.4."));
    }

    @Test
    public void getMMVForExtendsParameterizedConfiguration() {
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(LegacyAnnotationsExtension.class, ExtendsParameterizedConfiguration.class);
        MatcherAssert.assertThat((Object)((MinMuleVersionParser)javaConfigurationModelParser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.4"));
        MatcherAssert.assertThat((Object)((MinMuleVersionParser)javaConfigurationModelParser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Configuration ExtendsParameterizedConfiguration has min mule version 4.4 because of its super class ParameterizedConfiguration. Configuration ParameterizedConfiguration has min mule version 4.4 because of its field configField. Field configField has min mule version 4.4 because it is annotated with Parameter. Parameter was introduced in Mule 4.4."));
    }

    @Test
    public void getMMVForAnnotatedConfiguration() {
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(LegacyAnnotationsExtension.class, AnnotatedConfiguration.class);
        MatcherAssert.assertThat((Object)((MinMuleVersionParser)javaConfigurationModelParser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.1.1"));
        MatcherAssert.assertThat((Object)((MinMuleVersionParser)javaConfigurationModelParser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Configuration AnnotatedConfiguration has min mule version 4.1.1 because it is the default value."));
    }

    @Test
    public void getMMVForConfigurationFromExtensionWithSdkConfigurationsAnnotation() {
        JavaConfigurationModelParser javaConfigurationModelParser = this.getParser(SimpleLegacyExtension.class, SimpleLegacyConfiguration.class);
        MatcherAssert.assertThat((Object)((MinMuleVersionParser)javaConfigurationModelParser.getResolvedMinMuleVersion().get()).getMinMuleVersion().toString(), (Matcher)CoreMatchers.is((Object)"4.5.0"));
        MatcherAssert.assertThat((Object)((MinMuleVersionParser)javaConfigurationModelParser.getResolvedMinMuleVersion().get()).getReason(), (Matcher)CoreMatchers.is((Object)"Configuration SimpleLegacyConfiguration has min mule version 4.5.0 because it was propagated from the annotation (either @Configurations or @Config) used to reference this configuration."));
    }

    protected JavaConfigurationModelParser getParser(Class<?> extension, Class<?> configuration) {
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(Thread.currentThread().getContextClassLoader());
        ExtensionTypeWrapper extensionElement = new ExtensionTypeWrapper(extension, typeLoader);
        ConfigurationElement configurationElement = extensionElement.getConfigurations().stream().filter(conf -> conf.getTypeName().equals(configuration.getName())).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Configuration %s was not found among the declared configuration in the extension", configuration.getName(), extension.getName())));
        ExtensionLoadingContext ctx = MinMuleVersionTestUtils.ctxResolvingMinMuleVersion();
        JavaExtensionModelParser javaExtensionModelParser = new JavaExtensionModelParser((ExtensionElement)extensionElement, ctx);
        return new JavaConfigurationModelParser(javaExtensionModelParser, (ExtensionElement)extensionElement, (ComponentElement)configurationElement, ctx);
    }

    @Extension(name="SimpleSdkExtension")
    @org.mule.sdk.api.annotation.Configurations(value={SimpleSdkConfiguration.class})
    private static class SimpleSdkExtension {
        private SimpleSdkExtension() {
        }
    }

    @org.mule.sdk.api.annotation.Configuration(name="newSdkConfiguration")
    @NoImplicit
    private static class SimpleSdkConfiguration {
        private SimpleSdkConfiguration() {
        }
    }

    @Extension(name="SimpleLegacyExtension")
    @org.mule.sdk.api.annotation.Configurations(value={SimpleLegacyConfiguration.class})
    private static class SimpleLegacyExtension {
        private SimpleLegacyExtension() {
        }
    }

    @Configuration(name="oldLegacyConfiguration")
    @org.mule.runtime.extension.api.annotation.NoImplicit
    private static class SimpleLegacyConfiguration {
        private SimpleLegacyConfiguration() {
        }
    }

    @Extension(name="SimpleSdkExtension")
    @org.mule.sdk.api.annotation.Configurations(value={SimpleWronglyAnnotatedConfiguration.class})
    private static class SimpleSdkExtensionWithWronglyAnnotatedConfiguration {
        private SimpleSdkExtensionWithWronglyAnnotatedConfiguration() {
        }
    }

    @org.mule.sdk.api.annotation.Configuration(name="wronglySdkConfiguration")
    @Configuration(name="wronglyLegacyConfiguration")
    private static class SimpleWronglyAnnotatedConfiguration {
        private SimpleWronglyAnnotatedConfiguration() {
        }
    }

    @org.mule.runtime.extension.api.annotation.Extension(name="SimpleLegacyExtensionWithOperations")
    @Configurations(value={NoImplicitLegacyConfiguration.class, NoImplicitSdkConfiguration.class, LegacyAnnotationConfiguration.class, SdkAnnotationConfiguration.class, ParameterizedConfiguration.class, AnnotatedConfiguration.class, ExtendsParameterizedConfiguration.class})
    private static class LegacyAnnotationsExtension {
        private LegacyAnnotationsExtension() {
        }
    }

    @Configuration(name="NoImplicitLegacyConfiguration")
    @org.mule.runtime.extension.api.annotation.NoImplicit
    private static class NoImplicitLegacyConfiguration {
        private NoImplicitLegacyConfiguration() {
        }
    }

    @Configuration(name="NoImplicitSdkConfiguration")
    @NoImplicit
    private static class NoImplicitSdkConfiguration {
        private NoImplicitSdkConfiguration() {
        }
    }

    @Configuration(name="LegacyAnnotationConfiguration")
    private static class LegacyAnnotationConfiguration {
        private LegacyAnnotationConfiguration() {
        }
    }

    @org.mule.sdk.api.annotation.Configuration(name="SdkAnnotationConfiguration")
    private static class SdkAnnotationConfiguration {
        private SdkAnnotationConfiguration() {
        }
    }

    @Configuration(name="ParameterizedConfiguration")
    private static class ParameterizedConfiguration {
        @Parameter
        String configField;

        private ParameterizedConfiguration() {
        }
    }

    @Configuration(name="ExtendsParameterizedConfiguration")
    private static class ExtendsParameterizedConfiguration
    extends ParameterizedConfiguration {
        private ExtendsParameterizedConfiguration() {
        }
    }

    @Configuration(name="ParameterizedConfiguration")
    @Operations(value={SimpleOperations.class})
    @Sources(value={SdkSource.class})
    @ConnectionProviders(value={SdkConnectionProvider.class})
    private static class AnnotatedConfiguration {
        private AnnotatedConfiguration() {
        }
    }

    private static class SdkSource
    extends Source<String, String> {
        private SdkSource() {
        }

        public void onStart(SourceCallback<String, String> sourceCallback) throws MuleException {
        }

        public void onStop() {
        }
    }

    private static class SdkConnectionProvider
    implements ConnectionProvider<String> {
        private SdkConnectionProvider() {
        }

        public String connect() throws ConnectionException {
            return null;
        }

        public void disconnect(String connection) {
        }

        public ConnectionValidationResult validate(String connection) {
            return null;
        }
    }

    private static class SimpleOperations {
        private SimpleOperations() {
        }
    }
}

