/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.module.extension.internal.runtime.resolver.AbstractValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.AbstractValueResolverWrapperTestCase;
import org.mule.runtime.module.extension.internal.runtime.resolver.RequiredParameterValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class RequiredParameterValueResolverWrapperTestCase
extends AbstractValueResolverWrapperTestCase<Object> {
    private static final String PARAMETER_NAME = "requiredParam";
    private static final String EXPRESSION = "#[someExpression]";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Mock
    private ValueResolvingContext context;

    @Override
    protected AbstractValueResolverWrapper<Object> createWrapper(ValueResolver<Object> delegate) {
        return new RequiredParameterValueResolverWrapper(delegate, PARAMETER_NAME, EXPRESSION);
    }

    @Override
    protected ValueResolver<Object> createDelegate() {
        return (ValueResolver)Mockito.mock(ValueResolver.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Lifecycle.class}));
    }

    @Test
    public void nonNullValue() throws Exception {
        Object value = new Object();
        Mockito.when((Object)this.delegate.resolve(this.context)).thenReturn(value);
        Assert.assertThat((Object)this.wrapper.resolve(this.context), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)value)));
    }

    @Test
    public void resolveNullValue() throws Exception {
        Mockito.when((Object)this.delegate.resolve(this.context)).thenReturn(null);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(Matchers.allOf((Matcher)CoreMatchers.containsString((String)PARAMETER_NAME), (Matcher)CoreMatchers.containsString((String)EXPRESSION)));
        this.wrapper.resolve(this.context);
    }
}

