/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.registry.MuleRegistry;
import org.mule.runtime.module.extension.internal.runtime.resolver.RegistryLookupValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class RegistryLookupValueResolverTestCase
extends AbstractMuleTestCase {
    private static final String KEY = "key";
    private static final String FAKE_KEY = "not there";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private InternalEvent event;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext muleContext;
    private ValueResolver resolver;

    @Before
    public void before() throws Exception {
        Mockito.when((Object)this.muleContext.getRegistry().get(KEY)).thenReturn((Object)"Hello World!");
        Mockito.when((Object)this.muleContext.getRegistry().get(FAKE_KEY)).thenReturn(null);
        this.resolver = new RegistryLookupValueResolver(KEY);
        ((RegistryLookupValueResolver)this.resolver).setMuleContext(this.muleContext);
    }

    @Test
    public void cache() throws Exception {
        Object value = this.resolver.resolve(ValueResolvingContext.from((InternalEvent)this.event));
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"Hello World!"));
        ((MuleRegistry)Mockito.verify((Object)this.muleContext.getRegistry())).get(KEY);
    }

    @Test
    public void isDynamic() {
        Assert.assertThat((Object)this.resolver.isDynamic(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=IllegalArgumentException.class)
    public void nullKey() {
        new RegistryLookupValueResolver(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void blankKey() {
        new RegistryLookupValueResolver("");
    }

    @Test(expected=ConfigurationException.class)
    public void nonExistingKey() throws Exception {
        RegistryLookupValueResolver valueResolver = new RegistryLookupValueResolver(FAKE_KEY);
        valueResolver.setMuleContext(this.muleContext);
        valueResolver.resolve(ValueResolvingContext.from((InternalEvent)this.event));
    }
}

