/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.el.DefaultExpressionLanguageFactoryService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.retry.policy.NoRetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.core.el.DefaultExpressionManager;
import org.mule.runtime.core.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.core.internal.message.InternalMessage;
import org.mule.runtime.core.internal.policy.OperationExecutionFunction;
import org.mule.runtime.core.internal.policy.OperationPolicy;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.ValueResolvingException;
import org.mule.runtime.module.extension.internal.runtime.operation.AbstractOperationMessageProcessorTestCase;
import org.mule.runtime.module.extension.internal.runtime.operation.IllegalOperationException;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.operation.PrecalculatedExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.tck.junit4.matcher.MetadataKeyMatcher;
import org.mule.tck.size.SmallTest;
import org.mule.test.metadata.extension.resolver.TestNoConfigMetadataResolver;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.weave.v2.el.WeaveDefaultExpressionLanguageFactoryService;
import reactor.core.publisher.Mono;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class OperationMessageProcessorTestCase
extends AbstractOperationMessageProcessorTestCase {
    private static final String SOME_PARAM_NAME = "someParam";
    private static final String FLOW_NAME = "flowName";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Override
    protected OperationMessageProcessor createOperationMessageProcessor() {
        OperationMessageProcessor operationMessageProcessor = new OperationMessageProcessor(this.extensionModel, this.operationModel, this.configurationProvider, this.target, this.targetValue, this.resolverSet, (CursorProviderFactory)this.cursorStreamProviderFactory, (RetryPolicyTemplate)new NoRetryPolicyTemplate(), this.extensionManager, this.mockPolicyManager);
        operationMessageProcessor.setAnnotations(OperationMessageProcessorTestCase.getFlowComponentLocationAnnotations((String)FLOW_NAME));
        return operationMessageProcessor;
    }

    @Test
    public void operationContextIsWellFormed() throws Exception {
        ArgumentCaptor operationContextCaptor = ArgumentCaptor.forClass(ExecutionContext.class);
        this.messageProcessor.process(this.event);
        ((ComponentExecutor)Mockito.verify((Object)this.operationExecutor)).execute((ExecutionContext)operationContextCaptor.capture());
        ExecutionContext executionContext = (ExecutionContext)operationContextCaptor.getValue();
        Assert.assertThat((Object)executionContext, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ExecutionContextAdapter.class)));
        ExecutionContextAdapter executionContextAdapter = (ExecutionContextAdapter)executionContext;
        Assert.assertThat((Object)executionContextAdapter.getEvent(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.event)));
        Assert.assertThat((Object)((ConfigurationInstance)executionContextAdapter.getConfiguration().get()).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.configuration)));
    }

    @Test
    public void operationExecutorIsInvoked() throws Exception {
        this.messageProcessor.process(this.event);
        ((ComponentExecutor)Mockito.verify((Object)this.operationExecutor)).execute((ExecutionContext)Matchers.any(ExecutionContext.class));
    }

    @Test
    public void operationReturnsOperationResultWhichKeepsNoValues() throws Exception {
        Object payload = new Object();
        MediaType mediaType = MediaType.ANY.withCharset(SystemUtils.getDefaultEncoding((MuleContext)this.context));
        Object attributes = Mockito.mock(Object.class);
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)Matchers.any(ExecutionContext.class))).thenReturn((Object)Mono.just((Object)Result.builder().output(payload).mediaType(mediaType).attributes(attributes).build()));
        Message message = this.messageProcessor.process(this.event).getMessage();
        Assert.assertThat((Object)message, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)payload)));
        Assert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)attributes)));
        Assert.assertThat((Object)message.getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.is((Object)mediaType));
    }

    @Test
    public void operationReturnsOperationResultOnTarget() throws Exception {
        this.target = "myFlowVar";
        this.messageProcessor = this.setUpOperationMessageProcessor();
        Object payload = new Object();
        MediaType mediaType = MediaType.ANY.withCharset(SystemUtils.getDefaultEncoding((MuleContext)this.context));
        Object attributes = Mockito.mock(Object.class);
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)Matchers.any(ExecutionContext.class))).thenReturn((Object)Mono.just((Object)Result.builder().output(payload).mediaType(mediaType).attributes(attributes).build()));
        InternalMessage message = (InternalMessage)((TypedValue)this.messageProcessor.process(this.event).getVariables().get("myFlowVar")).getValue();
        Assert.assertThat((Object)message, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)payload)));
        Assert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)attributes)));
        Assert.assertThat((Object)message.getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.equalTo((Object)mediaType));
    }

    @Test
    public void operationReturnsOperationResultButKeepsAttributes() throws Exception {
        Object payload = new Object();
        MediaType mediaType = MediaType.ANY.withCharset(SystemUtils.getDefaultEncoding((MuleContext)this.context));
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)Matchers.any(ExecutionContext.class))).thenReturn((Object)Mono.just((Object)Result.builder().output(payload).mediaType(mediaType).build()));
        this.event = InternalEvent.builder((InternalEvent)this.event).message(Message.builder().value((Object)"").attributesValue(Mockito.mock(Object.class)).build()).build();
        Message message = this.messageProcessor.process(this.event).getMessage();
        Assert.assertThat((Object)message, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)payload)));
        Assert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)message.getPayload().getDataType().getMediaType(), (Matcher)CoreMatchers.equalTo((Object)mediaType));
    }

    @Test
    public void operationReturnsOperationResultThatOnlySpecifiesPayload() throws Exception {
        String payload = "hello world!";
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)Matchers.any(ExecutionContext.class))).thenReturn((Object)Mono.just((Object)Result.builder().output((Object)payload).build()));
        this.event = InternalEvent.builder((InternalEvent)this.event).message(Message.builder().value((Object)"").attributesValue(Mockito.mock(Object.class)).build()).build();
        Message message = this.messageProcessor.process(this.event).getMessage();
        Assert.assertThat((Object)message, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)payload)));
        Assert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)message.getPayload().getDataType().getType().equals(String.class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void operationReturnsOperationResultWithPayloadAndAttributes() throws Exception {
        String payload = "hello world!";
        Object attributes = Mockito.mock(Object.class);
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)Matchers.any(ExecutionContext.class))).thenReturn((Object)Mono.just((Object)Result.builder().output((Object)payload).attributes(attributes).build()));
        Message message = this.messageProcessor.process(this.event).getMessage();
        Assert.assertThat((Object)message, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)payload)));
        Assert.assertThat((Object)message.getAttributes().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)attributes)));
        Assert.assertThat((Object)message.getPayload().getDataType().getType().equals(String.class), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void operationReturnsPayloadValue() throws Exception {
        Object value = new Object();
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)Matchers.any(ExecutionContext.class))).thenReturn((Object)Mono.just((Object)value));
        Message message = this.messageProcessor.process(this.event).getMessage();
        Assert.assertThat((Object)message, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)value)));
    }

    @Test
    public void operationReturnsPayloadValueWithTarget() throws Exception {
        this.target = "myFlowVar";
        this.messageProcessor = this.setUpOperationMessageProcessor();
        Object value = new Object();
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)Matchers.any(ExecutionContext.class))).thenReturn((Object)Mono.just((Object)value));
        InternalMessage message = (InternalMessage)((TypedValue)this.messageProcessor.process(this.event).getVariables().get("myFlowVar")).getValue();
        Assert.assertThat((Object)message, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)value)));
    }

    @Test
    public void operationWithExpressionInTargetParameter() throws Exception {
        String flowName = FLOW_NAME;
        this.expectedException.expect(IllegalOperationException.class);
        this.expectedException.expectMessage(String.format("Root component '%s' defines an invalid usage of operation '%s' which uses %s as %s", flowName, this.operationModel.getName(), "an expression", "target"));
        this.target = "#[mel:someExpression]";
        this.messageProcessor = this.createOperationMessageProcessor();
        Mockito.when((Object)this.context.getRegistry().lookupObject("_muleExpressionLanguage")).thenReturn((Object)new MVELExpressionLanguage(this.context));
        Mockito.when((Object)this.context.getRegistry().lookupObject(DefaultExpressionLanguageFactoryService.class)).thenReturn((Object)new WeaveDefaultExpressionLanguageFactoryService());
        ((MuleContext)Mockito.doReturn((Object)new DefaultExpressionManager(this.context, this.streamingManager)).when((Object)this.context)).getExpressionManager();
        FlowConstruct flowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)flowConstruct.getName()).thenReturn((Object)flowName);
        this.messageProcessor.setMuleContext(this.context);
        this.messageProcessor.initialise();
    }

    @Test
    public void operationWithoutExpressionInTargetValueParameter() throws Exception {
        String flowName = FLOW_NAME;
        this.expectedException.expect(IllegalOperationException.class);
        this.expectedException.expectMessage(String.format("Root component '%s' defines an invalid usage of operation '%s' which uses %s as %s", flowName, this.operationModel.getName(), "something that is not an expression", "targetValue"));
        this.target = "myFlowVar";
        this.targetValue = "myFlowVar";
        this.messageProcessor = this.createOperationMessageProcessor();
        Mockito.when((Object)this.context.getRegistry().lookupObject("_muleExpressionLanguage")).thenReturn((Object)new MVELExpressionLanguage(this.context));
        Mockito.when((Object)this.context.getRegistry().lookupObject(DefaultExpressionLanguageFactoryService.class)).thenReturn((Object)new WeaveDefaultExpressionLanguageFactoryService());
        ((MuleContext)Mockito.doReturn((Object)new DefaultExpressionManager(this.context, this.streamingManager)).when((Object)this.context)).getExpressionManager();
        FlowConstruct flowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class);
        Mockito.when((Object)flowConstruct.getName()).thenReturn((Object)flowName);
        this.messageProcessor.setMuleContext(this.context);
        this.messageProcessor.initialise();
    }

    @Test
    public void operationIsVoid() throws Exception {
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)new ImmutableOutputModel("Message.Payload", ExtensionsTestUtils.toMetadataType(Void.TYPE), false, Collections.emptySet()));
        this.messageProcessor = this.setUpOperationMessageProcessor();
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)Matchers.any(ExecutionContext.class))).thenReturn((Object)Mono.empty());
        Assert.assertThat((Object)this.messageProcessor.process(this.event), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.event)));
    }

    @Test
    public void executesWithDefaultConfig() throws Exception {
        this.configurationName = null;
        this.messageProcessor = this.setUpOperationMessageProcessor();
        Object defaultConfigInstance = new Object();
        Mockito.when((Object)this.configurationInstance.getValue()).thenReturn(defaultConfigInstance);
        Mockito.when((Object)this.extensionManager.getConfiguration(this.extensionModel, (ComponentModel)this.operationModel, this.event)).thenReturn(Optional.of(this.configurationInstance));
        ArgumentCaptor operationContextCaptor = ArgumentCaptor.forClass(ExecutionContext.class);
        this.messageProcessor.process(this.event);
        ((ComponentExecutor)Mockito.verify((Object)this.operationExecutor)).execute((ExecutionContext)operationContextCaptor.capture());
        ExecutionContext executionContext = (ExecutionContext)operationContextCaptor.getValue();
        Assert.assertThat((Object)executionContext, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ExecutionContextAdapter.class)));
        Assert.assertThat((Object)((ConfigurationInstance)executionContext.getConfiguration().get()).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)defaultConfigInstance)));
    }

    @Test
    public void executeWithPolicy() throws Exception {
        this.messageProcessor.setAnnotations(Collections.singletonMap(AbstractAnnotatedObject.LOCATION_KEY, TEST_CONNECTOR_LOCATION));
        this.messageProcessor.process(this.event);
        ((PolicyManager)Mockito.verify((Object)this.mockPolicyManager)).createOperationPolicy((AnnotatedObject)Matchers.eq((Object)this.messageProcessor), (InternalEvent)Matchers.same((Object)this.event), (Map)Matchers.any(Map.class), (OperationExecutionFunction)Matchers.any(OperationExecutionFunction.class));
        ((OperationPolicy)Mockito.verify((Object)this.mockOperationPolicy)).process((InternalEvent)Matchers.same((Object)this.event));
    }

    @Test
    public void skipPolicyWithNoComponentLocation() throws Exception {
        this.messageProcessor.setAnnotations(new HashMap());
        this.messageProcessor.process(this.event);
        Assert.assertThat((Object)this.mockOperationPolicy, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        ((PolicyManager)Mockito.verify((Object)this.mockPolicyManager, (VerificationMode)Mockito.never())).createOperationPolicy((AnnotatedObject)Matchers.eq((Object)this.messageProcessor), (InternalEvent)Matchers.same((Object)this.event), (Map)Matchers.any(Map.class), (OperationExecutionFunction)Matchers.any(OperationExecutionFunction.class));
    }

    @Test
    public void getMetadataKeyIdObjectValue() throws MuleException, ValueResolvingException {
        this.setUpValueResolvers();
        Object metadataKeyValue = this.messageProcessor.getParameterValueResolver().getParameterValue(SOME_PARAM_NAME);
        Assert.assertThat((Object)metadataKeyValue, (Matcher)CoreMatchers.is((Object)"person"));
    }

    @Test
    public void getMetadataKeys() throws Exception {
        MetadataResult metadataKeysResult = this.messageProcessor.getMetadataKeys();
        ((MetadataResolverFactory)Mockito.verify((Object)this.metadataResolverFactory)).getKeyResolver();
        Assert.assertThat((Object)metadataKeysResult.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        Set<MetadataKey> metadataKeys = this.getKeysFromContainer((MetadataKeysContainer)metadataKeysResult.get());
        Assert.assertThat((Object)metadataKeys.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat(metadataKeys, (Matcher)CoreMatchers.hasItem((Matcher)MetadataKeyMatcher.metadataKeyWithId((String)TestNoConfigMetadataResolver.KeyIds.BOOLEAN.name())));
        Assert.assertThat(metadataKeys, (Matcher)CoreMatchers.hasItem((Matcher)MetadataKeyMatcher.metadataKeyWithId((String)TestNoConfigMetadataResolver.KeyIds.STRING.name())));
    }

    @Test
    public void getProcessingType() {
        this.assertProcessingType(ExecutionType.CPU_INTENSIVE, ReactiveProcessor.ProcessingType.CPU_INTENSIVE);
        this.assertProcessingType(ExecutionType.CPU_LITE, ReactiveProcessor.ProcessingType.CPU_LITE);
        this.assertProcessingType(ExecutionType.BLOCKING, ReactiveProcessor.ProcessingType.BLOCKING);
    }

    @Test
    public void precalculateExecutionContext() throws MuleException {
        AtomicReference context = new AtomicReference();
        this.messageProcessor.resolveParameters(InternalEvent.builder((InternalEvent)this.event), (params, ctx) -> {
            Assert.assertThat((Object)ctx, (Matcher)CoreMatchers.instanceOf(PrecalculatedExecutionContextAdapter.class));
            context.set(Mockito.spy((Object)((PrecalculatedExecutionContextAdapter)ctx)));
        });
        this.messageProcessor.process(InternalEvent.builder((InternalEvent)this.event).internalParameters(Collections.singletonMap("core:interceptionResolvedContext", context.get())).build());
        ((ComponentExecutor)Mockito.verify((Object)this.operationExecutor)).execute((ExecutionContext)Matchers.any(ExecutionContext.class));
        this.messageProcessor.disposeResolvedParameters((ExecutionContext)context.get());
    }

    @Test
    public void cursorStreamProvidersAreManaged() throws Exception {
        CursorStreamProvider provider = (CursorStreamProvider)Mockito.mock(CursorStreamProvider.class);
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        ((CursorStreamProviderFactory)Mockito.doReturn((Object)provider).when((Object)this.cursorStreamProviderFactory)).of(this.event, (Object)inputStream);
        ((StreamingManager)Mockito.doReturn((Object)provider).when((Object)this.streamingManager)).manage((CursorProvider)provider, this.event);
        Mockito.when((Object)this.operationExecutor.execute((ExecutionContext)Matchers.any())).thenReturn((Object)Mono.just((Object)inputStream));
        this.messageProcessor.process(this.event);
        ((StreamingManager)Mockito.verify((Object)this.streamingManager)).manage((CursorProvider)Matchers.same((Object)provider), (InternalEvent)Matchers.any());
    }

    private void assertProcessingType(ExecutionType executionType, ReactiveProcessor.ProcessingType expectedProcessingType) {
        Mockito.when((Object)this.operationModel.getExecutionType()).thenReturn((Object)executionType);
        Assert.assertThat((Object)this.messageProcessor.getProcessingType(), (Matcher)CoreMatchers.is((Object)expectedProcessingType));
    }

    private Set<MetadataKey> getKeysFromContainer(MetadataKeysContainer metadataKeysContainer) {
        return (Set)metadataKeysContainer.getKeys((String)metadataKeysContainer.getCategories().iterator().next()).get();
    }

    private void setUpValueResolvers() throws MuleException {
        Map valueResolvers = (Map)Mockito.mock(Map.class);
        Mockito.when((Object)this.resolverSet.getResolvers()).thenReturn((Object)valueResolvers);
        ValueResolver valueResolver = (ValueResolver)Mockito.mock(ValueResolver.class);
        Mockito.when(valueResolvers.get(Matchers.eq((Object)SOME_PARAM_NAME))).thenReturn((Object)valueResolver);
        Mockito.when((Object)valueResolvers.containsKey(Matchers.eq((Object)SOME_PARAM_NAME))).thenReturn((Object)true);
        Mockito.when((Object)valueResolver.resolve((ValueResolvingContext)Matchers.any(ValueResolvingContext.class))).thenReturn((Object)"person");
    }
}

