/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.exception;

import java.util.Collections;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.exception.ErrorTypeRepository;
import org.mule.runtime.core.api.exception.TypedException;
import org.mule.runtime.core.internal.exception.ErrorTypeRepositoryFactory;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.module.extension.internal.runtime.exception.ModuleExceptionHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ModuleExceptionHandlerTestCase
extends AbstractMuleTestCase {
    private static final String ERROR_NAMESPACE = "TEST-EXTENSION";
    @Mock
    private OperationModel operationModel;
    @Mock
    private ExtensionModel extensionModel;
    private ErrorTypeRepository typeRepository = ErrorTypeRepositoryFactory.createDefaultErrorTypeRepository();

    @Before
    public void setUp() {
        Mockito.when((Object)this.extensionModel.getXmlDslModel()).thenReturn((Object)XmlDslModel.builder().setPrefix("test-extension").build());
        Mockito.when((Object)this.extensionModel.getName()).thenReturn((Object)"Test Extension");
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"testOperation");
    }

    @Test
    public void handleThrowingOfNotDeclaredErrorType() {
        Mockito.when((Object)this.operationModel.getErrorModels()).thenReturn(Collections.singleton(ErrorModelBuilder.newError((String)"TRANSFORMATION", (String)ERROR_NAMESPACE).build()));
        ModuleExceptionHandler handler = new ModuleExceptionHandler((ComponentModel)this.operationModel, this.extensionModel, this.typeRepository);
        ModuleException moduleException = new ModuleException((ErrorTypeDefinition)MuleErrors.CONNECTIVITY, (Throwable)new RuntimeException());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> handler.processException((Throwable)moduleException)).isInstanceOf(MuleRuntimeException.class)).hasMessage("The component 'testOperation' from the connector 'Test Extension' attempted to throw 'TEST-EXTENSION:CONNECTIVITY', but only [TEST-EXTENSION:TRANSFORMATION] errors are allowed.");
    }

    @Test
    public void handleThrowingOfNotRegisteredErrorType() {
        Mockito.when((Object)this.operationModel.getErrorModels()).thenReturn(Collections.singleton(ErrorModelBuilder.newError((String)"CONNECTIVITY", (String)ERROR_NAMESPACE).build()));
        ModuleExceptionHandler handler = new ModuleExceptionHandler((ComponentModel)this.operationModel, this.extensionModel, this.typeRepository);
        ModuleException moduleException = new ModuleException((ErrorTypeDefinition)MuleErrors.CONNECTIVITY, (Throwable)new RuntimeException());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> handler.processException((Throwable)moduleException)).isInstanceOf(MuleRuntimeException.class)).hasMessage("The component 'testOperation' from the connector 'Test Extension' attempted to throw 'TEST-EXTENSION:CONNECTIVITY', but it was not registered in the Error Repository");
    }

    @Test
    public void handleTypedException() {
        Mockito.when((Object)this.operationModel.getErrorModels()).thenReturn(Collections.singleton(ErrorModelBuilder.newError((String)"CONNECTIVITY", (String)ERROR_NAMESPACE).build()));
        ModuleExceptionHandler handler = new ModuleExceptionHandler((ComponentModel)this.operationModel, this.extensionModel, this.typeRepository);
        this.typeRepository.addErrorType(ComponentIdentifier.builder().name("CONNECTIVITY").namespace(ERROR_NAMESPACE).build(), this.typeRepository.getAnyErrorType());
        ModuleException moduleException = new ModuleException((ErrorTypeDefinition)MuleErrors.CONNECTIVITY, (Throwable)new RuntimeException());
        Throwable exception = handler.processException((Throwable)moduleException);
        MatcherAssert.assertThat((Object)exception, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(TypedException.class)));
        ErrorType errorType = ((TypedException)exception).getErrorType();
        MatcherAssert.assertThat((Object)errorType.getIdentifier(), (Matcher)CoreMatchers.is((Object)"CONNECTIVITY"));
        MatcherAssert.assertThat((Object)errorType.getNamespace(), (Matcher)CoreMatchers.is((Object)ERROR_NAMESPACE));
    }
}

