/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity;

import java.util.Optional;
import javax.transaction.TransactionManager;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.transaction.xa.XaTransaction;
import org.mule.runtime.extension.api.connectivity.XATransactionalConnection;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.transaction.XAExtensionTransactionalResource;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class ExtensionConnectionSupplierTestCase
extends AbstractMuleContextTestCase {
    private ExtensionConnectionSupplier adapter;

    protected void doSetUp() throws Exception {
        this.adapter = (ExtensionConnectionSupplier)muleContext.getRegistry().lookupObject(ExtensionConnectionSupplier.class);
    }

    protected void doTearDownAfterMuleContextDispose() throws Exception {
        Transaction transaction = TransactionCoordination.getInstance().getTransaction();
        if (transaction != null) {
            TransactionCoordination.getInstance().unbindTransaction(transaction);
        }
    }

    @Test
    public void xaTransaction() throws Exception {
        muleContext.setTransactionManager((TransactionManager)Mockito.mock(TransactionManager.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        XaTransaction transaction = (XaTransaction)Mockito.spy((Object)new XaTransaction(muleContext));
        XATransactionalConnection connection = (XATransactionalConnection)Mockito.mock(XATransactionalConnection.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Object config = new Object();
        ExecutionContextAdapter operationContext = (ExecutionContextAdapter)Mockito.mock(ExecutionContextAdapter.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        ConnectionProvider connectionProvider = (ConnectionProvider)Mockito.mock(ConnectionProvider.class);
        ConfigurationInstance configurationInstance = (ConfigurationInstance)Mockito.mock(ConfigurationInstance.class);
        Mockito.when((Object)configurationInstance.getConnectionProvider()).thenReturn(Optional.of(connectionProvider));
        Mockito.when((Object)operationContext.getConfiguration()).thenReturn(Optional.of(configurationInstance));
        Mockito.when((Object)configurationInstance.getValue()).thenReturn(config);
        Mockito.when((Object)connectionProvider.connect()).thenReturn((Object)connection);
        TransactionConfig transactionConfig = (TransactionConfig)Mockito.mock(TransactionConfig.class);
        Mockito.when((Object)transactionConfig.getAction()).thenReturn((Object)3);
        Mockito.when((Object)transactionConfig.isTransacted()).thenReturn((Object)true);
        Mockito.when((Object)operationContext.getTransactionConfig()).thenReturn(Optional.of(transactionConfig));
        ((ConnectionManager)muleContext.getRegistry().lookupObject(ConnectionManager.class)).bind(config, connectionProvider);
        TransactionCoordination.getInstance().bindTransaction((Transaction)transaction);
        this.adapter.getConnection(operationContext);
        ((XaTransaction)Mockito.verify((Object)transaction)).bindResource(Matchers.any(), Matchers.any(XAExtensionTransactionalResource.class));
    }
}

