/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.manager;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.ExtensionModelTestUtils;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.registry.MuleRegistry;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.metadata.MuleMetadataService;
import org.mule.runtime.core.internal.transformer.simple.StringToEnum;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.connectivity.ConnectionProviderFactory;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ComponentExecutorFactory;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectionProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.manager.DefaultExtensionManager;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.util.MuleContextUtils;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class DefaultExtensionManagerTestCase
extends AbstractMuleTestCase {
    private static final String MULESOFT = "MuleSoft";
    private static final String OTHER_VENDOR = "OtherVendor";
    private static final XmlDslModel XML_DSL_MODEL = XmlDslModel.builder().setPrefix("extension-prefix").build();
    private ExtensionManager extensionsManager;
    private static final String EXTENSION1_NAME = "extension1";
    private static final String EXTENSION1_CONFIG_NAME = "extension1Config";
    private static final String EXTENSION1_CONFIG_INSTANCE_NAME = "extension1ConfigInstanceName";
    private static final String EXTENSION1_OPERATION_NAME = "extension1OperationName";
    private static final String EXTENSION2_NAME = "extension2";
    private static final String EXTENSION1_VERSION = "3.6.0";
    private static final String EXTENSION2_VERSION = "3.6.0";
    @Mock
    private ExtensionModel extensionModel1;
    @Mock
    private ExtensionModel extensionModel2;
    @Mock
    private ExtensionModel extensionModel3WithRepeatedName;
    private MuleContext muleContext = MuleContextUtils.mockContextWithServices();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ConfigurationModel extension1ConfigurationModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ConnectionProviderModel connectionProviderModel;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ConnectionManagerAdapter connectionManagerAdapter;
    @Mock
    private OperationModel extension1OperationModel;
    @Mock
    private ExecutionContextAdapter extension1OperationContext;
    @Mock
    private ConfigurationProvider extension1ConfigurationProvider;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ConfigurationInstance extension1ConfigurationInstance = (ConfigurationInstance)Mockito.mock(ConfigurationInstance.class);
    @Mock
    private ComponentExecutorFactory executorFactory;
    @Mock
    private ComponentExecutor executor;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private InternalEvent event;
    private ClassLoader classLoader;
    private final Object configInstance = new Object();

    @Before
    public void before() throws InitialisationException, RegistrationException {
        DefaultExtensionManager extensionsManager = new DefaultExtensionManager();
        extensionsManager.setMuleContext(this.muleContext);
        extensionsManager.initialise();
        this.extensionsManager = extensionsManager;
        ExtensionsTestUtils.mockClassLoaderModelProperty(this.extensionModel1, ((Object)((Object)this)).getClass().getClassLoader());
        ExtensionsTestUtils.mockClassLoaderModelProperty(this.extensionModel2, ((Object)((Object)this)).getClass().getClassLoader());
        ExtensionsTestUtils.mockClassLoaderModelProperty(this.extensionModel3WithRepeatedName, ((Object)((Object)this)).getClass().getClassLoader());
        Mockito.when((Object)this.extensionModel1.getName()).thenReturn((Object)EXTENSION1_NAME);
        ExtensionsTestUtils.mockClassLoaderModelProperty(this.extensionModel1, ((Object)((Object)this)).getClass().getClassLoader());
        Mockito.when((Object)this.extensionModel1.getXmlDslModel()).thenReturn((Object)XML_DSL_MODEL);
        Mockito.when((Object)this.extensionModel2.getXmlDslModel()).thenReturn((Object)XML_DSL_MODEL);
        Mockito.when((Object)this.extensionModel1.getConfigurationModels()).thenReturn(Arrays.asList(this.extension1ConfigurationModel));
        Mockito.when((Object)this.extensionModel2.getName()).thenReturn((Object)EXTENSION2_NAME);
        Mockito.when((Object)this.extensionModel3WithRepeatedName.getName()).thenReturn((Object)EXTENSION2_NAME);
        Mockito.when((Object)this.extensionModel1.getVendor()).thenReturn((Object)MULESOFT);
        Mockito.when((Object)this.extensionModel2.getVendor()).thenReturn((Object)MULESOFT);
        Mockito.when((Object)this.extensionModel3WithRepeatedName.getVendor()).thenReturn((Object)OTHER_VENDOR);
        Mockito.when((Object)this.extensionModel1.getVersion()).thenReturn((Object)"3.6.0");
        Mockito.when((Object)this.extensionModel2.getVersion()).thenReturn((Object)"3.6.0");
        ExtensionsTestUtils.mockClassLoaderModelProperty(this.extensionModel1, ((Object)((Object)this)).getClass().getClassLoader());
        Mockito.when((Object)this.extensionModel3WithRepeatedName.getVersion()).thenReturn((Object)"3.6.0");
        Mockito.when((Object)this.extension1ConfigurationModel.getName()).thenReturn((Object)EXTENSION1_CONFIG_NAME);
        ExtensionsTestUtils.mockConfigurationInstance(this.extension1ConfigurationModel, this.configInstance);
        ExtensionsTestUtils.mockInterceptors((EnrichableModel)this.extension1ConfigurationModel, null);
        Mockito.when((Object)this.extension1ConfigurationModel.getOperationModels()).thenReturn((Object)ImmutableList.of((Object)this.extension1OperationModel));
        Mockito.when((Object)this.extension1ConfigurationModel.getSourceModels()).thenReturn((Object)ImmutableList.of());
        Mockito.when((Object)this.extension1ConfigurationModel.getConnectionProviders()).thenReturn(Arrays.asList(this.connectionProviderModel));
        Mockito.when((Object)this.connectionProviderModel.getAllParameterModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.connectionProviderModel.getModelProperty(ConnectionProviderFactoryModelProperty.class)).thenReturn(Optional.of(new ConnectionProviderFactoryModelProperty((ConnectionProviderFactory)Mockito.mock(ConnectionProviderFactory.class))));
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.extension1ConfigurationModel, new ParameterModel[0]);
        ExtensionsTestUtils.mockConfigurationInstance(this.extension1ConfigurationModel, this.configInstance);
        Mockito.when((Object)this.extensionModel1.getConfigurationModel(EXTENSION1_CONFIG_NAME)).thenReturn(Optional.of(this.extension1ConfigurationModel));
        Mockito.when((Object)this.extensionModel1.getOperationModel(EXTENSION1_OPERATION_NAME)).thenReturn(Optional.of(this.extension1OperationModel));
        Mockito.when((Object)this.extension1OperationModel.getName()).thenReturn((Object)EXTENSION1_OPERATION_NAME);
        Mockito.when((Object)this.extensionModel1.getFunctionModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.extensionModel1.getConstructModels()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.extension1ConfigurationInstance.getValue()).thenReturn(this.configInstance);
        Mockito.when((Object)this.extension1ConfigurationInstance.getModel()).thenReturn((Object)this.extension1ConfigurationModel);
        Mockito.when((Object)this.extension1ConfigurationInstance.getName()).thenReturn((Object)EXTENSION1_CONFIG_INSTANCE_NAME);
        Mockito.when((Object)this.extension1ConfigurationProvider.get((Object)this.event)).thenReturn((Object)this.extension1ConfigurationInstance);
        Mockito.when((Object)this.extension1ConfigurationProvider.getConfigurationModel()).thenReturn((Object)this.extension1ConfigurationModel);
        Mockito.when((Object)this.extension1ConfigurationProvider.getExtensionModel()).thenReturn((Object)this.extensionModel1);
        Mockito.when((Object)this.extension1ConfigurationProvider.getName()).thenReturn((Object)EXTENSION1_CONFIG_INSTANCE_NAME);
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.extension1OperationModel});
        ExtensionsTestUtils.mockExecutorFactory(this.extension1OperationModel, this.executorFactory);
        Mockito.when((Object)this.executorFactory.createExecutor((ComponentModel)this.extension1OperationModel)).thenReturn((Object)this.executor);
        this.classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        this.registerExtensions(this.extensionModel1, this.extensionModel2, this.extensionModel3WithRepeatedName);
        ExtensionsTestUtils.stubRegistryKeys(this.muleContext, EXTENSION1_CONFIG_INSTANCE_NAME, EXTENSION1_OPERATION_NAME, EXTENSION1_NAME);
        ConnectionManagerAdapter connectionManagerAdapter = (ConnectionManagerAdapter)Mockito.mock(ConnectionManagerAdapter.class);
        Mockito.when((Object)this.muleContext.getRegistry().lookupObject("_muleConnectionManager")).thenReturn((Object)connectionManagerAdapter);
        Mockito.when((Object)this.muleContext.getRegistry().lookupObject(MuleMetadataService.class)).thenReturn(Mockito.mock(MuleMetadataService.class));
        Mockito.when((Object)this.muleContext.getRegistry().get("_muleConnectionManager")).thenReturn((Object)connectionManagerAdapter);
    }

    private void registerExtensions(ExtensionModel ... extensionModels) {
        Arrays.stream(extensionModels).forEach(extension -> {
            Mockito.when((Object)extension.getModelProperty(ClassLoaderModelProperty.class)).thenReturn(Optional.empty());
            this.extensionsManager.registerExtension(extension);
        });
    }

    @Test
    public void getExtensions() {
        this.testEquals(Arrays.asList(this.extensionModel1, this.extensionModel2), this.extensionsManager.getExtensions());
    }

    @Test
    public void getExtensionsByName() {
        Optional extension = this.extensionsManager.getExtension(EXTENSION1_NAME);
        Assert.assertThat((Object)extension.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat(extension.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.extensionModel1)));
    }

    @Test
    public void contextClassLoaderKept() {
        Assert.assertThat((Object)this.classLoader, (Matcher)CoreMatchers.sameInstance((Object)Thread.currentThread().getContextClassLoader()));
    }

    @Test
    public void contextClassLoaderKeptAfterException() {
        ExtensionModel extensionModel = (ExtensionModel)Mockito.mock(ExtensionModel.class);
        Mockito.when((Object)extensionModel.getName()).thenThrow(new Throwable[]{new RuntimeException()});
        try {
            this.extensionsManager.registerExtension(extensionModel);
            Assert.fail((String)"was expecting an exception");
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)this.classLoader, (Matcher)CoreMatchers.sameInstance((Object)Thread.currentThread().getContextClassLoader()));
        }
    }

    @Test
    public void getConfigurationByName() throws Exception {
        this.registerConfigurationProvider();
        ConfigurationInstance configurationInstance = this.extensionsManager.getConfiguration(EXTENSION1_CONFIG_INSTANCE_NAME, this.event);
        Assert.assertThat((Object)configurationInstance.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.configInstance)));
    }

    @Test
    public void getConfigurationThroughImplicitConfiguration() throws Exception {
        Mockito.when((Object)this.muleContext.getRegistry().get(MuleExtensionUtils.getImplicitConfigurationProviderName((ExtensionModel)this.extensionModel1, (ConfigurationModel)this.extension1ConfigurationModel))).thenReturn((Object)this.extension1ConfigurationProvider);
        Mockito.when((Object)this.extension1ConfigurationModel.getModelProperty(ParameterGroupModelProperty.class)).thenReturn(Optional.empty());
        this.registerConfigurationProvider();
        Optional configInstance = this.extensionsManager.getConfiguration(this.extensionModel1, (ComponentModel)this.extension1OperationModel, this.event);
        Assert.assertThat((Object)configInstance.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((ConfigurationInstance)configInstance.get()).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.configInstance)));
    }

    @Test
    public void getOperationExecutorThroughImplicitConfigurationConcurrently() throws Exception {
        int threadCount = 2;
        CountDownLatch joinerLatch = new CountDownLatch(2);
        MuleRegistry registry = this.muleContext.getRegistry();
        Mockito.when((Object)this.extension1ConfigurationModel.getModelProperty(ParameterGroupModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)registry.lookupObjects(ConfigurationProvider.class)).thenReturn(Collections.emptyList());
        ((MuleRegistry)Mockito.doAnswer(invocation -> {
            Mockito.when((Object)registry.get(MuleExtensionUtils.getImplicitConfigurationProviderName((ExtensionModel)this.extensionModel1, (ConfigurationModel)this.extension1ConfigurationModel))).thenReturn((Object)this.extension1ConfigurationProvider);
            new Thread(() -> this.extensionsManager.getConfiguration(this.extensionModel1, (ComponentModel)this.extension1OperationModel, this.event)).start();
            joinerLatch.countDown();
            return null;
        }).when((Object)registry)).registerObject(Matchers.anyString(), Matchers.anyObject());
        Optional configurationInstance = this.extensionsManager.getConfiguration(this.extensionModel1, (ComponentModel)this.extension1OperationModel, this.event);
        joinerLatch.countDown();
        Assert.assertThat((Object)configurationInstance.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)joinerLatch.await(5L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((ConfigurationInstance)configurationInstance.get()).getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)this.configInstance)));
    }

    @Test(expected=IllegalStateException.class)
    public void getOperationExecutorWithNotImplicitConfig() {
        Mockito.when((Object)this.muleContext.getRegistry().lookupObjects(ConfigurationProvider.class)).thenReturn(Collections.emptyList());
        this.makeExtension1ConfigurationNotImplicit();
        this.extensionsManager.getConfiguration(this.extensionModel1, (ComponentModel)this.extension1OperationModel, this.event);
    }

    @Test
    public void registerTwoExtensionsWithTheSameNameButDifferentVendor() {
        this.registerExtensions(this.extensionModel2, this.extensionModel3WithRepeatedName);
        ArrayList extensionModels = new ArrayList(this.extensionsManager.getExtensions());
        List extensionNameList = extensionModels.stream().map(ExtensionModel::getName).distinct().collect(Collectors.toList());
        List extensionVendorList = extensionModels.stream().map(ExtensionModel::getVendor).distinct().collect(Collectors.toList());
        Assert.assertThat((Object)extensionModels.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)extensionNameList.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)extensionVendorList.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void ignoresRegisteringAlreadyRegisteredExtensions() {
        int registeredExtensionsCount = this.extensionsManager.getExtensions().size();
        this.registerExtensions(this.extensionModel1, this.extensionModel1, this.extensionModel1);
        Assert.assertThat((Object)this.extensionsManager.getExtensions(), (Matcher)org.hamcrest.Matchers.hasSize((int)registeredExtensionsCount));
    }

    @Test
    public void enumTransformer() throws Exception {
        DefaultExtensionManager extensionsManager = new DefaultExtensionManager();
        extensionsManager.setMuleContext(this.muleContext);
        extensionsManager.initialise();
        ParameterModel parameter = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameter.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(TimeUnit.class));
        ParameterModel parameterOfRepeatedEnumType = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterOfRepeatedEnumType.getType()).thenReturn((Object)ExtensionsTestUtils.toMetadataType(TimeUnit.class));
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.extension1ConfigurationModel, parameter, parameterOfRepeatedEnumType);
        extensionsManager.registerExtension(this.extensionModel1);
        ((MuleRegistry)Mockito.verify((Object)this.muleContext.getRegistry())).registerTransformer((Transformer)Matchers.any(StringToEnum.class));
    }

    @Test
    public void enumCollectionTransformer() throws Exception {
        DefaultExtensionManager extensionsManager = new DefaultExtensionManager();
        extensionsManager.setMuleContext(this.muleContext);
        extensionsManager.initialise();
        ParameterModel parameter = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameter.getType()).thenReturn((Object)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).arrayType().of(ExtensionsTestUtils.toMetadataType(TimeUnit.class)).build());
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.extension1ConfigurationModel, parameter);
        extensionsManager.registerExtension(this.extensionModel1);
        ((MuleRegistry)Mockito.verify((Object)this.muleContext.getRegistry())).registerTransformer((Transformer)Matchers.any(StringToEnum.class));
    }

    private void makeExtension1ConfigurationNotImplicit() {
        ParameterModel parameterModel1 = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel1.isRequired()).thenReturn((Object)true);
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.extension1ConfigurationModel, parameterModel1, parameterModel1);
        ExtensionsTestUtils.mockConfigurationInstance(this.extension1ConfigurationModel, this.configInstance);
    }

    private void testEquals(Collection<ExtensionModel> expected, Collection<ExtensionModel> obtained) {
        Assert.assertThat((Object)obtained.size(), (Matcher)CoreMatchers.is((Object)expected.size()));
        Iterator<ExtensionModel> expectedIterator = expected.iterator();
        Iterator<ExtensionModel> obtainedIterator = expected.iterator();
        while (expectedIterator.hasNext()) {
            Assert.assertThat((Object)obtainedIterator.hasNext(), (Matcher)CoreMatchers.is((Object)true));
            this.testEquals(expectedIterator.next(), obtainedIterator.next());
        }
    }

    private void testEquals(ExtensionModel expected, ExtensionModel obtained) {
        Assert.assertThat((Object)obtained.getName(), (Matcher)CoreMatchers.equalTo((Object)expected.getName()));
        Assert.assertThat((Object)obtained.getVersion(), (Matcher)CoreMatchers.equalTo((Object)expected.getVersion()));
    }

    private void registerConfigurationProvider() throws RegistrationException {
        this.extensionsManager.registerConfigurationProvider(this.extension1ConfigurationProvider);
        ((MuleRegistry)Mockito.verify((Object)this.muleContext.getRegistry())).registerObject(this.extension1ConfigurationProvider.getName(), (Object)this.extension1ConfigurationProvider);
        Mockito.when((Object)this.muleContext.getRegistry().lookupObjects(ConfigurationProvider.class)).thenReturn(Arrays.asList(this.extension1ConfigurationProvider));
        Mockito.when((Object)this.muleContext.getRegistry().get(this.extension1ConfigurationProvider.getName())).thenReturn((Object)this.extension1ConfigurationProvider);
    }
}

