/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.loader.validation.ParameterGroupModelValidator;
import org.mule.tck.size.SmallTest;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ParameterGroupModelValidatorTestCase {
    @Mock
    private ExtensionModel extensionModel;
    @Mock
    private OperationModel operationModel;
    @Mock
    private ParameterGroupModel groupModel;
    @Mock
    private ParameterModel parameterModel;
    private ParameterGroupModelValidator validator = new ParameterGroupModelValidator();

    @Before
    public void before() {
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.operationModel.getParameterGroupModels()).thenReturn(Arrays.asList(this.groupModel));
        Mockito.when((Object)this.groupModel.getParameterModels()).thenReturn(Arrays.asList(this.parameterModel));
    }

    @Test(expected=IllegalModelDefinitionException.class)
    public void invalidModelDueToNonInstantiableParameterGroup() {
        ParameterGroupDescriptor descriptor = new ParameterGroupDescriptor("name", (Type)new TypeWrapper(Serializable.class), null, (AnnotatedElement)Mockito.mock(AnnotatedElement.class));
        Mockito.when((Object)this.groupModel.getModelProperty(ParameterGroupModelProperty.class)).thenReturn(Optional.of(new ParameterGroupModelProperty(descriptor)));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }
}

