/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.collections.map.HashedMap;
import org.hamcrest.core.StringContains;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.AttributesTypeResolver;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.api.util.ExtensionModelTestUtils;
import org.mule.runtime.core.internal.metadata.DefaultMetadataResolverFactory;
import org.mule.runtime.core.internal.metadata.NullMetadataResolverSupplier;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyPart;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.metadata.NullMetadataResolver;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;
import org.mule.runtime.extension.internal.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.internal.property.MetadataKeyPartModelProperty;
import org.mule.runtime.module.extension.internal.loader.validation.MetadataComponentModelValidator;
import org.mule.runtime.module.extension.internal.metadata.ResolverSupplier;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class MetadataComponentModelValidatorTestCase
extends AbstractMuleTestCase {
    public static final ClassTypeLoader loader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    public static final String EMPTY = "";
    private static final Supplier<NullMetadataResolver> NULL_RESOLVER_SUPPLIER = new NullMetadataResolverSupplier();
    private static final Supplier<MockResolver> MOCK_RESOLVER_SUPPLIER = ResolverSupplier.of(MockResolver.class);
    private static final Supplier<SimpleOutputResolver> SIMPLE_OUTPUT_RESOLVER = ResolverSupplier.of(SimpleOutputResolver.class);
    public static final String PARAMETER_NAME = "parameterName";
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private ExtensionModel extensionModel;
    @Mock
    private OperationModel operationModel;
    @Mock
    private SourceModel sourceModel;
    @Mock
    private SourceCallbackModel sourceCallbackModel;
    private BaseTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
    private ObjectType dictionaryType;
    private ArrayType arrayType;
    private MetadataComponentModelValidator validator = new MetadataComponentModelValidator();

    @Before
    public void before() {
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(this.operationModel));
        Mockito.when((Object)this.extensionModel.getSourceModels()).thenReturn(Arrays.asList(this.sourceModel));
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)new ImmutableOutputModel(EMPTY, ExtensionsTestUtils.toMetadataType(String.class), false, Collections.emptySet()));
        Mockito.when((Object)this.operationModel.getOutputAttributes()).thenReturn((Object)new ImmutableOutputModel(EMPTY, (MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).voidType().build(), false, Collections.emptySet()));
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"operation");
        ExtensionsTestUtils.mockMetadataResolverFactory((EnrichableModel)this.operationModel, null);
        Mockito.when((Object)this.sourceModel.getOutput()).thenReturn((Object)new ImmutableOutputModel(EMPTY, ExtensionsTestUtils.toMetadataType(String.class), false, Collections.emptySet()));
        Mockito.when((Object)this.sourceModel.getOutputAttributes()).thenReturn((Object)new ImmutableOutputModel(EMPTY, (MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).voidType().build(), false, Collections.emptySet()));
        Mockito.when((Object)this.sourceModel.getName()).thenReturn((Object)"source");
        Mockito.when((Object)this.sourceModel.getSuccessCallback()).thenReturn(Optional.of(this.sourceCallbackModel));
        Mockito.when((Object)this.sourceModel.getErrorCallback()).thenReturn(Optional.of(this.sourceCallbackModel));
        ExtensionsTestUtils.mockMetadataResolverFactory((EnrichableModel)this.sourceModel, null);
        MetadataKeyIdModelProperty keyIdModelProperty = new MetadataKeyIdModelProperty(loader.load(InvalidMetadataKeyIdPojo.class), EMPTY);
        Mockito.when((Object)this.sourceModel.getModelProperty(MetadataKeyIdModelProperty.class)).thenReturn(Optional.of(keyIdModelProperty));
        Mockito.when((Object)this.operationModel.getModelProperty(MetadataKeyIdModelProperty.class)).thenReturn(Optional.empty());
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{this.operationModel, this.sourceModel});
        this.dictionaryType = this.typeBuilder.objectType().openWith(ExtensionsTestUtils.toMetadataType(Object.class)).build();
    }

    @Test
    public void valid() {
        ExtensionsTestUtils.mockMetadataResolverFactory((EnrichableModel)this.sourceModel, (MetadataResolverFactory)new DefaultMetadataResolverFactory(MOCK_RESOLVER_SUPPLIER, Collections.emptyMap(), MOCK_RESOLVER_SUPPLIER, NULL_RESOLVER_SUPPLIER));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void operationWithAttributeResolverButNoAttributes() {
        this.exception.expect(IllegalModelDefinitionException.class);
        Mockito.when((Object)this.extensionModel.getSourceModels()).thenReturn(Collections.emptyList());
        ExtensionsTestUtils.mockMetadataResolverFactory((EnrichableModel)this.operationModel, (MetadataResolverFactory)new DefaultMetadataResolverFactory(NULL_RESOLVER_SUPPLIER, Collections.emptyMap(), SIMPLE_OUTPUT_RESOLVER, SIMPLE_OUTPUT_RESOLVER));
        Mockito.when((Object)this.operationModel.getModelProperty(MetadataKeyIdModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)new ImmutableOutputModel(EMPTY, ExtensionsTestUtils.toMetadataType(Object.class), false, Collections.emptySet()));
        Mockito.when((Object)this.operationModel.getOutputAttributes()).thenReturn((Object)new ImmutableOutputModel(EMPTY, ExtensionsTestUtils.toMetadataType(Void.TYPE), false, Collections.emptySet()));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void operationReturnsObjectType() {
        this.exception.expect(IllegalModelDefinitionException.class);
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)new ImmutableOutputModel(EMPTY, ExtensionsTestUtils.toMetadataType(Object.class), false, Collections.emptySet()));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void operationReturnsDictionaryTypeWithObjectTypeValue() {
        this.exception.expect(IllegalModelDefinitionException.class);
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)new ImmutableOutputModel(EMPTY, (MetadataType)this.dictionaryType, false, Collections.emptySet()));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void operationReturnsDictionaryTypeWithPojoValue() {
        this.dictionaryType = this.typeBuilder.objectType().openWith(ExtensionsTestUtils.toMetadataType(Apple.class)).build();
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)new ImmutableOutputModel(EMPTY, (MetadataType)this.dictionaryType, false, Collections.emptySet()));
        ExtensionsTestUtils.mockMetadataResolverFactory((EnrichableModel)this.sourceModel, (MetadataResolverFactory)new DefaultMetadataResolverFactory(MOCK_RESOLVER_SUPPLIER, Collections.emptyMap(), MOCK_RESOLVER_SUPPLIER, NULL_RESOLVER_SUPPLIER));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void sourceReturnsObjectType() {
        this.exception.expect(IllegalModelDefinitionException.class);
        Mockito.when((Object)this.sourceModel.getOutput()).thenReturn((Object)new ImmutableOutputModel(EMPTY, ExtensionsTestUtils.toMetadataType(Object.class), false, Collections.emptySet()));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void sourceReturnsDictionaryType() {
        this.exception.expect(IllegalModelDefinitionException.class);
        Mockito.when((Object)this.sourceModel.getOutput()).thenReturn((Object)new ImmutableOutputModel(EMPTY, (MetadataType)this.dictionaryType, false, Collections.emptySet()));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void sourceReturnsPojoType() {
        ExtensionsTestUtils.mockMetadataResolverFactory((EnrichableModel)this.sourceModel, (MetadataResolverFactory)new DefaultMetadataResolverFactory(MOCK_RESOLVER_SUPPLIER, Collections.emptyMap(), MOCK_RESOLVER_SUPPLIER, NULL_RESOLVER_SUPPLIER));
        Mockito.when((Object)this.sourceModel.getOutput()).thenReturn((Object)new ImmutableOutputModel(EMPTY, ExtensionsTestUtils.toMetadataType(Apple.class), false, Collections.emptySet()));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void sourceReturnsObjectTypeWithDefinedOutputResolver() {
        Mockito.when((Object)this.sourceModel.getOutput()).thenReturn((Object)new ImmutableOutputModel(EMPTY, ExtensionsTestUtils.toMetadataType(Object.class), false, Collections.emptySet()));
        ExtensionsTestUtils.mockMetadataResolverFactory((EnrichableModel)this.sourceModel, (MetadataResolverFactory)new DefaultMetadataResolverFactory(NULL_RESOLVER_SUPPLIER, Collections.emptyMap(), SIMPLE_OUTPUT_RESOLVER, NULL_RESOLVER_SUPPLIER));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void sourceReturnsDictionaryTypeWithDefinedOutputResolver() {
        Mockito.when((Object)this.sourceModel.getOutput()).thenReturn((Object)new ImmutableOutputModel(EMPTY, (MetadataType)this.dictionaryType, false, Collections.emptySet()));
        ExtensionsTestUtils.mockMetadataResolverFactory((EnrichableModel)this.sourceModel, (MetadataResolverFactory)new DefaultMetadataResolverFactory(NULL_RESOLVER_SUPPLIER, Collections.emptyMap(), SIMPLE_OUTPUT_RESOLVER, NULL_RESOLVER_SUPPLIER));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void sourceReturnsArrayTypeOfObjectWithoutDefinedOutputResolver() {
        this.arrayType = this.typeBuilder.arrayType().of(ExtensionsTestUtils.toMetadataType(Object.class)).build();
        this.exception.expect(IllegalModelDefinitionException.class);
        Mockito.when((Object)this.sourceModel.getOutput()).thenReturn((Object)new ImmutableOutputModel(EMPTY, (MetadataType)this.arrayType, false, Collections.emptySet()));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void sourceReturnsArrayTypeOfDictionaryWithObjectValue() {
        this.arrayType = this.typeBuilder.arrayType().of((MetadataType)this.dictionaryType).build();
        this.exception.expect(IllegalModelDefinitionException.class);
        Mockito.when((Object)this.sourceModel.getOutput()).thenReturn((Object)new ImmutableOutputModel(EMPTY, (MetadataType)this.arrayType, false, Collections.emptySet()));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void metadataResolverWithDifferentCategories() {
        this.exception.expect(IllegalModelDefinitionException.class);
        this.exception.expectMessage(StringContains.containsString((String)"specifies metadata resolvers that doesn't belong to the same category"));
        ExtensionsTestUtils.mockMetadataResolverFactory((EnrichableModel)this.sourceModel, (MetadataResolverFactory)new DefaultMetadataResolverFactory(ResolverSupplier.of(DifferentCategoryResolver.class), Collections.emptyMap(), SIMPLE_OUTPUT_RESOLVER, NULL_RESOLVER_SUPPLIER));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void metadataResolverWithEmptyCategoryName() {
        this.exception.expect(IllegalModelDefinitionException.class);
        this.exception.expectMessage(StringContains.containsString((String)"which has an empty category name"));
        ExtensionsTestUtils.mockMetadataResolverFactory((EnrichableModel)this.sourceModel, (MetadataResolverFactory)new DefaultMetadataResolverFactory(ResolverSupplier.of(EmptyCategoryName.class), Collections.emptyMap(), SIMPLE_OUTPUT_RESOLVER, NULL_RESOLVER_SUPPLIER));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void metadataResolverWithEmptyResolverName() {
        this.exception.expect(IllegalModelDefinitionException.class);
        this.exception.expectMessage(StringContains.containsString((String)"which has an empty resolver name"));
        ExtensionsTestUtils.mockMetadataResolverFactory((EnrichableModel)this.sourceModel, (MetadataResolverFactory)new DefaultMetadataResolverFactory(NULL_RESOLVER_SUPPLIER, Collections.emptyMap(), ResolverSupplier.of(EmptyResolverName.class), NULL_RESOLVER_SUPPLIER));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void metadataResolverWithRepeatedResolverName() {
        this.exception.expect(IllegalModelDefinitionException.class);
        this.exception.expectMessage(StringContains.containsString((String)"Resolver names should be unique for a given category"));
        HashedMap inputResolvers = new HashedMap();
        ParameterModel parameterModel = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)parameterModel.getName()).thenReturn((Object)PARAMETER_NAME);
        Mockito.when((Object)parameterModel.getModelProperty(MetadataKeyIdModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceModel.getModelProperty(MetadataKeyIdModelProperty.class)).thenReturn(Optional.empty());
        ExtensionsTestUtils.mockParameters((ParameterizedModel)this.sourceModel, parameterModel);
        inputResolvers.put(PARAMETER_NAME, ResolverSupplier.of(SimpleInputResolver.class));
        ExtensionsTestUtils.mockMetadataResolverFactory((EnrichableModel)this.sourceModel, (MetadataResolverFactory)new DefaultMetadataResolverFactory(NULL_RESOLVER_SUPPLIER, (Map)inputResolvers, SIMPLE_OUTPUT_RESOLVER, NULL_RESOLVER_SUPPLIER));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void metadataKeyMissingDefaultValues() {
        this.exception.expect(IllegalModelDefinitionException.class);
        this.exception.expectMessage("defines [1] MetadataKeyPart with default values, but the type contains [2]");
        ParameterModel param1 = this.getMockKeyPartParam(null, 1);
        ParameterModel param2 = this.getMockKeyPartParam("SomeValue", 2);
        Mockito.when((Object)this.sourceModel.getAllParameterModels()).thenReturn(Arrays.asList(param1, param2));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void metadataKeyWithValidDefaultValues() {
        ParameterModel param1 = this.getMockKeyPartParam("Value", 1);
        ParameterModel param2 = this.getMockKeyPartParam("SomeValue", 2);
        MetadataKeyIdModelProperty keyIdModelProperty = new MetadataKeyIdModelProperty(loader.load(InvalidMetadataKeyIdPojo.class), EMPTY);
        Mockito.when((Object)this.sourceModel.getModelProperty(MetadataKeyIdModelProperty.class)).thenReturn(Optional.of(keyIdModelProperty));
        Mockito.when((Object)this.sourceModel.getAllParameterModels()).thenReturn(Arrays.asList(param1, param2));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void metadataKeyWithoutDefaultValues() {
        ParameterModel param1 = this.getMockKeyPartParam(null, 1);
        ParameterModel param2 = this.getMockKeyPartParam(null, 2);
        MetadataKeyIdModelProperty keyIdModelProperty = new MetadataKeyIdModelProperty(loader.load(InvalidMetadataKeyIdPojo.class), EMPTY);
        Mockito.when((Object)this.sourceModel.getModelProperty(MetadataKeyIdModelProperty.class)).thenReturn(Optional.of(keyIdModelProperty));
        Mockito.when((Object)this.sourceModel.getAllParameterModels()).thenReturn(Arrays.asList(param1, param2));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void noMetadataKey() {
        ParameterModel param = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)this.sourceModel.getModelProperty(MetadataKeyIdModelProperty.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.sourceModel.getAllParameterModels()).thenReturn(Collections.singletonList(param));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    @Test
    public void stringMetadataKeyWithDefaultValue() {
        ParameterModel param = this.getMockKeyPartParam("default", 1);
        MetadataKeyIdModelProperty keyIdModelProperty = new MetadataKeyIdModelProperty(loader.load(String.class), EMPTY);
        Mockito.when((Object)this.sourceModel.getModelProperty(MetadataKeyIdModelProperty.class)).thenReturn(Optional.of(keyIdModelProperty));
        Mockito.when((Object)this.sourceModel.getAllParameterModels()).thenReturn(Collections.singletonList(param));
        ExtensionsTestUtils.validate(this.extensionModel, (ExtensionModelValidator)this.validator);
    }

    private ParameterModel getMockKeyPartParam(Object defaultValue, int order) {
        ParameterModel param = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)param.getDefaultValue()).thenReturn(defaultValue);
        Mockito.when((Object)param.getModelProperty(MetadataKeyPartModelProperty.class)).thenReturn(Optional.of(new MetadataKeyPartModelProperty(order)));
        return param;
    }

    public static class MockResolver
    implements TypeKeysResolver,
    OutputTypeResolver {
        public MetadataType getOutputType(MetadataContext context, Object key) throws MetadataResolvingException, ConnectionException {
            return null;
        }

        public String getCategoryName() {
            return "MockResolver";
        }

        public String getResolverName() {
            return "MockResolver";
        }

        public Set<MetadataKey> getKeys(MetadataContext context) throws MetadataResolvingException, ConnectionException {
            return null;
        }
    }

    public class ValidMetadataKeyIdPojo {
        @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="SomeValue")
        @MetadataKeyPart(order=1)
        @Parameter
        private String partOne;
        @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="AnotherValue")
        @MetadataKeyPart(order=2)
        @Parameter
        private String partTwo;
    }

    public class InvalidMetadataKeyIdPojo {
        @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="SomeValue")
        @MetadataKeyPart(order=1)
        @Parameter
        private String partOne;
        @MetadataKeyPart(order=2)
        @Parameter
        private String partTwo;
    }

    public static class EmptyResolverName
    implements TypeKeysResolver,
    OutputTypeResolver {
        public Set<MetadataKey> getKeys(MetadataContext context) throws MetadataResolvingException, ConnectionException {
            return Collections.emptySet();
        }

        public String getCategoryName() {
            return "SimpleOutputResolver";
        }

        public String getResolverName() {
            return null;
        }

        public MetadataType getOutputType(MetadataContext context, Object key) throws MetadataResolvingException, ConnectionException {
            return null;
        }
    }

    public static class EmptyCategoryName
    implements TypeKeysResolver {
        public Set<MetadataKey> getKeys(MetadataContext context) throws MetadataResolvingException, ConnectionException {
            return Collections.emptySet();
        }

        public String getCategoryName() {
            return null;
        }

        public String getResolverName() {
            return "EmptyCategoryName";
        }
    }

    public static class DifferentCategoryResolver
    implements TypeKeysResolver {
        public Set<MetadataKey> getKeys(MetadataContext context) throws MetadataResolvingException, ConnectionException {
            return Collections.emptySet();
        }

        public String getCategoryName() {
            return "NotSimpleOutputResolver";
        }

        public String getResolverName() {
            return "DifferentCategoryResolver";
        }
    }

    public static class SimpleInputResolver
    implements InputTypeResolver<String> {
        public MetadataType getInputMetadata(MetadataContext context, String key) throws MetadataResolvingException, ConnectionException {
            return null;
        }

        public String getCategoryName() {
            return "SimpleOutputResolver";
        }

        public String getResolverName() {
            return "SimpleOutputResolver";
        }
    }

    public static class SimpleOutputResolver
    implements OutputTypeResolver<String>,
    AttributesTypeResolver<String> {
        public String getResolverName() {
            return "SimpleOutputResolver";
        }

        public MetadataType getOutputType(MetadataContext context, String key) throws MetadataResolvingException, ConnectionException {
            return null;
        }

        public MetadataType getAttributesType(MetadataContext context, String key) throws MetadataResolvingException, ConnectionException {
            return null;
        }

        public String getCategoryName() {
            return "SimpleOutputResolver";
        }
    }
}

