/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.error.ErrorTypeProvider;
import org.mule.runtime.extension.api.annotation.error.ErrorTypes;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.loader.enricher.EnricherTestUtils;
import org.mule.runtime.module.extension.internal.loader.enricher.LevelErrorTypes;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.test.heisenberg.extension.HeisenbergErrors;
import org.mule.test.heisenberg.extension.HeisenbergExtension;

public class ErrorsDeclarationEnricherTestCase
extends AbstractMuleTestCase {
    private static final String HEISENBERG = "HEISENBERG";
    private static final String MULE_NAMESPACE = "MULE";
    private static final String TYPE = "type";
    private ExtensionModel extensionModel;

    @Test
    public void detectErrorTypesCycleDependency() {
        Assertions.assertThatThrownBy(() -> {
            this.extensionModel = MuleExtensionUtils.loadExtension(HeisenbergWithCyclicErrorTypes.class);
        }).hasMessageContaining("Cyclic Error Types reference detected").isInstanceOf(IllegalModelDefinitionException.class);
    }

    @Test
    public void operationsWithConnectionsThrowsConnectivityError() {
        this.extensionModel = MuleExtensionUtils.loadExtension(HeisenbergExtension.class);
        OperationModel callSaul = (OperationModel)EnricherTestUtils.getNamedObject(((ConfigurationModel)this.extensionModel.getConfigurationModel("config").get()).getOperationModels(), "callSaul");
        Set errorTypesIdentifiers = callSaul.getErrorModels();
        MatcherAssert.assertThat((Object)errorTypesIdentifiers, (Matcher)CoreMatchers.hasItem((Matcher)Matchers.hasProperty((String)TYPE, (Matcher)CoreMatchers.is((Object)"CONNECTIVITY"))));
    }

    @Test
    public void extensionErrorsInheritFromMuleErrors() {
        this.extensionModel = MuleExtensionUtils.loadExtension(HeisenbergExtension.class);
        OperationModel cureCancer = (OperationModel)EnricherTestUtils.getNamedObject(this.extensionModel.getOperationModels(), "cureCancer");
        MatcherAssert.assertThat((Object)cureCancer.getErrorModels(), (Matcher)CoreMatchers.hasItem((Matcher)Matchers.hasProperty((String)TYPE, (Matcher)CoreMatchers.is((Object)HeisenbergErrors.HEALTH.getType()))));
        Optional<ErrorModel> healthError = this.extensionModel.getErrorModels().stream().filter(errorModel -> errorModel.getType().equals(HeisenbergErrors.HEALTH.getType())).findFirst();
        MatcherAssert.assertThat((Object)healthError.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Optional optConnectivityError = healthError.get().getParent();
        MatcherAssert.assertThat((Object)optConnectivityError.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        ErrorModel connectivityError = (ErrorModel)optConnectivityError.get();
        MatcherAssert.assertThat((Object)connectivityError.getType(), (Matcher)CoreMatchers.is((Object)"CONNECTIVITY"));
        MatcherAssert.assertThat((Object)connectivityError.getNamespace(), (Matcher)CoreMatchers.is((Object)HEISENBERG));
        Optional optMuleConnectivityError = connectivityError.getParent();
        MatcherAssert.assertThat((Object)optMuleConnectivityError.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        ErrorModel muleConnectivityError = (ErrorModel)optMuleConnectivityError.get();
        MatcherAssert.assertThat((Object)muleConnectivityError.getType(), (Matcher)CoreMatchers.is((Object)"CONNECTIVITY"));
        MatcherAssert.assertThat((Object)muleConnectivityError.getNamespace(), (Matcher)CoreMatchers.is((Object)MULE_NAMESPACE));
    }

    @Test
    public void operationUsesANotMappedErrorType() {
        Assertions.assertThatThrownBy(() -> {
            this.extensionModel = MuleExtensionUtils.loadExtension(HeisenbergWithNotMappedErrorType.class);
        }).hasMessageContaining("Invalid operation throws detected, the extension declared to throw errors").isInstanceOf(IllegalModelDefinitionException.class);
    }

    @Test
    public void orphanErrorsUsesAnyAsParent() {
        this.extensionModel = MuleExtensionUtils.loadExtension(HeisenbergWithOrphanErrors.class);
        ErrorModel errorModel = this.extensionModel.getErrorModels().stream().filter(error -> error.getType().equals("HEALTH")).findFirst().get();
        MatcherAssert.assertThat((Object)errorModel.getNamespace(), (Matcher)CoreMatchers.is((Object)HEISENBERG));
        Optional anyExtensionError = errorModel.getParent();
        MatcherAssert.assertThat((Object)anyExtensionError.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ErrorModel)anyExtensionError.get()).getType(), (Matcher)CoreMatchers.is((Object)MuleErrors.ANY.getType()));
        MatcherAssert.assertThat((Object)((ErrorModel)anyExtensionError.get()).getNamespace(), (Matcher)CoreMatchers.is((Object)MULE_NAMESPACE));
    }

    @Test
    public void operationThrowsOverridesExtensionThrows() {
        this.extensionModel = MuleExtensionUtils.loadExtension(HeisenbergWithOperationThrows.class);
        OperationModel someOperation = (OperationModel)this.extensionModel.getOperationModel("someOperation").get();
        Optional<ErrorModel> operationError = someOperation.getErrorModels().stream().filter(errorModel -> errorModel.getType().equals(LevelErrorTypes.OPERATION.getType())).findFirst();
        MatcherAssert.assertThat((Object)operationError.isPresent(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void operationInheritsExtensionErrorThrows() {
        this.extensionModel = MuleExtensionUtils.loadExtension(HeisenbergWithExtensionThrows.class);
        OperationModel someOperation = (OperationModel)this.extensionModel.getOperationModel("someOperation").get();
        Optional<ErrorModel> operationError = someOperation.getErrorModels().stream().filter(errorModel -> errorModel.getType().equals(LevelErrorTypes.EXTENSION.getType())).findFirst();
        MatcherAssert.assertThat((Object)operationError.isPresent(), (Matcher)CoreMatchers.is((Object)true));
    }

    public static enum OrphanErrorTypes implements ErrorTypeDefinition<OrphanErrorTypes>
    {
        HEALTH,
        CONNECTIVITY,
        OAUTH2;

    }

    public static class ExtensionLevelErrorTypeProvider
    implements ErrorTypeProvider {
        public Set<ErrorTypeDefinition> getErrorTypes() {
            return Collections.singleton(LevelErrorTypes.EXTENSION);
        }
    }

    public static class OperationLevelErrorTypeProvider
    implements ErrorTypeProvider {
        public Set<ErrorTypeDefinition> getErrorTypes() {
            return Collections.singleton(LevelErrorTypes.OPERATION);
        }
    }

    private static class OperationWithOutThrows {
        private OperationWithOutThrows() {
        }

        public void someOperation() {
        }
    }

    private static class OperationWithThrows {
        private OperationWithThrows() {
        }

        @Throws(value={OperationLevelErrorTypeProvider.class})
        public void someOperation() {
        }
    }

    public static enum CyclicErrorTypes implements ErrorTypeDefinition<CyclicErrorTypes>
    {
        TYPE_A{

            public Optional<ErrorTypeDefinition<?>> getParent() {
                return Optional.of(TYPE_B);
            }
        }
        ,
        TYPE_B{

            public Optional<ErrorTypeDefinition<?>> getParent() {
                return Optional.of(TYPE_C);
            }
        }
        ,
        TYPE_C{

            public Optional<ErrorTypeDefinition<?>> getParent() {
                return Optional.of(TYPE_A);
            }
        };

    }

    private static class InvalidErrorOperations {
        private InvalidErrorOperations() {
        }

        @Throws(value={ErrorTypeProviderWithInvalidErrors.class})
        public void someOperation() {
        }

        public static class ErrorTypeProviderWithInvalidErrors
        implements ErrorTypeProvider {
            public Set<ErrorTypeDefinition> getErrorTypes() {
                return Collections.singleton(WrongErrors.WHATEVER);
            }

            public static enum WrongErrors implements ErrorTypeDefinition<MuleErrors>
            {
                WHATEVER{

                    @Override
                    public Optional<ErrorTypeDefinition<?>> getParent() {
                        return Optional.empty();
                    }
                };


                public Optional<ErrorTypeDefinition<?>> getParent() {
                    return Optional.of(MuleErrors.ANY);
                }
            }
        }
    }

    @Extension(name="Heisenberg")
    @ErrorTypes(value=LevelErrorTypes.class)
    @Throws(value={ExtensionLevelErrorTypeProvider.class})
    @Operations(value={OperationWithOutThrows.class})
    public static class HeisenbergWithExtensionThrows
    extends HeisenbergExtension {
    }

    @Extension(name="Heisenberg")
    @ErrorTypes(value=LevelErrorTypes.class)
    @Throws(value={ExtensionLevelErrorTypeProvider.class})
    @Operations(value={OperationWithThrows.class})
    public static class HeisenbergWithOperationThrows
    extends HeisenbergExtension {
    }

    @Extension(name="Heisenberg")
    @ErrorTypes(value=OrphanErrorTypes.class)
    public static class HeisenbergWithOrphanErrors
    extends HeisenbergExtension {
    }

    @Extension(name="Heisenberg")
    @Operations(value={InvalidErrorOperations.class})
    @ErrorTypes(value=HeisenbergErrors.class)
    public static class HeisenbergWithNotMappedErrorType
    extends HeisenbergExtension {
    }

    @ErrorTypes(value=CyclicErrorTypes.class)
    @Extension(name="Heisenberg")
    public static class HeisenbergWithCyclicErrorTypes
    extends HeisenbergExtension {
    }
}

