/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.streaming;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.io.IOException;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.petstore.extension.PetStoreOperations;

public class ReconnectionWithStreamingTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final long ORIGINAL_POSITION = 10L;

    protected String getConfigFile() {
        return "streaming/reconnection-with-streaming-config.xml";
    }

    @Test
    public void cursorComingFromProviderIsResetOnReconnection() throws Exception {
        CursorStream cursorStream = this.createMockCursor(10L, "hn");
        CursorStreamProvider provider = (CursorStreamProvider)Mockito.mock(CursorStreamProvider.class);
        Mockito.when((Object)((CursorStream)provider.openCursor())).thenReturn((Object)cursorStream);
        this.assertReconnection("streamingReconnect", cursorStream, provider);
    }

    @Test
    public void standaloneCursorIsResetOnReconnection() throws Exception {
        CursorStream cursorStream = this.createMockCursor(10L, "hn");
        this.assertReconnection("streamingReconnect", cursorStream, cursorStream);
    }

    @Test
    public void cursorIsNotAffectedIfCloseIsCalled() throws Exception {
        PetStoreOperations.shouldFailWithConnectionException = true;
        PetStoreOperations.operationExecutionCounter.set(0);
        CoreEvent response = ((FlowRunner)this.flowRunner("streamingReconnectWithClosedStream").withVariable("signature", (Object)"hn")).run();
        Assert.assertThat((Object)response.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"SUCCESS"));
        Assert.assertThat((Object)PetStoreOperations.operationExecutionCounter.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
    }

    @Test
    public void cursorWrappedInTypedValueIsNotAffectedIfCloseIsCalled() throws Exception {
        PetStoreOperations.shouldFailWithConnectionException = true;
        PetStoreOperations.operationExecutionCounter.set(0);
        CoreEvent response = ((FlowRunner)this.flowRunner("streamingTypedValueReconnectWithClosedStream").withVariable("signature", (Object)"hn")).run();
        Assert.assertThat((Object)response.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"SUCCESS"));
        Assert.assertThat((Object)PetStoreOperations.operationExecutionCounter.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
    }

    @Test
    @Issue(value="W-10619668")
    @Description(value="Checks that it is not possible for an operation to close a CursorStream that comes from a parameter inside a ParameterGroup")
    public void cursorInParameterGroupIsNotAffectedIfCloseIsCalled() throws Exception {
        PetStoreOperations.shouldFailWithConnectionException = true;
        PetStoreOperations.operationExecutionCounter.set(0);
        CoreEvent response = ((FlowRunner)this.flowRunner("streamingReconnectWithClosedStreamInParameterGroup").withVariable("signature", (Object)"hn")).run();
        Assert.assertThat((Object)response.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"SUCCESS"));
        Assert.assertThat((Object)PetStoreOperations.operationExecutionCounter.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
    }

    @Test
    @Issue(value="W-10619668")
    @Description(value="Checks that it is not possible for an operation to close a CursorStream that comes from a parameter inside a ParameterGroup with showInDsl")
    public void cursorInParameterGroupShownInDslIsNotAffectedIfCloseIsCalled() throws Exception {
        PetStoreOperations.shouldFailWithConnectionException = true;
        PetStoreOperations.operationExecutionCounter.set(0);
        CoreEvent response = ((FlowRunner)this.flowRunner("streamingReconnectWithClosedStreamInParameterGroupShownInDsl").withVariable("signature", (Object)"hn")).run();
        Assert.assertThat((Object)response.getMessage().getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"SUCCESS"));
        Assert.assertThat((Object)PetStoreOperations.operationExecutionCounter.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
    }

    @Test
    public void cursorInParameterGroupIsResetOnReconnection() throws Exception {
        CursorStream cursor = this.createMockCursor(10L, "hn");
        this.assertReconnection("streamingReconnectWithParameterGroup", cursor, cursor);
    }

    @Test
    public void cursorInParameterGroupWithShowDslIsResetOnReconnection() throws Exception {
        CursorStream cursor = this.createMockCursor(10L, "hn");
        this.assertReconnection("streamingReconnectWithParameterGroupShowDsl", cursor, cursor);
    }

    @Test
    public void cursorWithTypedValueInParameterGroupWithShowDslIsResetOnReconnection() throws Exception {
        CursorStream signatureCursor = this.createMockCursor(10L, "hn");
        CursorStream addressCursor = this.createMockCursorNotThrowingError(10L, "Juana Manso 999");
        CoreEvent response = ((FlowRunner)((FlowRunner)this.flowRunner("streamingReconnectWithParameterGroupShowDslWithTypedParameter").withVariable("signature", (Object)signatureCursor)).withVariable("address", (Object)addressCursor)).run();
        this.assertCursor(signatureCursor, 10L, 3);
        this.assertCursor(addressCursor, 10L, 3);
        this.assertResponse(response);
    }

    @Test
    public void cursorWithAliasInParameterGroupWithShowDslIsResetOnReconnection() throws Exception {
        CursorStream signatureCursor = this.createMockCursor(10L, "hn");
        CursorStream certificateCursor = this.createMockCursorNotThrowingError(10L, "ownership certificate");
        CoreEvent response = ((FlowRunner)((FlowRunner)this.flowRunner("streamingReconnectWithParameterGroupShowDslWithParameterWithAlias").withVariable("signature", (Object)signatureCursor)).withVariable("certificate", (Object)certificateCursor)).run();
        this.assertCursor(signatureCursor, 10L, 3);
        this.assertCursor(certificateCursor, 10L, 3);
        this.assertResponse(response);
    }

    @Test
    public void cursorWithTypedValueIsResetOnReconnection() throws Exception {
        CursorStream cursor = this.createMockCursor(10L, "hn");
        this.assertReconnection("streamingReconnectWithTypedParameter", cursor, cursor);
    }

    private void assertReconnection(String flowName, CursorStream cursor, Object container) throws Exception {
        CoreEvent response = ((FlowRunner)this.flowRunner(flowName).withVariable("signature", container)).run();
        this.assertCursor(cursor, 10L, 3);
        this.assertResponse(response);
    }

    private void assertCursor(CursorStream cursor, long position, int numberOfReads) throws IOException {
        ((CursorStream)Mockito.verify((Object)cursor)).seek(position);
        ((CursorStream)Mockito.verify((Object)cursor, (VerificationMode)Mockito.times((int)numberOfReads))).read((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
    }

    private void assertResponse(CoreEvent response) {
        Object payload = response.getMessage().getPayload().getValue();
        Assert.assertThat((Object)payload, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(List.class)));
        Assert.assertThat((Object)((List)payload), (Matcher)Matchers.hasSize((int)3));
    }

    private CursorStream createMockCursor(long originalPosition, String data) throws IOException {
        CursorStream cursorStream = (CursorStream)Mockito.mock(CursorStream.class);
        Mockito.when((Object)cursorStream.getPosition()).thenReturn((Object)originalPosition);
        Mockito.when((Object)cursorStream.read((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenThrow(new Throwable[]{new RuntimeException((Throwable)new ConnectionException("kaboom"))}).thenAnswer(i -> this.copyDataBytes(data, (byte[])i.getArguments()[0])).thenReturn((Object)-1);
        return cursorStream;
    }

    private CursorStream createMockCursorNotThrowingError(long originalPosition, String data) throws IOException {
        CursorStream cursorStream = (CursorStream)Mockito.mock(CursorStream.class);
        Mockito.when((Object)cursorStream.getPosition()).thenReturn((Object)originalPosition);
        Mockito.when((Object)cursorStream.read((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenAnswer(i -> this.copyDataBytes(data, (byte[])i.getArguments()[0])).thenReturn((Object)-1);
        return cursorStream;
    }

    private int copyDataBytes(String data, byte[] buffer) {
        byte[] dataBuffer = data.getBytes();
        System.arraycopy(dataBuffer, 0, buffer, 0, dataBuffer.length);
        return dataBuffer.length;
    }
}

