/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.source;

import java.util.LinkedList;
import java.util.List;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.tck.probe.PollingProber;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.petstore.extension.PetStoreSimpleSourceWithSdkApi;

public class SourceExecutionSdkApiTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final int TIMEOUT = 5000;
    private static final int DELAY = 100;
    private static final List<CoreEvent> EVENTS = new LinkedList<CoreEvent>();

    protected void doTearDown() throws Exception {
        EVENTS.clear();
    }

    protected String getConfigFile() {
        return "source/source-notification-sdk-api-config.xml";
    }

    @Test
    public void onSuccessMethodCall() throws Exception {
        this.startFlow("onSuccessMethodCallFlow");
        PollingProber.check((long)5000L, (long)100L, () -> PetStoreSimpleSourceWithSdkApi.ON_SUCCESS_CALL_COUNT > 0);
        PollingProber.check((long)5000L, (long)100L, () -> PetStoreSimpleSourceWithSdkApi.ON_TERMINATE_CALL_COUNT > 0);
    }

    @Test
    public void onErrorMethodCall() throws Exception {
        this.startFlow("onErrorMethodCallFlow");
        PollingProber.check((long)5000L, (long)100L, () -> PetStoreSimpleSourceWithSdkApi.ON_ERROR_CALL_COUNT > 0);
        PollingProber.check((long)5000L, (long)100L, () -> PetStoreSimpleSourceWithSdkApi.ON_TERMINATE_CALL_COUNT > 0);
    }

    private void startFlow(String flowName) throws Exception {
        ((Startable)this.getFlowConstruct(flowName)).start();
    }

    public static class SourceProcessor
    implements Processor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CoreEvent process(CoreEvent event) throws MuleException {
            List<CoreEvent> list = EVENTS;
            synchronized (list) {
                EVENTS.add(event);
            }
            return event;
        }
    }
}

