/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.connector;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runners.Parameterized;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.PollingProber;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.petstore.extension.FailingPetStoreSource;
import org.mule.test.petstore.extension.PetStoreConnector;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class PetStoreSourceRetryPolicyFailsDeploymentTestCase
extends AbstractExtensionFunctionalTestCase {
    public static final int TIMEOUT_MILLIS = 20000;
    public static final int POLL_DELAY_MILLIS = 50;
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Parameterized.Parameter(value=0)
    public boolean failsDeployment;
    @Parameterized.Parameter(value=1)
    public String connectionConfig;
    @Parameterized.Parameter(value=2)
    public String sourceConfig;
    @Parameterized.Parameter(value=3)
    public int expectedRetries;
    @Rule
    public SystemProperty muleDisableAsyncRetryPolicyOnSourcesProperty = new SystemProperty("mule.disableAsyncRetryPolicyOnSources", "false");

    @Parameterized.Parameters(name="{1} - {2} - failsDeployment: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({false, "petstore-connection-dont-fail-deployment.xml", "petstore-source-retry-policy-error.xml", 2}, {true, "petstore-connection-fail-deployment.xml", "petstore-source-retry-policy-error.xml", 2}, {false, "petstore-connection-dont-fail-deployment.xml", "petstore-source-retry-policy-connection-exception.xml", 3}, {false, "petstore-connection-fail-deployment.xml", "petstore-source-retry-policy-connection-exception.xml", 3});
    }

    protected String[] getConfigFiles() {
        return new String[]{this.connectionConfig, this.sourceConfig};
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        PetStoreConnector.clearTimesStarted();
        FailingPetStoreSource.failedDueOnException = false;
        if (this.failsDeployment) {
            this.exception.expect(RetryPolicyExhaustedException.class);
            this.exception.expectCause(CoreMatchers.sameInstance((Object)FailingPetStoreSource.connectionException));
        } else {
            this.exception = ExpectedException.none();
        }
        super.doSetUpBeforeMuleContextCreation();
    }

    protected void doTearDown() throws Exception {
        PetStoreConnector.clearTimesStarted();
        FailingPetStoreSource.failedDueOnException = false;
        if (FailingPetStoreSource.executor != null) {
            FailingPetStoreSource.executor.shutdownNow();
        }
        super.doTearDown();
    }

    @Test
    public void retryPolicySourceFailOnStart() throws Exception {
        PollingProber.probe((long)20000L, (long)50L, () -> {
            Assert.assertThat((Object)PetStoreConnector.getTimesStarted(), (Matcher)Matchers.is((Object)this.expectedRetries));
            return true;
        });
    }
}

