/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.client.operation;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.test.heisenberg.extension.HeisenbergOperations;
import org.mule.test.heisenberg.extension.model.types.IntegerAttributes;
import org.mule.test.module.extension.AbstractHeisenbergConfigTestCase;
import org.mule.test.vegan.extension.VeganPolicy;

@Feature(value="Extensions Client")
public abstract class ExtensionsClientTestCase
extends AbstractHeisenbergConfigTestCase {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    protected static final String HEISENBERG_EXT_NAME = "Heisenberg";
    protected static final String HEISENBERG_CONFIG = "heisenberg";
    private static final String ALIAS_OUTPUT = "jeje, my name is Juani and I'm 23 years old";
    private static final String ANOTHER_ALIAS_OUTPUT = "jeje, my name is Heisenberg and I'm 23 years old";
    @Inject
    protected ExtensionsClient client;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        HeisenbergOperations.disposed = false;
    }

    protected boolean isDisposeContextPerClass() {
        return false;
    }

    @After
    public void after() {
        HeisenbergOperations.disposed = false;
    }

    protected String[] getConfigFiles() {
        return new String[]{"vegan-config.xml", "heisenberg-config.xml"};
    }

    protected abstract <T, A> Result<T, A> doExecute(String var1, String var2, Optional<String> var3, Map<String, Object> var4, boolean var5, boolean var6) throws Throwable;

    private <T, A> Result<T, A> doExecute(String extension, String operation, String configName, Map<String, Object> params) throws Throwable {
        return this.doExecute(extension, operation, Optional.of(configName), params, false, false);
    }

    @Test
    @Description(value="Executes a simple operation using the client and checks the output")
    public void executeSimpleOperation() throws Throwable {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("victim", "Juani");
        params.put("goodbyeMessage", "ADIOS");
        Result result = this.doExecute(HEISENBERG_EXT_NAME, "kill", HEISENBERG_CONFIG, params);
        MatcherAssert.assertThat((Object)((String)result.getOutput()), (Matcher)CoreMatchers.is((Object)"ADIOS, Juani"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void executePagedOperation() throws Throwable {
        Result result = this.doExecute(HEISENBERG_EXT_NAME, "getPagedBlocklist", Optional.of(HEISENBERG_CONFIG), Collections.emptyMap(), true, false);
        CursorIteratorProvider provider = (CursorIteratorProvider)result.getOutput();
        AtomicInteger count = new AtomicInteger(0);
        Iterator iterator = (Iterator)provider.openCursor();
        try {
            iterator.forEachRemaining(m -> count.addAndGet(1));
            MatcherAssert.assertThat((Object)count.get(), (Matcher)CoreMatchers.is((Object)6));
        }
        finally {
            IOUtils.closeQuietly((Closeable)((Closeable)((Object)iterator)));
            provider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void executeInputStreamOperation() throws Throwable {
        Result result = this.doExecute(HEISENBERG_EXT_NAME, "nameAsStream", Optional.of(HEISENBERG_CONFIG), Collections.emptyMap(), false, true);
        CursorStreamProvider streamProvider = (CursorStreamProvider)result.getOutput();
        String value = IOUtils.toString((CursorStreamProvider)streamProvider);
        try {
            MatcherAssert.assertThat((Object)value, (Matcher)CoreMatchers.equalTo((Object)HEISENBERG_EXT_NAME));
        }
        finally {
            streamProvider.close();
        }
    }

    @Test
    @Description(value="Executes a simple operation twice using the client and checks the output")
    public void executeSimpleOperationTwice() throws Throwable {
        this.executeSimpleOperation();
        this.executeSimpleOperation();
    }

    @Test
    @Description(value="Executes a simple operation with an expression as parameter using the client and checks the output")
    public void executeSimpleOperationWithExpression() throws Throwable {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("victim", "#['Juani']");
        params.put("goodbyeMessage", "ADIOS");
        Result result = this.doExecute(HEISENBERG_EXT_NAME, "kill", HEISENBERG_CONFIG, params);
        MatcherAssert.assertThat((Object)((String)result.getOutput()), (Matcher)CoreMatchers.is((Object)"ADIOS, Juani"));
    }

    @Test
    @Description(value="Executes an operation that has a parameter group using the client and checks the output")
    public void executeOperationWithParameterGroup() throws Throwable {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("greeting", "jeje");
        params.put("age", 23);
        params.put("myName", "Juani");
        params.put("knownAddresses", Collections.emptyList());
        Result result = this.doExecute(HEISENBERG_EXT_NAME, "alias", HEISENBERG_CONFIG, params);
        MatcherAssert.assertThat((Object)((String)result.getOutput()), (Matcher)CoreMatchers.is((Object)ALIAS_OUTPUT));
    }

    @Test
    @Description(value="Executes an operation that has a parameter group using the client and checks the output")
    public void executeOperationWithParameterGroupUsingOptional() throws Throwable {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("greeting", "jeje");
        params.put("age", 23);
        params.put("knownAddresses", Collections.emptyList());
        Result result = this.doExecute(HEISENBERG_EXT_NAME, "alias", HEISENBERG_CONFIG, params);
        MatcherAssert.assertThat((Object)((String)result.getOutput()), (Matcher)CoreMatchers.is((Object)ANOTHER_ALIAS_OUTPUT));
    }

    @Test
    @Description(value="Executes a simple operation twice with different parameters using the client and checks the output")
    public void executeSimpleOperationTwiceWithDifferentParameters() throws Throwable {
        this.executeOperationWithParameterGroup();
        this.executeOperationWithParameterGroupUsingOptional();
    }

    @Test
    @Description(value="Executes a two different operationsusing the client and checks the output")
    public void executeTwoDifferentOperation() throws Throwable {
        this.executeOperationWithParameterGroup();
        this.executeSimpleOperation();
    }

    @Test
    @Description(value="Executes an operation that has a parameter with default value using the client and checks the output")
    public void executeOperationWithDefaultValueParameter() throws Throwable {
        Result result = this.doExecute("vegan", "tryToEatThisListOfMaps", "apple", Collections.emptyMap());
        MatcherAssert.assertThat((Object)((Collection)result.getOutput()), (Matcher)CoreMatchers.instanceOf(List.class));
        MatcherAssert.assertThat((Object)((Collection)result.getOutput()), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    @Description(value="Executes an operation that has a @NullSafe annotated parameter using the client and checks the output")
    public void executeOperationWithNullSafeParameter() throws Throwable {
        Result result = this.doExecute("vegan", "applyPolicy", "banana", Collections.emptyMap());
        MatcherAssert.assertThat((Object)((VeganPolicy)result.getOutput()).getMeetAllowed(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)((VeganPolicy)result.getOutput()).getIngredients().getSaltMiligrams(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    @Description(value="Executes an operation that returns attributes metadata using the client and checks the output and the attributes")
    public void executeOperationThatReturnsAttributes() throws Throwable {
        Result result = this.doExecute(HEISENBERG_EXT_NAME, "getEnemy", HEISENBERG_CONFIG, Collections.emptyMap());
        MatcherAssert.assertThat((Object)((String)result.getOutput()), (Matcher)CoreMatchers.is((Object)"Gustavo Fring"));
        MatcherAssert.assertThat((Object)result.getAttributes().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((IntegerAttributes)result.getAttributes().get()).getValue(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    @Description(value="Executes a void operation using the client")
    public void executeVoidOperation() throws Throwable {
        Result result = this.doExecute(HEISENBERG_EXT_NAME, "die", HEISENBERG_CONFIG, Collections.emptyMap());
        MatcherAssert.assertThat((Object)result.getOutput(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)result.getAttributes().isPresent(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @Description(value="Executes an operation that fails using the client and checks the threw exception")
    public void executeFailureOperation() throws Throwable {
        this.exception.expect(MuleException.class);
        this.exception.expectCause(CoreMatchers.instanceOf(ConnectionException.class));
        this.exception.expectMessage("You are not allowed to speak with gus.");
        this.doExecute(HEISENBERG_EXT_NAME, "callGusFring", HEISENBERG_CONFIG, Collections.emptyMap());
    }

    @Test
    @Description(value="Executes an operation that fails using the client and checks the threw exception")
    public void executeFailureNonBlockingOperation() throws Throwable {
        this.exception.expect(MuleException.class);
        this.exception.expectCause(CoreMatchers.instanceOf(ConnectionException.class));
        this.exception.expectMessage("You are not allowed to speak with gus.");
        this.doExecute(HEISENBERG_EXT_NAME, "callGusFringNonBlocking", HEISENBERG_CONFIG, Collections.emptyMap());
    }

    @Test
    @Description(value="Tries to execute an operation from an extension that does not exist")
    public void nonExistentExtension() throws Throwable {
        this.exception.expect(MuleRuntimeException.class);
        this.exception.expectMessage("No Extension [no-exist] Found");
        this.doExecute("no-exist", "operation", "config", Collections.emptyMap());
    }

    @Test
    @Description(value="Tries to execute an operation that does not exist")
    public void nonExistentOperation() throws Throwable {
        this.exception.expect(MuleRuntimeException.class);
        this.exception.expectMessage("No Operation [operationDontExist] Found");
        this.doExecute("vegan", "operationDontExist", "config", Collections.emptyMap());
    }

    @Test
    @Description(value="Tries to execute an operation with a configuration that does not exist")
    public void nonExistentConfiguration() throws Throwable {
        this.exception.expect(MuleRuntimeException.class);
        this.exception.expectMessage("No configuration [configDontExist] found");
        this.doExecute("vegan", "applyPolicy", "configDontExist", Collections.emptyMap());
    }

    @Test
    @Description(value="Tries to execute an operation that takes a long time")
    public void longOperation() throws Throwable {
        MatcherAssert.assertThat(this.doExecute("vegan", "longDigest", Optional.empty(), Collections.emptyMap(), false, false), (Matcher)Matchers.not((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    @Issue(value="W-17524906")
    @Description(value="Tries to execute an operation with a TypedValue parameter")
    public void operationWithTypedValueParameter() throws Throwable {
        String message = "Hello from ExtensionClient";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("message", new TypedValue((Object)"Hello from ExtensionClient", DataType.STRING));
        Result result = this.doExecute(HEISENBERG_EXT_NAME, "echoStaticMessage", Optional.empty(), params, false, false);
        MatcherAssert.assertThat((Object)result.getOutput(), (Matcher)CoreMatchers.is((Object)"Hello from ExtensionClient"));
    }
}

