/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.values;

import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Test;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueResult;
import org.mule.tck.junit4.matcher.ValueMatcher;
import org.mule.test.module.extension.values.AbstractValuesTestCase;

public class ChatOperationValuesTestCase
extends AbstractValuesTestCase {
    protected String getConfigFile() {
        return "values/chat-operation-values.xml";
    }

    @Test
    public void workspaceProvider() throws Exception {
        ValueResult result = this.getValueResult("workspaceValueProvider", "body", "workspace");
        MatcherAssert.assertThat((Object)result.getValues(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat((Object)result.getValues(), this.hasValues("workspace1", "workspace2", "workspace3"));
    }

    @Test
    public void channelIdProvider() throws Exception {
        ValueResult result = this.getValueResult("channelIdValueProvider", "body", "channelId");
        MatcherAssert.assertThat((Object)result.getValues(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        MatcherAssert.assertThat((Object)result.getValues(), this.hasValues("channel for workspace2", "other channel for workspace2"));
    }

    @Test
    public void workspaceProviderWithExpression() throws Exception {
        ValueResult result = this.getValueResult("workspaceValueProviderWithExpression", "body", "workspace");
        MatcherAssert.assertThat((Object)result.getValues(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        MatcherAssert.assertThat((Object)result.getValues(), this.hasValues("workspace1", "workspace2", "workspace3"));
    }

    @Test
    public void channelIdProviderWithExpression() throws Exception {
        ValueResult result = this.getValueResult("channelIdValueProviderWithExpression", "body", "channelId");
        MatcherAssert.assertThat((Object)result.getValues(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        MatcherAssert.assertThat((Object)result.getValues(), this.hasValues("channel for workspace2", "other channel for workspace2"));
    }

    @Test
    public void parameterWithMultiLevelFieldValues() throws Exception {
        Set<Value> values = this.getValues("multiLevelValueProvider", "body", "workspace");
        ValueMatcher workspace1Value = ValueMatcher.valueWithId((String)"workspace1").withDisplayName("workspace1").withPartName("body.workspace").withChilds(new ValueMatcher[]{ValueMatcher.valueWithId((String)"one channel").withDisplayName("one channel").withPartName("body.channelId"), ValueMatcher.valueWithId((String)"another channel").withDisplayName("another channel").withPartName("body.channelId"), ValueMatcher.valueWithId((String)"last channel channel").withDisplayName("last channel channel").withPartName("body.channelId")});
        ValueMatcher workspace2Value = ValueMatcher.valueWithId((String)"workspace2").withDisplayName("workspace2").withPartName("body.workspace").withChilds(new ValueMatcher[]{ValueMatcher.valueWithId((String)"channel for workspace2").withDisplayName("channel for workspace2").withPartName("body.channelId"), ValueMatcher.valueWithId((String)"other channel for workspace2").withDisplayName("other channel for workspace2").withPartName("body.channelId")});
        ValueMatcher workspace3Value = ValueMatcher.valueWithId((String)"workspace3").withDisplayName("workspace3").withPartName("body.workspace").withChilds(new ValueMatcher[]{ValueMatcher.valueWithId((String)"only channel for workspace3").withDisplayName("only channel for workspace3").withPartName("body.channelId")});
        MatcherAssert.assertThat(values, this.hasValues(workspace1Value, workspace2Value, workspace3Value));
    }
}

