/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.transaction;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.ThrowableMessageMatcher;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.transaction.TransactionStatusException;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.transactional.TransactionalOperations;
import org.mule.test.transactional.connection.TestLocalTransactionalConnection;
import org.mule.test.transactional.connection.TestTransactionalConnection;

public class TransactionalOperationTestCase
extends AbstractExtensionFunctionalTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected String getConfigFile() {
        return "transaction-config.xml";
    }

    @Test
    public void commited() throws Exception {
        ((FlowRunner)this.flowRunner("commitLocalTx").withPayload((Object)"")).run();
    }

    @Test
    public void rolledBack() throws Exception {
        ((FlowRunner)this.flowRunner("rollbackLocalTx").withPayload((Object)"")).run();
    }

    @Test
    public void executeTransactionless() throws Exception {
        TestLocalTransactionalConnection connection = (TestLocalTransactionalConnection)((FlowRunner)this.flowRunner("executeTransactionless").withPayload((Object)"")).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)connection.isTransactionBegun(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)connection.isTransactionCommited(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)connection.isTransactionRolledback(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void localTxDoesntSupportMultipleResources() throws Exception {
        this.flowRunner("localTxDoesntSupportMultipleResources").runExpectingException(Matchers.allOf((Matcher)CoreMatchers.instanceOf(TransactionException.class), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"the current transaction doesn't support it and could not be bound"))));
    }

    @Test
    public void localTxSupportsMultipleOperationsFromSameResource() throws Exception {
        this.flowRunner("localTxSupportsMultipleOperationsFromSameResource").run();
    }

    @Test
    public void pagedOperationInTx() throws Exception {
        CoreEvent event = this.flowRunner("pagedOperationInTx").run();
        Collection accumulator = (Collection)((TypedValue)event.getVariables().get("accumulator")).getValue();
        MatcherAssert.assertThat((Object)accumulator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)accumulator, (Matcher)Matchers.hasSize((int)2));
        Iterator it = accumulator.iterator();
        Integer id1 = (Integer)it.next();
        Integer id2 = (Integer)it.next();
        MatcherAssert.assertThat((Object)id1, (Matcher)CoreMatchers.equalTo((Object)id2));
    }

    @Test
    public void pagedOperationInTxAlwaysUsesSameConnection() throws Exception {
        CoreEvent event = this.flowRunner("pagedOperationInTxAlwaysUsesSameConnection").run();
        List connections = (List)((TypedValue)event.getVariables().get("connections")).getValue();
        MatcherAssert.assertThat((Object)connections, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)connections, (Matcher)Matchers.hasSize((int)2));
        TestTransactionalConnection connection = (TestTransactionalConnection)connections.get(0);
        MatcherAssert.assertThat((Object)connections.stream().allMatch(c -> c == connection), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void pagedOperationWithoutTx() throws Exception {
        CoreEvent event = this.flowRunner("pagedOperationWithoutTx").run();
        Collection accumulator = (Collection)((TypedValue)event.getVariables().get("accumulator")).getValue();
        MatcherAssert.assertThat((Object)accumulator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)accumulator, (Matcher)Matchers.hasSize((int)2));
        Iterator it = accumulator.iterator();
        Integer id1 = (Integer)it.next();
        Integer id2 = (Integer)it.next();
        MatcherAssert.assertThat((Object)id1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)id2)));
    }

    @Test
    public void doNotReconnectPagedOperationInTx() throws Exception {
        this.resetCounters();
        this.expectedException.expectCause(CoreMatchers.instanceOf(ConnectionException.class));
        this.expectedException.expectMessage("Failed to retrieve Page");
        ((FlowRunner)this.flowRunner("failingPagedOperationInTx").withVariable("failOn", (Object)1)).run();
    }

    @Test
    public void doNotReconnectStickyPagedOperationInTx() throws Exception {
        this.resetCounters();
        this.expectedException.expectCause(CoreMatchers.instanceOf(ConnectionException.class));
        this.expectedException.expectMessage("Failed to retrieve Page");
        ((FlowRunner)this.flowRunner("stickyFailingPagedOperationInTx").withVariable("failOn", (Object)1)).run();
    }

    @Test
    @Ignore(value="MULE-19198")
    public void doNotReconnectPagedOperationInTxWhenConnectionExceptionOnSecondPage() throws Exception {
        this.resetCounters();
        this.expectedException.expectCause(CoreMatchers.instanceOf(ConnectionException.class));
        this.expectedException.expectMessage("Failed to retrieve Page");
        ((FlowRunner)this.flowRunner("failingPagedOperationInTx").withVariable("failOn", (Object)2)).run();
    }

    @Test
    @Ignore(value="MULE-19198")
    public void doNotReconnectStickyPagedOperationInTxWhenConnectionExceptionOnSecondPage() throws Exception {
        this.resetCounters();
        this.expectedException.expectCause(CoreMatchers.instanceOf(ConnectionException.class));
        this.expectedException.expectMessage("Failed to retrieve Page");
        ((FlowRunner)this.flowRunner("stickyFailingPagedOperationInTx").withVariable("failOn", (Object)2)).run();
    }

    @Test
    public void doReconnectPagedOperationWithoutTx() throws Exception {
        this.resetCounters();
        CoreEvent event = ((FlowRunner)this.flowRunner("failingPagedOperationWithoutTx").withVariable("failOn", (Object)1)).run();
        Collection accumulator = (Collection)((TypedValue)event.getVariables().get("accumulator")).getValue();
        MatcherAssert.assertThat((Object)accumulator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)accumulator, (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void doReconnectStickyPagedOperationWithoutTx() throws Exception {
        this.resetCounters();
        CoreEvent event = ((FlowRunner)this.flowRunner("stickyFailingPagedOperationWithoutTx").withVariable("failOn", (Object)1)).run();
        Collection accumulator = (Collection)((TypedValue)event.getVariables().get("accumulator")).getValue();
        MatcherAssert.assertThat((Object)accumulator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)accumulator, (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void doReconnectPagedOperationWithoutTxWhenConnectionExceptionOnSecondPage() throws Exception {
        this.resetCounters();
        CoreEvent event = ((FlowRunner)this.flowRunner("failingPagedOperationWithoutTx").withVariable("failOn", (Object)2)).run();
        Collection accumulator = (Collection)((TypedValue)event.getVariables().get("accumulator")).getValue();
        MatcherAssert.assertThat((Object)accumulator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)accumulator, (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    @Ignore(value="MULE-19198")
    public void doNotReconnectStickyPagedOperationWithoutTxWhenConnectionExceptionOnSecondPage() throws Exception {
        this.resetCounters();
        this.expectedException.expectCause(CoreMatchers.instanceOf(ConnectionException.class));
        this.expectedException.expectMessage("Failed to retrieve Page");
        ((FlowRunner)this.flowRunner("stickyFailingPagedOperationInTx").withVariable("failOn", (Object)2)).run();
    }

    @Test
    public void cantNestTransactions() throws Exception {
        this.expectedException.expectMessage("Non-XA transactions can't be nested.");
        this.expectedException.expectCause(CoreMatchers.is((Matcher)CoreMatchers.instanceOf(TransactionStatusException.class)));
        this.flowRunner("cantNestTransactions").run();
    }

    @Test
    public void operationJoinsAlreadyCreatedTx() throws Exception {
        this.flowRunner("operationJoinsAlreadyCreatedTx").run();
    }

    @Test
    public void doNotRetryOnTxReconnection() throws Exception {
        this.expectedException.expectCause(CoreMatchers.instanceOf(ConnectionException.class));
        this.expectedException.expectMessage("1");
        this.flowRunner("doNotRetryOnTxReconnection").run();
    }

    private void resetCounters() {
        TransactionalOperations.getPageCalls = 0;
    }
}

