/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.source;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.extension.api.runtime.source.BackPressureContext;
import org.mule.sdk.api.runtime.source.BackPressureAction;
import org.mule.tck.probe.PollingProber;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

@Feature(value="Sources")
@Story(value="Backpressure")
public class BackPressureTestCase
extends AbstractExtensionFunctionalTestCase {
    private static List<CoreEvent> EVENTS;
    private HeisenbergExtension heisenberg;
    private List<BackPressureContext> backPressureContexts;
    private List<org.mule.sdk.api.runtime.source.BackPressureContext> sdkBackPressureContexts;

    protected String getConfigFile() {
        return "source/heisenberg-backpressure-config.xml";
    }

    protected void doSetUp() throws Exception {
        this.heisenberg = (HeisenbergExtension)ExtensionsTestUtils.getConfigurationFromRegistry((String)"heisenberg", (CoreEvent)this.testEvent(), (MuleContext)muleContext);
        MatcherAssert.assertThat((Object)this.heisenberg, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.backPressureContexts = new LinkedList<BackPressureContext>();
        this.sdkBackPressureContexts = new LinkedList<org.mule.sdk.api.runtime.source.BackPressureContext>();
        EVENTS = new LinkedList<CoreEvent>();
    }

    protected void doTearDown() throws Exception {
        this.backPressureContexts = null;
        this.sdkBackPressureContexts = null;
        EVENTS = null;
    }

    @Test
    public void backPressureWithFailStrategy() throws Exception {
        this.startFlow("defaultToFail");
        try {
            PollingProber.check((long)15000L, (long)100L, () -> {
                this.sdkBackPressureContexts.addAll(this.heisenberg.getSdkBackPressureContexts());
                return !this.sdkBackPressureContexts.isEmpty();
            });
            org.mule.sdk.api.runtime.source.BackPressureContext sample = this.sdkBackPressureContexts.get(0);
            MatcherAssert.assertThat((Object)sample.getAction(), (Matcher)CoreMatchers.is((Object)BackPressureAction.FAIL));
            MatcherAssert.assertThat((Object)sample.getEvent().getMessage().getPayload().getValue().toString(), (Matcher)CoreMatchers.containsString((String)"If found by DEA contact"));
            MatcherAssert.assertThat((Object)sample.getSourceCallbackContext(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
        finally {
            this.stopFlow("defaultToFail");
        }
    }

    @Test
    public void backPressureWithDropStrategy() throws Exception {
        this.startFlow("configuredToDrop");
        try {
            PollingProber.check((long)15000L, (long)100L, () -> {
                this.sdkBackPressureContexts.addAll(this.heisenberg.getSdkBackPressureContexts());
                return !this.sdkBackPressureContexts.isEmpty();
            });
            org.mule.sdk.api.runtime.source.BackPressureContext sample = this.sdkBackPressureContexts.get(0);
            MatcherAssert.assertThat((Object)sample.getAction(), (Matcher)CoreMatchers.is((Object)BackPressureAction.DROP));
            MatcherAssert.assertThat((Object)sample.getEvent().getMessage().getPayload().getValue().toString(), (Matcher)CoreMatchers.containsString((String)"If found by DEA contact"));
            MatcherAssert.assertThat((Object)sample.getSourceCallbackContext(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
        finally {
            this.stopFlow("configuredToDrop");
        }
    }

    @Test
    public void defaultToWait() throws Exception {
        this.startFlow("defaultCase");
        try {
            PollingProber.check((long)15000L, (long)100L, () -> EVENTS.size() >= 3);
            MatcherAssert.assertThat(this.backPressureContexts, (Matcher)Matchers.hasSize((int)0));
        }
        finally {
            this.stopFlow("defaultCase");
        }
    }

    private void startFlow(String flowName) throws Exception {
        ((Startable)this.registry.lookupByName(flowName).get()).start();
    }

    private void stopFlow(String flowName) throws Exception {
        ((Stoppable)this.registry.lookupByName(flowName).get()).stop();
    }

    public static class Collector
    implements Processor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CoreEvent process(CoreEvent event) throws MuleException {
            List<CoreEvent> list = EVENTS;
            synchronized (list) {
                EVENTS.add(event);
                return event;
            }
        }
    }
}

