/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.config;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.DefaultComponentIdentifier;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

public class SpringConfigurationComponentLocatorTestCase
extends AbstractExtensionFunctionalTestCase {
    @Inject
    public ConfigurationComponentLocator locator;

    protected String getConfigFile() {
        return "scopes/heisenberg-scope-config.xml";
    }

    protected boolean doTestClassInjection() {
        return true;
    }

    @Test
    @Issue(value="W-16039259")
    @Description(value="Checks that trying to find by component identifier works for scopes implemented with the Java SDK")
    public void findByComponentIdentifier() {
        ComponentIdentifier identifier = new DefaultComponentIdentifier.Builder().name("execute-anything").namespace("heisenberg").build();
        List components = this.locator.find(identifier);
        MatcherAssert.assertThat((Object)components, (Matcher)Matchers.hasSize((int)2));
        List locations = components.stream().map(comp -> comp.getLocation().getLocation()).collect(Collectors.toList());
        MatcherAssert.assertThat(locations, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"executeNonBlocking/processors/0", "executeAnything/processors/0"}));
    }
}

