/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.config;

import io.qameta.allure.Issue;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.vegan.extension.AppleConfig;
import org.mule.test.vegan.extension.EasyToEatConfig;
import org.mule.test.vegan.extension.HealthyFood;

public class ConfigOverrideTestCase
extends AbstractExtensionFunctionalTestCase {
    protected String getConfigFile() {
        return "vegan-config-overrides.xml";
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @Test
    public void simpleParameterOverrideWithConfigDefaults() throws Exception {
        TypedValue result = this.flowRunner("timeToPeelOverrideOperationWithDefaults").run().getMessage().getPayload();
        MatcherAssert.assertThat((Object)((Integer)result.getValue()), (Matcher)Is.is((Object)10));
    }

    @Test
    @Issue(value="MULE-18489")
    public void timeToPeelOverrideOperationWithDefaultsDifferentType() throws Exception {
        TypedValue result = this.flowRunner("timeToPeelOverrideOperationWithDefaultsDifferentType").run().getMessage().getPayload();
        MatcherAssert.assertThat((Object)((Long)result.getValue()), (Matcher)Is.is((Object)10L));
    }

    @Test
    @Issue(value="MULE-18489")
    public void timeToPeelOverrideOperationWithDefaultEnum() throws Exception {
        TypedValue result = this.flowRunner("timeToPeelOverrideOperationWithDefaultEnum").run().getMessage().getPayload();
        MatcherAssert.assertThat((Object)((EasyToEatConfig.Time)result.getValue()), (Matcher)Is.is((Object)EasyToEatConfig.Time.AVERAGE));
    }

    @Test
    public void simpleParameterOverrideWithConfigCustomValues() throws Exception {
        TypedValue result = this.flowRunner("timeToPeelOverrideOperationWithCustom").run().getMessage().getPayload();
        MatcherAssert.assertThat((Object)((Integer)result.getValue()), (Matcher)Is.is((Object)60));
    }

    @Test
    public void simpleParameterIsNotOverriddenIfDeclared() throws Exception {
        TypedValue result = this.flowRunner("timeToPeelDeclareValueInOperationWithCustom").run().getMessage().getPayload();
        MatcherAssert.assertThat((Object)((Integer)result.getValue()), (Matcher)Is.is((Object)30));
    }

    @Test
    public void instanceUsedForOverridesIsTheReferencedOne() throws Exception {
        TypedValue result = this.flowRunner("timeToPeelOverrideOperationWithBananaCustom").run().getMessage().getPayload();
        MatcherAssert.assertThat((Object)((Integer)result.getValue()), (Matcher)Is.is((Object)20));
    }

    @Test
    public void dynamicValuesGetResolved() throws Exception {
        String flowName = "timeToPeelOverrideOperationWithBananaDynamic";
        TypedValue result = ((FlowRunner)((FlowRunner)this.flowRunner("timeToPeelOverrideOperationWithBananaDynamic").withPayload((Object)"45")).withVariable("declaredVar", null)).run().getMessage().getPayload();
        MatcherAssert.assertThat((Object)((Integer)result.getValue()), (Matcher)Is.is((Object)45));
        result = ((FlowRunner)((FlowRunner)this.flowRunner("timeToPeelOverrideOperationWithBananaDynamic").withPayload((Object)"45")).withVariable("declaredVar", (Object)"25")).run().getMessage().getPayload();
        MatcherAssert.assertThat((Object)((Integer)result.getValue()), (Matcher)Is.is((Object)25));
        result = ((FlowRunner)((FlowRunner)this.flowRunner("timeToPeelOverrideOperationWithBananaDynamic").withPayload(null)).withVariable("declaredVar", (Object)"25")).run().getMessage().getPayload();
        MatcherAssert.assertThat((Object)((Integer)result.getValue()), (Matcher)Is.is((Object)25));
        result = ((FlowRunner)((FlowRunner)this.flowRunner("timeToPeelOverrideOperationWithBananaDynamic").withPayload(null)).withVariable("declaredVar", null)).run().getMessage().getPayload();
        MatcherAssert.assertThat((Object)((Integer)result.getValue()), (Matcher)Is.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void listParameterOverrideWithNullsafeFromConfigDefaults() throws Exception {
        TypedValue result = this.flowRunner("mainProducersOverrideOperationWithDefaults").run().getMessage().getPayload();
        MatcherAssert.assertThat((Object)((List)result.getValue()), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void listParameterOverrideWithConfigCustomValues() throws Exception {
        TypedValue result = this.flowRunner("mainProducersOverrideOperationWithCustom").run().getMessage().getPayload();
        MatcherAssert.assertThat((Object)((List)result.getValue()), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((String)((List)result.getValue()).get(0)), (Matcher)IsEqual.equalTo((Object)"appleProducerOne"));
    }

    @Test
    public void listParameterIsNotOverriddenIfDeclared() throws Exception {
        TypedValue result = this.flowRunner("mainProducersDeclareValueInOperationWithCustom").run().getMessage().getPayload();
        MatcherAssert.assertThat((Object)((List)result.getValue()), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((String)((List)result.getValue()).get(0)), (Matcher)IsEqual.equalTo((Object)"getProducersOne"));
    }

    @Test
    public void pojoParameterOverrideFromConfigDefaults() throws Exception {
        TypedValue result = this.flowRunner("sampleOverrideOperationWithDefaults").run().getMessage().getPayload();
        MatcherAssert.assertThat((Object)((HealthyFood)result.getValue()), (Matcher)Is.is((Matcher)Matchers.nullValue()));
    }

    public void pojoParameterOverrideFromNullsafeConfigDefaults() throws Exception {
        TypedValue result = this.flowRunner("sampleOverrideOperationWithBananaDefaults").run().getMessage().getPayload();
        MatcherAssert.assertThat((Object)((HealthyFood)result.getValue()), (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((HealthyFood)result.getValue()).getTasteProfile(), (Matcher)Is.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void pojoParameterOverrideWithConfigCustomValues() throws Exception {
        TypedValue result = this.flowRunner("sampleOverrideOperationWithCustom").run().getMessage().getPayload();
        MatcherAssert.assertThat((Object)((HealthyFood)result.getValue()), (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((HealthyFood)result.getValue()).getTasteProfile(), (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((HealthyFood)result.getValue()).getTasteProfile().isTasty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void pojoParameterIsNotOverriddenIfDeclared() throws Exception {
        TypedValue result = this.flowRunner("sampleDeclareValueInOperationWithCustom").run().getMessage().getPayload();
        MatcherAssert.assertThat((Object)((HealthyFood)result.getValue()), (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((HealthyFood)result.getValue()).getTasteProfile(), (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((HealthyFood)result.getValue()).getTasteProfile().isTasty(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void parameterIsNotOverriddenWithDefaults() throws Exception {
        TypedValue result = this.flowRunner("shouldNotOverrideOverrideOperationWithDefaults").run().getMessage().getPayload();
        MatcherAssert.assertThat((Object)((String)result.getValue()), (Matcher)Is.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void parameterIsNotOverriddenWithCustomValue() throws Exception {
        TypedValue result = this.flowRunner("shouldNotOverrideOverrideOperationWithCustom").run().getMessage().getPayload();
        MatcherAssert.assertThat((Object)((String)result.getValue()), (Matcher)Is.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void parameterIsNotOverriddenWhenDeclaredInline() throws Exception {
        TypedValue result = this.flowRunner("shouldNotOverrideDeclareValueInOperationWithCustom").run().getMessage().getPayload();
        MatcherAssert.assertThat((Object)((String)result.getValue()), (Matcher)Is.is((Object)"declared"));
    }

    @Test
    public void sourceMainAndCallbacksUseOverrideFromConfigDefaults() throws Exception {
        AppleConfig apple = (AppleConfig)this.locateConfig("apple");
        this.pollingProbe(apple, "sourceOverrideWithDefaults", 0, null, null, 10);
    }

    @Test
    public void sourceMainAndCallbacksUseOverrideFromConfigCustom() throws Exception {
        AppleConfig apple = (AppleConfig)this.locateConfig("appleCustom");
        this.pollingProbe(apple, "sourceOverrideWithCustom", 2, true, null, 60);
    }

    @Test
    public void sourceMainAndCallbacksUseDeclaredParameters() throws Exception {
        AppleConfig apple = (AppleConfig)this.locateConfig("appleCustom");
        this.pollingProbe(apple, "sourceDeclareValueInlineWithCustom", 1, false, "declared", 30);
    }

    private boolean assertSourceResults(Map<String, List<Object>> results, String flowName, int mainProducersSize, Boolean tasty, String shouldNotOverride, int timeToPeel) {
        List<Object> objects = results.get(flowName);
        if (objects == null) {
            return false;
        }
        MatcherAssert.assertThat((Object)objects.size(), (Matcher)Is.is((Object)4));
        MatcherAssert.assertThat((Object)((List)objects.get(0)).size(), (Matcher)Is.is((Object)mainProducersSize));
        if (tasty == null) {
            MatcherAssert.assertThat((Object)objects.get(1), (Matcher)Is.is((Matcher)Matchers.nullValue()));
        } else {
            MatcherAssert.assertThat((Object)((HealthyFood)objects.get(1)).getTasteProfile().isTasty(), (Matcher)Is.is((Object)tasty));
        }
        MatcherAssert.assertThat((Object)objects.get(2), (Matcher)Is.is((Object)shouldNotOverride));
        MatcherAssert.assertThat((Object)objects.get(3), (Matcher)Is.is((Object)timeToPeel));
        return true;
    }

    private <T> T locateConfig(String name) throws MuleException {
        return (T)muleContext.getExtensionManager().getConfiguration(name, this.testEvent()).getValue();
    }

    private void pollingProbe(AppleConfig config, String name, int mainProducersSize, Boolean tasty, String shouldNotOverride, int timeToPeel) {
        new PollingProber(30000L, 300L).check((Probe)new JUnitLambdaProbe(() -> this.assertSourceResults(config.getResults(), name, mainProducersSize, tasty, shouldNotOverride, timeToPeel)));
    }
}

