/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.config;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.ThrowableCauseMatcher;
import org.mule.functional.junit4.matchers.ThrowableMessageMatcher;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.petstore.extension.PetStoreConnector;

@Feature(value="SDK")
@Story(value="Expressions on config-ref parameters")
public class PetStoreExpressionConfigRefTestCase
extends AbstractExtensionFunctionalTestCase {
    @ClassRule
    public static SystemProperty enableDynamicConfigRef = new SystemProperty("mule.experimental.enableDynamicConfigRef", "true");

    protected String getConfigFile() {
        return "petstore-expression-config-ref.xml";
    }

    @Test
    @Description(value="When using a regular static reference it works as always")
    public void getPetsWithReference() throws Exception {
        CoreEvent response = this.runFlow("getPetsWithReference");
        List pets = (List)response.getMessage().getPayload().getValue();
        ConfigurationInstance config = muleContext.getExtensionManager().getConfiguration("paw-patrol-store", this.testEvent());
        Assert.assertThat((Object)config, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        PetStoreConnector configValue = (PetStoreConnector)config.getValue();
        Assert.assertThat((Object)pets, (Matcher)Matchers.containsInAnyOrder((Object[])configValue.getPets().toArray()));
    }

    @Test
    @Description(value="When using an expression involving variables from the event, it resolves the right configuration")
    public void getPetsWithExpression() throws Exception {
        CoreEvent response = ((FlowRunner)this.flowRunner("getPetsWithExpression").withVariable("storeName", (Object)"paw-patrol")).run();
        List pets = (List)response.getMessage().getPayload().getValue();
        ConfigurationInstance config = muleContext.getExtensionManager().getConfiguration("paw-patrol-store", this.testEvent());
        Assert.assertThat((Object)config, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        PetStoreConnector configValue = (PetStoreConnector)config.getValue();
        Assert.assertThat((Object)pets, (Matcher)Matchers.containsInAnyOrder((Object[])configValue.getPets().toArray()));
    }

    @Test
    @Description(value="When using an expression resolving to a global element that is not a config it fails (in runtime) with a proper error message")
    public void getPetsWithExpressionResolvingToNonConfigFails() throws Exception {
        String expectedMessage = "Error resolving configuration for component 'getPetsWithExpressionResolvingToNonConfig'";
        String expectedCauseMessage = "There is no registered configurationProvider under name 'some-non-config'";
        this.flowRunner("getPetsWithExpressionResolvingToNonConfig").runExpectingException(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.instanceOf(IllegalArgumentException.class), ThrowableMessageMatcher.hasMessage((String)expectedMessage), ThrowableCauseMatcher.hasCause((Matcher)ThrowableMessageMatcher.hasMessage((String)expectedCauseMessage))}));
    }

    @Test
    @Description(value="When using an expression resolving to a global element that is a config of an incompatible type it fails (in runtime) with a proper error message")
    public void getPetsWithExpressionResolvingToIncompatibleConfigFails() throws Exception {
        String expectedMessage = "Root component 'getPetsWithExpressionResolvingToIncompatibleConfig' defines an usage of operation 'getPets' which points to configuration 'some-incompatible-config'. The selected config does not support that operation.";
        this.flowRunner("getPetsWithExpressionResolvingToIncompatibleConfig").runExpectingException(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.instanceOf(IllegalArgumentException.class), ThrowableMessageMatcher.hasMessage((String)expectedMessage)}));
    }

    @Test
    @Description(value="When using an expression resolving to an empty string it fails (in runtime) with a proper error message")
    public void getPetsWithExpressionResolvingToEmptyStringFails() throws Exception {
        String expectedMessage = "cannot get configuration from a blank provider name";
        this.flowRunner("getPetsWithExpressionResolvingToEmptyString").runExpectingException(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.instanceOf(IllegalArgumentException.class), ThrowableMessageMatcher.hasMessage((String)expectedMessage)}));
    }

    protected boolean mustRegenerateExtensionModels() {
        return true;
    }
}

