/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamConfig;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamProvider;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.tck.core.streaming.DummyByteBufferManager;
import org.mule.test.heisenberg.extension.model.KnockeableDoor;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.w3c.dom.NodeList;

public class FunctionExecutionTestCase
extends AbstractExtensionFunctionalTestCase {
    private static final String FUNCTIONS_CONFIG_XML = "functions-config.xml";
    private ExtendedExpressionManager expressionManager;

    protected String[] getConfigFiles() {
        return new String[]{FUNCTIONS_CONFIG_XML};
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    @Before
    public void setupManager() {
        this.expressionManager = muleContext.getExpressionManager();
    }

    @Test
    public void echoFromManager() {
        TypedValue result = this.expressionManager.evaluate("Fn::defaultPrimitives()");
        Assert.assertThat((Object)result.getValue(), (Matcher)Matchers.is((Object)"SUCCESS"));
    }

    @Test
    public void echoWithDefault() throws Exception {
        Object value = ((FlowRunner)this.flowRunner("echoWithDefault").withPayload((Object)"sampleData")).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)Matchers.is((Object)"prefix_sampleData"));
    }

    @Test
    public void variableGlobalEcho() throws Exception {
        Object value = ((FlowRunner)this.flowRunner("variableGlobalEcho").withVariable("myMessage", (Object)"sampleData")).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)Matchers.is((Object)"sampleData"));
    }

    @Test
    public void toMap() throws Exception {
        Map value = (Map)this.flowRunner("toMap").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)((String)value.get("user")), (Matcher)Matchers.is((Object)"pepe"));
    }

    @Test
    public void xpathWithDefaults() throws Exception {
        Object value = ((FlowRunner)this.flowRunner("xpathWithDefaults").withPayload((Object)this.getDocumentStream())).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)Matchers.is((Object)"xpathWithDefaults"));
    }

    @Test
    public void xpathWithDefaultNode() throws Exception {
        InputStream stream = this.getDocumentStream();
        InMemoryCursorStreamProvider streamProvider = new InMemoryCursorStreamProvider(stream, InMemoryCursorStreamConfig.getDefault(), (ByteBufferManager)new DummyByteBufferManager());
        Object value = ((FlowRunner)this.flowRunner("xpathWithDefaultNode").withVariable("xmlPayload", (Object)streamProvider)).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)Matchers.is((Object)"xpathWithDefaultNode"));
    }

    @Test
    public void xpathWithOverrides() throws Exception {
        Object value = ((FlowRunner)this.flowRunner("xpathWithOverrides").withVariable("xmlPayload", (Object)this.getDocumentStream())).run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)value, (Matcher)Matchers.instanceOf(NodeList.class));
        Assert.assertThat((Object)((NodeList)value).getLength(), (Matcher)Matchers.is((Object)10));
    }

    @Test
    public void executeAliasedFunctionName() throws Exception {
        TypedValue result = this.expressionManager.evaluate("Fn::partition([1,2,3,4,5,6,7,8], 3)");
        List value = (List)result.getValue();
        Assert.assertThat((Object)value, (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertThat((Object)((List)value.get(0)), (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertThat((Object)((List)value.get(1)), (Matcher)IsCollectionWithSize.hasSize((int)3));
        Assert.assertThat((Object)((List)value.get(2)), (Matcher)IsCollectionWithSize.hasSize((int)2));
    }

    @Test
    public void executeWithTypedValueParameters() throws Exception {
        String xmlString = IOUtils.toString((InputStream)this.getDocumentStream());
        InputStream jsonStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("models/subtypes.json");
        KnockeableDoor knockeableDoor = new KnockeableDoor("Ricky", "Universe 137");
        TypedValue payload = ((FlowRunner)((FlowRunner)((FlowRunner)((FlowRunner)this.flowRunner("typedValueFunction").withPayload((Object)new TypedValue((Object)xmlString, DataType.XML_STRING))).withVariable("door", (Object)TypedValue.of((Object)knockeableDoor))).withVariable("xmlString", (Object)new TypedValue((Object)xmlString, DataType.XML_STRING))).withVariable("jsonStream", (Object)new TypedValue((Object)jsonStream, DataType.builder().type(InputStream.class).mediaType("application/json").build()))).run().getMessage().getPayload();
        List values = (List)payload.getValue();
        Assert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)4));
        Assert.assertThat((Object)this.getValue(values.get(0)), (Matcher)Matchers.is((Object)xmlString));
        Assert.assertThat((Object)this.getValue(values.get(1)), (Matcher)Matchers.is((Object)xmlString));
        Assert.assertThat((Object)this.getValue(values.get(2)), (Matcher)Matchers.is((Object)jsonStream));
        Assert.assertThat((Object)this.getValue(values.get(3)), (Matcher)Matchers.is((Object)knockeableDoor));
    }

    @Test
    public void typedInputStream() throws Exception {
        String result = (String)this.flowRunner("typedInputStream").run().getMessage().getPayload().getValue();
        Assert.assertThat((Object)result, (Matcher)Matchers.containsString((String)"employees"));
    }

    private InputStream getDocumentStream() {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(FUNCTIONS_CONFIG_XML);
    }

    private Object getValue(Object o) {
        return ((TypedValue)o).getValue();
    }
}

