/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources.validator;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.test.util.tck.ExtensionModelTestUtils;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.property.ClassLoaderModelProperty;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.OperationWrapper;
import org.mule.runtime.module.extension.internal.resources.validator.ExportedPackagesValidator;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.test.metadata.extension.model.shapes.Shape;
import org.mule.test.module.extension.api.ApiTestClass;
import org.mule.test.module.extension.internal.InternalTestClass;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.test.vegan.extension.VeganAttributes;

@RunWith(value=MockitoJUnitRunner.class)
public class ExportedPackagesValidatorTestCase {
    private final ClassTypeLoader loader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    @Mock(lenient=true)
    private ExtensionModel extensionModel;

    private static boolean shouldValidate() {
        String skip = System.getProperty("exportedPackagesValidator.skip");
        return skip == null || !Boolean.valueOf(skip).booleanValue();
    }

    @Before
    public void setup() {
        ClassLoaderModelProperty classLoaderModelProperty = new ClassLoaderModelProperty(this.getClass().getClassLoader());
        Mockito.when((Object)this.extensionModel.getModelProperty(ClassLoaderModelProperty.class)).thenReturn(Optional.of(classLoaderModelProperty));
    }

    @Test
    public void invalidExportedPackages() {
        Assume.assumeThat((Object)ExportedPackagesValidatorTestCase.shouldValidate(), (Matcher)CoreMatchers.is((Object)true));
        this.setUpInvalidExtension();
        ExportedPackagesValidator exportedPackagesValidator = new ExportedPackagesValidator();
        ProblemsReporter problemsReporter = new ProblemsReporter(this.extensionModel);
        exportedPackagesValidator.validate(this.extensionModel, problemsReporter);
        List errors = problemsReporter.getErrors();
        MatcherAssert.assertThat((Object)errors, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)IsEmptyCollection.empty())));
        Problem error = (Problem)errors.get(0);
        MatcherAssert.assertThat((Object)error.getComponent(), (Matcher)CoreMatchers.is((Object)this.extensionModel));
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)CoreMatchers.containsString((String)"org.mule.test.module.extension.internal"));
        List warnings = problemsReporter.getWarnings();
        MatcherAssert.assertThat((Object)warnings, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)IsEmptyCollection.empty())));
        Problem warning = (Problem)warnings.get(0);
        MatcherAssert.assertThat((Object)warning.getComponent(), (Matcher)CoreMatchers.is((Object)this.extensionModel));
        MatcherAssert.assertThat((Object)warning.getMessage(), (Matcher)CoreMatchers.containsString((String)"org.mule.test.metadata.extension.model.shapes"));
    }

    @Test
    public void validExportedPackages() {
        this.setUpValidExtension();
        ExportedPackagesValidator exportedPackagesValidator = new ExportedPackagesValidator();
        ProblemsReporter problemsReporter = new ProblemsReporter(this.extensionModel);
        exportedPackagesValidator.validate(this.extensionModel, problemsReporter);
        MatcherAssert.assertThat((Object)problemsReporter.getErrors(), (Matcher)CoreMatchers.is((Matcher)IsEmptyCollection.empty()));
        MatcherAssert.assertThat((Object)problemsReporter.getWarnings(), (Matcher)CoreMatchers.is((Matcher)IsEmptyCollection.empty()));
    }

    private void setUpInvalidExtension() {
        OutputModel appleList = this.mockOutputModel((Type)((Object)InternalTestClass.class));
        OperationModel firstOperation = this.mockOperationModel(appleList, this.mockOutputModel((Type)((Object)InternalTestClass.class)), new ParameterModel[0]);
        this.withMethod(firstOperation, IntrospectionUtils.getApiMethods(InternalTestClass.class).stream().filter(m -> m.getName().equals("someOperation")).findFirst());
        ParameterModel parameter = this.mockParameterModel((Type)((Object)Shape.class));
        OutputModel resultList = this.mockOutputModel(new TypeToken<List<Result<Apple, VeganAttributes>>>(){}.getType());
        OperationModel secondOperation = this.mockOperationModel(resultList, this.mockOutputModel((Type)((Object)List.class)), parameter);
        this.withMethod(secondOperation, Optional.empty());
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(firstOperation, secondOperation));
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{firstOperation, secondOperation});
    }

    private void setUpValidExtension() {
        OutputModel appleList = this.mockOutputModel((Type)((Object)ApiTestClass.class));
        OperationModel firstOperation = this.mockOperationModel(appleList, this.mockOutputModel((Type)((Object)ApiTestClass.class)), new ParameterModel[0]);
        this.withMethod(firstOperation, IntrospectionUtils.getApiMethods(ApiTestClass.class).stream().filter(m -> m.getName().equals("someOperation")).findFirst());
        Mockito.when((Object)this.extensionModel.getOperationModels()).thenReturn(Arrays.asList(firstOperation));
        ExtensionModelTestUtils.visitableMock((ComponentModel[])new ComponentModel[]{firstOperation});
    }

    private void withMethod(OperationModel operationModel, Optional<Method> optionalMethod) {
        Mockito.when((Object)operationModel.getModelProperty(ImplementingMethodModelProperty.class)).thenReturn(optionalMethod.map(ImplementingMethodModelProperty::new));
        Mockito.when((Object)operationModel.getModelProperty(ExtensionOperationDescriptorModelProperty.class)).thenReturn(optionalMethod.map(method -> new ExtensionOperationDescriptorModelProperty((OperationElement)new OperationWrapper(method, this.loader))));
    }

    private OutputModel mockOutputModel(Type type) {
        OutputModel om = (OutputModel)Mockito.mock(OutputModel.class, (MockSettings)Mockito.withSettings().lenient());
        Mockito.when((Object)om.getType()).thenReturn((Object)this.loader.load(type));
        return om;
    }

    private ParameterModel mockParameterModel(Type type) {
        ParameterModel pm = (ParameterModel)Mockito.mock(ParameterModel.class);
        Mockito.when((Object)pm.getType()).thenReturn((Object)this.loader.load(type));
        return pm;
    }

    private OperationModel mockOperationModel(OutputModel output, OutputModel attributes, ParameterModel ... params) {
        OperationModel op = (OperationModel)Mockito.mock(OperationModel.class, (MockSettings)Mockito.withSettings().lenient());
        Mockito.when((Object)op.getOutput()).thenReturn((Object)output);
        Mockito.when((Object)op.getOutputAttributes()).thenReturn((Object)attributes);
        if (params != null) {
            ExtensionsTestUtils.mockParameters((ParameterizedModel)op, (ParameterModel[])params);
        }
        return op;
    }
}

