/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.source;

import io.qameta.allure.Feature;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.test.heisenberg.extension.model.types.DEAOfficerAttributes;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;

@Feature(value="Sources")
public class ListOfMessagesSourceTestCase
extends AbstractExtensionFunctionalTestCase {
    private static AtomicReference<List<Message>> capturedPayload = new AtomicReference<Object>(null);
    private static Latch latch = new Latch();

    protected String getConfigFile() {
        return "source/heisenberg-source-list-config.xml";
    }

    protected void doTearDown() throws Exception {
        capturedPayload = null;
        latch = null;
        super.doTearDown();
    }

    @Test
    public void listenMessages() throws Exception {
        Assert.assertThat((Object)latch.await(5L, TimeUnit.SECONDS), (Matcher)Matchers.is((Object)true));
        List<Message> payload = capturedPayload.get();
        Assert.assertThat(payload, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat(payload, (Matcher)Matchers.hasSize((int)5));
        for (Message message : payload) {
            Assert.assertThat((Object)message.getPayload().getValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(String.class)));
            Assert.assertThat((Object)message.getAttributes().getValue(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DEAOfficerAttributes.class)));
        }
    }

    public static class ListProcessor
    extends AbstractComponent
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            List payload = (List)event.getMessage().getPayload().getValue();
            if (capturedPayload.compareAndSet(null, payload)) {
                latch.release();
            }
            return event;
        }
    }
}

