/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.junit.AfterClass;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.runtime.module.extension.soap.internal.loader.SoapExtensionModelLoader;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=Parameterized.class)
public abstract class ParameterizedExtensionModelTestCase
extends AbstractMuleTestCase {
    protected static Map<String, ExtensionModel> EXTENSION_MODELS = new HashMap<String, ExtensionModel>();
    protected static final ExtensionModelLoader JAVA_LOADER = new DefaultJavaExtensionModelLoader();
    protected static final ExtensionModelLoader SOAP_LOADER = new SoapExtensionModelLoader();
    @Parameterized.Parameter
    public ExtensionModel extensionUnderTest;

    @AfterClass
    public static void cleanUp() {
        EXTENSION_MODELS = new HashMap<String, ExtensionModel>();
    }

    protected static Collection<Object[]> createExtensionModels(List<? extends ExtensionUnitTest> extensions) {
        BiFunction<Class, ExtensionModelLoader, ExtensionModel> createExtensionModel = (extension, loader) -> {
            ExtensionModel model = ParameterizedExtensionModelTestCase.loadExtension(extension, loader);
            if (EXTENSION_MODELS.put(model.getName(), model) != null) {
                throw new IllegalArgumentException(String.format("Extension names must be unique. Name [%s] for extension [%s] was already used", model.getName(), extension.getName()));
            }
            return model;
        };
        return extensions.stream().map(e -> e.toTestParams(createExtensionModel)).collect(Collectors.toList());
    }

    protected static ExtensionModel loadExtension(Class<?> clazz, ExtensionModelLoader loader) {
        SmallMap params = SmallMap.of((Object)"type", (Object)clazz.getName(), (Object)"version", (Object)MuleManifest.getProductVersion(), (Object)"COMPILATION_MODE", (Object)true);
        DslResolvingContext dslResolvingContext = DslResolvingContext.getDefault(new LinkedHashSet<ExtensionModel>(EXTENSION_MODELS.values()));
        final String basePackage = clazz.getPackage().toString();
        ClassLoader pluginClassLoader = new ClassLoader(clazz.getClassLoader()){

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (name.startsWith(basePackage)) {
                    try {
                        byte[] classBytes = IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream("/" + name.replaceAll("\\.", "/") + ".class"));
                        return this.defineClass(null, classBytes, 0, classBytes.length);
                    }
                    catch (Exception e) {
                        return super.loadClass(name);
                    }
                }
                return super.loadClass(name, resolve);
            }
        };
        return loader.loadExtensionModel(pluginClassLoader, dslResolvingContext, (Map)params);
    }

    public static class ExtensionUnitTest {
        final ExtensionModelLoader loader;
        final Class<?> extensionClass;

        protected ExtensionUnitTest(ExtensionModelLoader loader, Class<?> extensionClass) {
            this.loader = loader;
            this.extensionClass = extensionClass;
        }

        static ExtensionUnitTest newTestUnit(ExtensionModelLoader loader, Class<?> extensionClass) {
            return new ExtensionUnitTest(loader, extensionClass);
        }

        ExtensionModelLoader getLoader() {
            return this.loader;
        }

        Class<?> getExtensionClass() {
            return this.extensionClass;
        }

        public final Object[] toTestParams(BiFunction<Class<?>, ExtensionModelLoader, ExtensionModel> createExtensionModel) {
            ExtensionModel extensionModel = createExtensionModel.apply(this.getExtensionClass(), this.getLoader());
            return this.buildTestParams(extensionModel);
        }

        protected Object[] buildTestParams(ExtensionModel extensionModel) {
            return new Object[]{extensionModel};
        }
    }
}

