/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.client;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
@Feature(value="Extensions Client")
public class ExtensionsClientFunctionalTestCase
extends AbstractExtensionFunctionalTestCase {
    private static String MESSAGE_TO_ECHO = "Echo this message!";
    private static String ANOTHER_MESSAGE_TO_ECHO = "Echo this another message!";
    private static String HEISENBERG = "Heisenberg";
    private static String PETSTORE = "Petstore";
    private static String DYNAMIC_DEALER_NAME = "dynamic dealer";
    private static String ANOTHER_DYNAMIC_DEALER_NAME = "another dynamic dealer";
    private static String STATIC_DEALER_NAME_ONE = "Domingo 'Krazy-8' Molina";
    private static String STATIC_DEALER_NAME_TWO = "Skinny Pete";
    private static String DYNAMIC_CONFIG_NAME = "dynamic-heisenberg";
    private static String STATIC_CONFIG_NAME_ONE = "static-heisenberg1";
    private static String STATIC_CONFIG_NAME_TWO = "static-heisenberg2";
    private static String MESSAGELESS_ECHO = " echoed by Heisenberg";
    private static int NUMBER_OF_CALLS = 1000;
    @Parameterized.Parameter(value=0)
    public String parameterizationName;
    @Parameterized.Parameter(value=1)
    public String configName;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"Using Extensions API", "extensions-client-config.xml"}, {"Using SDK API", "sdk-extensions-client-config.xml"});
    }

    protected String getConfigFile() {
        return this.configName;
    }

    @Test
    @Description(value="Verifies the call to the echo operation in the Heisenberg Extension")
    public void testHeisenbergEcho() throws Exception {
        String echoedMessage = (String)((FlowRunner)this.flowRunner("echoHeisenberg").withVariable("message", (Object)MESSAGE_TO_ECHO)).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)echoedMessage, (Matcher)Matchers.containsString((String)MESSAGE_TO_ECHO));
        MatcherAssert.assertThat((Object)echoedMessage, (Matcher)Matchers.containsString((String)HEISENBERG));
    }

    @Test
    @Description(value="Verifies the call to the echo operation in the Pet Store Extension")
    public void testPetStoreEcho() throws Exception {
        String echoedMessage = (String)((FlowRunner)this.flowRunner("echoPetStore").withVariable("message", (Object)MESSAGE_TO_ECHO)).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)echoedMessage, (Matcher)Matchers.containsString((String)MESSAGE_TO_ECHO));
        MatcherAssert.assertThat((Object)echoedMessage, (Matcher)Matchers.containsString((String)PETSTORE));
    }

    @Test
    @Description(value="Verifies calling two operations with the same name but from different extensions")
    public void testOperationsWithTheSameName() throws Exception {
        this.testHeisenbergEcho();
        this.testPetStoreEcho();
        this.testHeisenbergEcho();
        this.testPetStoreEcho();
    }

    @Test
    @Description(value="Verifies the call to an operation using a dynamic configuration Extension")
    public void testDynamicConfig() throws Exception {
        String nameSaid = (String)((FlowRunner)((FlowRunner)this.flowRunner("sayMyName").withVariable("configName", (Object)DYNAMIC_CONFIG_NAME)).withVariable("dealerName", (Object)DYNAMIC_DEALER_NAME)).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)nameSaid, (Matcher)Matchers.is((Object)DYNAMIC_DEALER_NAME));
    }

    @Test
    @Description(value="Verifies the call to an operation using another a dynamic configuration Extension")
    public void testAnotherDynamicConfig() throws Exception {
        String nameSaid = (String)((FlowRunner)((FlowRunner)this.flowRunner("sayMyName").withVariable("configName", (Object)DYNAMIC_CONFIG_NAME)).withVariable("dealerName", (Object)ANOTHER_DYNAMIC_DEALER_NAME)).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)nameSaid, (Matcher)Matchers.is((Object)ANOTHER_DYNAMIC_DEALER_NAME));
    }

    @Test
    @Description(value="Verifies the call to the same operation using the same configuration but resolves to different values")
    public void testDynamicConfigCalledTwice() throws Exception {
        this.testDynamicConfig();
        this.testAnotherDynamicConfig();
        this.testDynamicConfig();
        this.testAnotherDynamicConfig();
    }

    @Test
    @Description(value="Verifies a call to an operation with a static configuration")
    public void testStaticConfig() throws Exception {
        String nameSaid = (String)((FlowRunner)this.flowRunner("sayMyName").withVariable("configName", (Object)STATIC_CONFIG_NAME_ONE)).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)nameSaid, (Matcher)Matchers.is((Object)STATIC_DEALER_NAME_ONE));
    }

    @Test
    @Description(value="Verifies a call to an operation with another static configuration")
    public void testAnotherStaticConfig() throws Exception {
        String nameSaid = (String)((FlowRunner)this.flowRunner("sayMyName").withVariable("configName", (Object)STATIC_CONFIG_NAME_TWO)).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)nameSaid, (Matcher)Matchers.is((Object)STATIC_DEALER_NAME_TWO));
    }

    @Test
    @Description(value="Verifies calls to an operation twice with different static configurations")
    public void testCallTwiceWithDifferentStaticConfigs() throws Exception {
        this.testStaticConfig();
        this.testAnotherStaticConfig();
        this.testStaticConfig();
        this.testAnotherStaticConfig();
    }

    @Test
    @Description(value="Calls the client to execute an operation with a parameter that do not support expressions")
    public void testParameterThatDoNotSupportExpressions() throws Exception {
        String echoedMessage = (String)((FlowRunner)this.flowRunner("echoStaticMessage").withVariable("message", (Object)MESSAGE_TO_ECHO)).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)echoedMessage, (Matcher)Matchers.containsString((String)MESSAGE_TO_ECHO));
    }

    @Test
    @Description(value="Calls the client to execute an operation with a parameter that do not support expressions")
    public void testAnotherParameterThatDoNotSupportExpressions() throws Exception {
        String echoedMessage = (String)((FlowRunner)this.flowRunner("echoStaticMessage").withVariable("message", (Object)ANOTHER_MESSAGE_TO_ECHO)).run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)echoedMessage, (Matcher)Matchers.containsString((String)ANOTHER_MESSAGE_TO_ECHO));
    }

    @Test
    @Description(value="Calls the client to execute an operation with a parameter that do not support expressions")
    public void testParameterThatDoNotSupportExpressionsTwice() throws Exception {
        this.testParameterThatDoNotSupportExpressions();
        this.testAnotherParameterThatDoNotSupportExpressions();
        this.testParameterThatDoNotSupportExpressions();
        this.testAnotherParameterThatDoNotSupportExpressions();
    }

    @Test
    @Description(value="Verifies calling an operation without an optional parameter")
    public void testOptionalParameter() throws Exception {
        String echoedMessage = (String)this.flowRunner("echoWithoutMessage").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)echoedMessage, (Matcher)Matchers.is((Object)MESSAGELESS_ECHO));
    }

    @Test
    @Description(value="Verifies that the client remains consistent after multiple calls")
    public void testMultipleCalls() throws Exception {
        for (int i = 0; i < NUMBER_OF_CALLS; ++i) {
            this.testCallTwiceWithDifferentStaticConfigs();
            this.testDynamicConfigCalledTwice();
            this.testOperationsWithTheSameName();
            this.testParameterThatDoNotSupportExpressionsTwice();
            this.testOptionalParameter();
        }
    }
}

