/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.extension.test.extension.reconnection.ReconnectionExtension;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;
import org.mule.runtime.module.extension.internal.FileGenerationParameterizedExtensionModelTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.test.data.sample.extension.SampleDataExtension;
import org.mule.test.function.extension.WeaveFunctionExtension;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.implicit.config.extension.extension.api.ImplicitConfigExtension;
import org.mule.test.marvel.MarvelExtension;
import org.mule.test.metadata.extension.MetadataExtension;
import org.mule.test.nonimplicit.config.extension.extension.api.NonImplicitConfigExtension;
import org.mule.test.oauth.TestOAuthExtension;
import org.mule.test.petstore.extension.PetStoreConnector;
import org.mule.test.ram.RickAndMortyExtension;
import org.mule.test.semantic.extension.SemanticTermsExtension;
import org.mule.test.substitutiongroup.extension.SubstitutionGroupExtension;
import org.mule.test.subtypes.extension.SubTypesMappingConnector;
import org.mule.test.transactional.TransactionalExtension;
import org.mule.test.typed.value.extension.extension.TypedValueExtension;
import org.mule.test.values.extension.ValuesExtension;
import org.mule.test.vegan.extension.VeganExtension;
import org.skyscreamer.jsonassert.JSONAssert;

@SmallTest
@RunWith(value=Parameterized.class)
public class ExtensionModelJsonGeneratorTestCase
extends FileGenerationParameterizedExtensionModelTestCase {
    private static final boolean UPDATE_EXPECTED_FILES_ON_ERROR = Boolean.getBoolean("mule.extensionModelJson.updateExpectedFilesOnError");
    private final ExtensionModelJsonSerializer generator = new ExtensionModelJsonSerializer(true);

    @Parameterized.Parameters(name="{1}")
    public static Collection<Object[]> data() {
        List<FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest> extensions = Arrays.asList(FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, VeganExtension.class, "vegan.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, PetStoreConnector.class, "petstore.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, MetadataExtension.class, "metadata.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, HeisenbergExtension.class, "heisenberg.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, SubstitutionGroupExtension.class, "substitutiongroup.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, TransactionalExtension.class, "tx-ext.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, SubTypesMappingConnector.class, "subtypes.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, MarvelExtension.class, "marvel.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(SOAP_LOADER, RickAndMortyExtension.class, "ram.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, TypedValueExtension.class, "typed-value.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, TestOAuthExtension.class, "test-oauth.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, WeaveFunctionExtension.class, "test-fn.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, ValuesExtension.class, "values.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, SampleDataExtension.class, "sample-data.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, ImplicitConfigExtension.class, "implicit-config.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, NonImplicitConfigExtension.class, "non-implicit-config.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, SemanticTermsExtension.class, "semantic-terms-extension.json"), FileGenerationParameterizedExtensionModelTestCase.ResourceExtensionUnitTest.newUnitTest(JAVA_LOADER, ReconnectionExtension.class, "reconnection-extension.json"));
        return ExtensionModelJsonGeneratorTestCase.createExtensionModels(extensions);
    }

    @Override
    protected boolean shouldUpdateExpectedFilesOnError() {
        return UPDATE_EXPECTED_FILES_ON_ERROR;
    }

    @Override
    protected String getExpectedFilesDir() {
        return "models/";
    }

    @Override
    protected String doGenerate(ExtensionModel extensionUnderTest) throws Exception {
        return this.generator.serialize(extensionUnderTest).trim();
    }

    @Override
    protected void assertEquals(String expectedContent, String actualContent) throws Exception {
        JSONAssert.assertEquals((String)expectedContent, (String)actualContent, (boolean)true);
    }

    @Test
    public void load() {
        ExtensionModel result = this.generator.deserialize(this.expectedContent);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)this.extensionUnderTest));
    }
}

