/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.transaction;

import java.util.Arrays;
import java.util.Collection;
import javax.transaction.TransactionManager;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.util.func.CheckedSupplier;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.runner.RunnerDelegateTo;
import org.mule.test.transactional.SdkTransactionalSource;
import org.mule.test.transactional.TransactionalSource;
import org.mule.test.transactional.connection.MessageStorage;
import org.mule.test.transactional.connection.SdkTestTransactionalConnection;
import org.mule.test.transactional.connection.TestTransactionalConnection;

@RunnerDelegateTo(value=Parameterized.class)
public class TransactionalSourceTestCase
extends AbstractExtensionFunctionalTestCase {
    private boolean isSdkApi;
    private String configFile;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"Using Extensions API", false, "source-transaction-config.xml"}, {"Using SDK API", true, "sdk-source-transaction-config.xml"});
    }

    public TransactionalSourceTestCase(String parametrizationName, boolean isSdkApi, String configFile) {
        this.isSdkApi = isSdkApi;
        this.configFile = configFile;
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    @Before
    public void setUp() throws Exception {
        MessageStorage.clean();
        TransactionalSource.isSuccess = null;
        SdkTransactionalSource.isSuccess = null;
        muleContext.setTransactionManager((TransactionManager)Mockito.mock(TransactionManager.class));
    }

    @After
    public void tearDown() {
        MessageStorage.clean();
        TransactionalSource.isSuccess = null;
        SdkTransactionalSource.isSuccess = null;
    }

    @Test
    public void sourceStartsALocalTxAndGetsCommitted() throws Exception {
        this.startFlow("sourceStartsALocalTxAndGetsCommitted");
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> !MessageStorage.messages.isEmpty()));
        this.validateFlow(true);
        this.validateCommittedTransaction(MessageStorage.messages.poll());
    }

    @Test
    public void sourceStartsALocalTxAndGetsRollBacked() throws Exception {
        this.startFlow("sourceStartsALocalTxAndGetsRollBacked");
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> !MessageStorage.messages.isEmpty()));
        this.validateFlow(false);
        this.validateRolledBackedTransaction(MessageStorage.messages.poll());
    }

    @Test
    public void sourceStartsALocalTxAndOperationsCanJointIt() throws Exception {
        this.startFlow("sourceStartsALocalTxAndOperationsCanJointIt");
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> MessageStorage.messages.size() == 2));
        this.validateFlow(true);
        this.validateCommittedTransaction(MessageStorage.messages.peek());
    }

    @Test
    public void sourceStartsALocalTxAndOperationsWithDifferentConnectionCanTJoinIt() throws Exception {
        this.startFlow("sourceStartsALocalTxAndOperationsWithDifferentConnectionCanTJoinIt");
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> MessageStorage.exception != null));
        MatcherAssert.assertThat((Object)MessageStorage.exception, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(TransactionException.class)));
        this.validateFlow(false);
        this.validateRolledBackedTransaction(MessageStorage.messages.poll());
    }

    @Test
    public void nonTxSourceDoesntBeginTx() throws Exception {
        this.startFlow("nonTxSourceDoesntBeginTx");
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> !MessageStorage.messages.isEmpty()));
        this.validateFlow(true);
        this.validateNonTxConnection(MessageStorage.messages.poll());
    }

    @Test
    public void nonTxSourceWithNonTxOperation() throws Exception {
        this.startFlow("nonTxSourceWithNonTxOperation");
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> !MessageStorage.messages.isEmpty()));
        this.validateFlow(true);
        this.validateNonTxConnection(MessageStorage.messages.poll());
    }

    @Test
    public void nonTxSourceWithTxInside() throws Exception {
        this.startFlow("nonTxSourceWithTxInside");
        this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> !MessageStorage.messages.isEmpty()));
        this.validateFlow(true);
        this.validateNonTxConnection(MessageStorage.messages.poll());
    }

    private void startFlow(String flowName) throws Exception {
        ((Flow)this.getFlowConstruct(flowName)).start();
    }

    private void validate(CheckedSupplier<Boolean> validation) {
        new PollingProber(10000L, 100L).check((Probe)new JUnitLambdaProbe(validation));
    }

    private void validateCommittedTransaction(Object connection) {
        this.assertTransactionConnectionState(connection, true, true, false);
    }

    private void validateRolledBackedTransaction(Object connection) {
        this.assertTransactionConnectionState(connection, true, false, true);
    }

    private void validateNonTxConnection(Object connection) {
        this.assertTransactionConnectionState(connection, false, false, false);
    }

    private void validateFlow(boolean succeeded) {
        if (this.isSdkApi) {
            this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> SdkTransactionalSource.isSuccess != null));
            MatcherAssert.assertThat((Object)SdkTransactionalSource.isSuccess, (Matcher)CoreMatchers.is((Object)succeeded));
        } else {
            this.validate((CheckedSupplier<Boolean>)((CheckedSupplier)() -> TransactionalSource.isSuccess != null));
            MatcherAssert.assertThat((Object)TransactionalSource.isSuccess, (Matcher)CoreMatchers.is((Object)succeeded));
        }
    }

    private void assertTransactionConnectionState(Object connection, boolean begun, boolean committed, boolean rolledBack) {
        if (connection instanceof TestTransactionalConnection) {
            MatcherAssert.assertThat((Object)((TestTransactionalConnection)connection).isTransactionBegun(), (Matcher)CoreMatchers.is((Object)begun));
            MatcherAssert.assertThat((Object)((TestTransactionalConnection)connection).isTransactionCommited(), (Matcher)CoreMatchers.is((Object)committed));
            MatcherAssert.assertThat((Object)((TestTransactionalConnection)connection).isTransactionRolledback(), (Matcher)CoreMatchers.is((Object)rolledBack));
        } else if (connection instanceof SdkTestTransactionalConnection) {
            MatcherAssert.assertThat((Object)((SdkTestTransactionalConnection)connection).isTransactionBegun(), (Matcher)CoreMatchers.is((Object)begun));
            MatcherAssert.assertThat((Object)((SdkTestTransactionalConnection)connection).isTransactionCommited(), (Matcher)CoreMatchers.is((Object)committed));
            MatcherAssert.assertThat((Object)((SdkTestTransactionalConnection)connection).isTransactionRolledback(), (Matcher)CoreMatchers.is((Object)rolledBack));
        } else {
            throw new RuntimeException("Stored object is not a valid type of connection");
        }
    }
}

